/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.edit.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecoretools.diagram.edit.commands.RestoreRelatedLinksCommand;
import org.eclipse.emf.ecoretools.diagram.edit.parts.EReferenceUtils;
import org.eclipse.emf.ecoretools.diagram.part.EcoreLinkDescriptor;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.DeferredLayoutCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.View;

public class ArrangeRelatedNodesCommand
extends RestoreRelatedLinksCommand {
    public ArrangeRelatedNodesCommand(DiagramEditPart diagramEditPart, List<?> selection) {
        super(diagramEditPart, selection);
    }

    @Override
    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ArrayList<View> views = new ArrayList<View>();
        for (Object object : this.adapters) {
            if (object instanceof IAdaptable) {
                IAdaptable ad = (IAdaptable)object;
                View view = (View)ad.getAdapter(View.class);
                if (view == null) continue;
                views.add(view);
                continue;
            }
            if (!(object instanceof View)) continue;
            views.add((View)object);
        }
        this.arrangeRelatedNodes(views);
        return CommandResult.newOKCommandResult();
    }

    protected void arrangeRelatedNodes(List<View> notationViews) {
        DeferredLayoutCommand cmd;
        HashMap<EObject, View> domain2NotationMap = new HashMap<EObject, View>();
        ArrayList<View> relatedNodes = new ArrayList<View>();
        relatedNodes.addAll(notationViews);
        for (View notationView : notationViews) {
            Collection<? extends EcoreLinkDescriptor> linkDescriptors = this.collectPartRelatedLinks(notationView, domain2NotationMap);
            relatedNodes.addAll(this.getRelatedMissingNodes(linkDescriptors, domain2NotationMap));
        }
        ArrayList<EObjectAdapter> adapters = new ArrayList<EObjectAdapter>();
        for (View view : relatedNodes) {
            if (view.eContainer() != this.diagram) continue;
            adapters.add(new EObjectAdapter((EObject)view));
        }
        if (adapters.size() > 1 && (cmd = new DeferredLayoutCommand(this.host.getEditingDomain(), adapters, (IGraphicalEditPart)this.host)) != null && cmd.canExecute()) {
            EReferenceUtils.executeCommand((Command)new ICommandProxy((ICommand)cmd), (IGraphicalEditPart)this.host);
        }
    }

    protected List<View> getRelatedMissingNodes(Collection<? extends EcoreLinkDescriptor> linkDescriptors, Map<EObject, View> domain2NotationMap) {
        this.mapModel((View)this.diagram, domain2NotationMap);
        ArrayList<View> relatedNodes = new ArrayList<View>();
        for (EcoreLinkDescriptor ecoreLinkDescriptor : linkDescriptors) {
            View sourceView = domain2NotationMap.get(ecoreLinkDescriptor.getSource());
            View targetView = domain2NotationMap.get(ecoreLinkDescriptor.getDestination());
            if (sourceView != null && !relatedNodes.contains(sourceView)) {
                relatedNodes.add(sourceView);
            }
            if (targetView == null || relatedNodes.contains(targetView)) continue;
            relatedNodes.add(targetView);
        }
        return relatedNodes;
    }
}

