/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.part;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecoretools.diagram.edit.commands.EcoreCreateShortcutDecorationsCommand;
import org.eclipse.emf.ecoretools.diagram.edit.parts.EPackageEditPart;
import org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditorPlugin;
import org.eclipse.emf.ecoretools.diagram.part.EcoreElementChooserDialog;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class CreateShortcutHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection != null && !selection.isEmpty() && selection instanceof StructuredSelection) {
            Object firstElt = ((StructuredSelection)selection).getFirstElement();
            TransactionalEditingDomain editingDomain = ((EPackageEditPart)((Object)firstElt)).getEditingDomain();
            if (firstElt instanceof EPackageEditPart) {
                EObject selectedElement;
                View view = (View)((EPackageEditPart)((Object)firstElt)).getModel();
                EcoreElementChooserDialog elementChooser = new EcoreElementChooserDialog(HandlerUtil.getActiveShellChecked((ExecutionEvent)event), view);
                int result = elementChooser.open();
                if (result != 0) {
                    return null;
                }
                URI selectedModelElementURI = elementChooser.getSelectedModelElementURI();
                try {
                    selectedElement = editingDomain.getResourceSet().getEObject(selectedModelElementURI, true);
                }
                catch (WrappedException e) {
                    EcoreDiagramEditorPlugin.getInstance().logError("Exception while loading object: " + selectedModelElementURI.toString(), e);
                    return null;
                }
                if (selectedElement == null) {
                    return null;
                }
                CreateViewRequest.ViewDescriptor viewDescriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter(selectedElement), Node.class, null, EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                CreateCommand command = new CreateCommand(editingDomain, viewDescriptor, view);
                command = command.compose((IUndoableOperation)new EcoreCreateShortcutDecorationsCommand(editingDomain, view, viewDescriptor));
                try {
                    OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    EcoreDiagramEditorPlugin.getInstance().logError("Unable to create shortcut", e);
                }
            }
        }
        return null;
    }
}

