/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.filters.internal.commands;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecoretools.filters.internal.Messages;
import org.eclipse.emf.ecoretools.filters.internal.utils.DiagramFilterUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterDiagramCommand
extends AbstractTransactionalCommand {
    private Diagram diagramToFilter;
    private List<String> typesToFilter;
    private boolean show;

    public FilterDiagramCommand(TransactionalEditingDomain domain, Diagram diagramToFilter, List<String> typesToFilter, boolean show) {
        super(domain, Messages.FilterDiagramCommand_FilterDiagram, null);
        this.diagramToFilter = diagramToFilter;
        this.typesToFilter = typesToFilter;
        this.show = show;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) {
        List<String> allTypes = DiagramFilterUtil.getAllPossibleFilteredType(this.diagramToFilter);
        TreeIterator it = this.diagramToFilter.eAllContents();
        while (it.hasNext()) {
            EObject currentDiagramElement = (EObject)it.next();
            if (!(currentDiagramElement instanceof View)) continue;
            if (DiagramFilterUtil.isFilteredType((View)currentDiagramElement, allTypes)) {
                ((View)currentDiagramElement).setVisible(true);
            }
            if (!DiagramFilterUtil.isFilteredType((View)currentDiagramElement, this.typesToFilter)) continue;
            ((View)currentDiagramElement).setVisible(this.show);
        }
        return CommandResult.newOKCommandResult();
    }
}

