/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.tabbedproperties.sections.widgets;

import org.eclipse.emf.ecoretools.tabbedproperties.internal.Messages;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class SearchableTree
extends Composite {
    private static boolean caseSensitive = true;
    private Text searchField;
    private Button sensitiveBt;
    private TreeViewer treeViewer;
    private IStructuredSelection initialSelection;

    public SearchableTree(Composite parent, int style) {
        super(parent, 0);
        this.createContents(this, style);
        this.hookListeners();
    }

    protected void createContents(Composite parent, int style) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        this.createSearchComp(parent);
        this.createTree(parent, style);
    }

    private void createSearchComp(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(768));
        Label searchLbl = new Label(main, 0);
        searchLbl.setText(Messages.SearchableTree_Search);
        this.searchField = new Text(main, 2048);
        this.searchField.setLayoutData((Object)new GridData(768));
        this.sensitiveBt = new Button(main, 32);
        this.sensitiveBt.setText(Messages.SearchableTree_CaseSensitive);
        this.sensitiveBt.setSelection(caseSensitive);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.sensitiveBt.setLayoutData((Object)gd);
    }

    private void createTree(Composite parent, int style) {
        this.treeViewer = new TreeViewer(parent, 0xB00 | style);
        this.treeViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.treeViewer.addFilter((ViewerFilter)new SearchFilter());
    }

    protected void hookListeners() {
        this.searchField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchableTree.this.refresh();
            }
        });
        this.sensitiveBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                caseSensitive = SearchableTree.this.sensitiveBt.getSelection();
                SearchableTree.this.refresh();
            }
        });
    }

    protected void refresh() {
        this.treeViewer.refresh();
        this.treeViewer.setSelection((ISelection)this.initialSelection);
        if (((IStructuredSelection)this.treeViewer.getSelection()).size() == 0 && this.treeViewer.getTree().getItems().length > 0) {
            TreeItem item = this.treeViewer.getTree().getItem(0);
            this.treeViewer.getTree().setSelection(new TreeItem[]{item});
        }
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void setContentProvider(ITreeContentProvider provider) {
        this.treeViewer.setContentProvider((IContentProvider)provider);
    }

    public void setLabelProvider(ILabelProvider provider) {
        this.treeViewer.setLabelProvider((IBaseLabelProvider)provider);
    }

    public void setInput(Object input) {
        this.treeViewer.setInput(input);
    }

    public void setInitialSelection(IStructuredSelection selection) {
        this.initialSelection = selection;
        this.treeViewer.setSelection((ISelection)this.initialSelection);
    }

    private class SearchFilter
    extends ViewerFilter {
        private SearchFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            IBaseLabelProvider provider;
            String searchedText = SearchableTree.this.searchField.getText();
            boolean isCaseSensitive = SearchableTree.this.sensitiveBt.getSelection();
            if (searchedText != null & !"".equals(searchedText) && (provider = SearchableTree.this.treeViewer.getLabelProvider()) instanceof ILabelProvider) {
                String text = ((ILabelProvider)provider).getText(element);
                if (!isCaseSensitive) {
                    text = text.toLowerCase();
                    searchedText = searchedText.toLowerCase();
                }
                return text.indexOf(searchedText) != -1;
            }
            return true;
        }
    }
}

