/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.filters.internal.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecoretools.filters.internal.FilterPlugin;
import org.eclipse.emf.ecoretools.filters.internal.Messages;
import org.eclipse.emf.ecoretools.filters.internal.commands.FilterTypeSelectionCommand;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HideTypeAction
extends Action {
    protected IGraphicalEditPart host;
    public static String ID = "hideTypeAction";

    public HideTypeAction() {
        this.setId(ID);
        this.setText(Messages.HideTypeAction_HideVisualType);
        this.setToolTipText(Messages.HideTypeAction_HideVisualType_tooltip);
        this.setImageDescriptor(FilterPlugin.getImageDescriptor("icons/etool16/hidetype_exec.gif"));
    }

    private Diagram getCurrentDiagram() {
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (!(editorPart instanceof DiagramEditor)) {
            return null;
        }
        this.host = ((DiagramEditor)editorPart).getDiagramEditPart();
        if (!(this.host instanceof IGraphicalEditPart)) {
            return null;
        }
        View view = (View)this.host.getModel();
        Diagram diagram = view.getDiagram();
        return diagram;
    }

    private List<String> getSelection() {
        ArrayList<String> typeSelected = new ArrayList<String>();
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return Collections.emptyList();
        }
        for (Object object : ((IStructuredSelection)selection).toList()) {
            View view;
            if (!(object instanceof IGraphicalEditPart) || object instanceof DiagramEditPart || (view = ((IGraphicalEditPart)object).getNotationView()) == null || typeSelected.contains(view.getType())) continue;
            typeSelected.add(view.getType());
        }
        return typeSelected;
    }

    public void run() {
        List<String> selection = this.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Diagram diagram = this.getCurrentDiagram();
        if (diagram == null) {
            return;
        }
        ICommandProxy cmd = new ICommandProxy((ICommand)new FilterTypeSelectionCommand(this.host.getEditingDomain(), diagram, selection, false));
        DiagramCommandStack commandStack = this.host.getDiagramEditDomain().getDiagramCommandStack();
        commandStack.execute((Command)cmd, (IProgressMonitor)new NullProgressMonitor());
    }

    public boolean isEnabled() {
        return !this.getSelection().isEmpty();
    }
}

