/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.part;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.ecoretools.diagram.Messages;
import org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditor;
import org.eclipse.emf.ecoretools.diagram.part.INavigationListener;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gmf.runtime.notation.Diagram;

public class NavigationManager {
    private EcoreDiagramEditor editor;
    private int previousLimit = 30;
    private Stack<Diagram> previousDiagrams = new Stack();
    private Stack<Diagram> nextDiagrams = new Stack();
    private List<INavigationListener> eventListeners = new ArrayList<INavigationListener>();

    public NavigationManager(EcoreDiagramEditor editor) {
        this.editor = editor;
    }

    public void addNavigationListener(INavigationListener listener) {
        this.eventListeners.add(listener);
    }

    public void removeNavigationListener(INavigationListener listener) {
        this.eventListeners.remove(listener);
    }

    public void notifyListeners(Diagram newDiagram) {
        int i = 0;
        while (i < this.eventListeners.size()) {
            this.eventListeners.get(i).diagramChanged(newDiagram);
            ++i;
        }
    }

    public boolean canDoPrevious() {
        return !this.previousDiagrams.isEmpty();
    }

    public boolean canDoNext() {
        return !this.nextDiagrams.isEmpty();
    }

    public void previous() {
        Diagram oldDiagram = this.editor.getDiagram();
        Diagram prevDiagram = this.previousDiagrams.pop();
        this.getEditorCommandStack().execute(this.createNavigateCommand(prevDiagram.getDiagram()));
        this.nextDiagrams.add(oldDiagram);
        this.notifyListeners(prevDiagram.getDiagram());
    }

    public void next() {
        Diagram oldDiagram = this.editor.getDiagram();
        Diagram nextDiagram = this.nextDiagrams.pop();
        this.getEditorCommandStack().execute(this.createNavigateCommand(nextDiagram.getDiagram()));
        this.previousDiagrams.add(oldDiagram);
        this.notifyListeners(nextDiagram.getDiagram());
    }

    private Command createNavigateCommand(Diagram newDiagram) {
        return new ChangeActiveDiagramCommand(this.editor, newDiagram);
    }

    public void set(Diagram newDiagram) {
        Diagram oldDiagram = this.editor.getDiagram();
        if (oldDiagram != newDiagram || oldDiagram == null && newDiagram == null) {
            this.getEditorCommandStack().execute(this.createNavigateCommand(newDiagram));
            this.nextDiagrams.clear();
            this.addPreviousDiagram(this.editor, oldDiagram);
            this.notifyListeners(newDiagram);
        }
    }

    private void addPreviousDiagram(EcoreDiagramEditor previousModeler, Diagram diag) {
        if (diag != null) {
            if (this.getPreviousLimit() > 0) {
                while (this.previousDiagrams.size() >= this.getPreviousLimit()) {
                    this.previousDiagrams.remove(0);
                }
            }
            this.previousDiagrams.push(diag);
        }
    }

    public int getPreviousLimit() {
        return this.previousLimit;
    }

    private CommandStack getEditorCommandStack() {
        return (CommandStack)this.editor.getAdapter(CommandStack.class);
    }

    private class ChangeActiveDiagramCommand
    extends Command {
        private EcoreDiagramEditor editor;
        private Diagram oldDiagram;
        private Diagram newDiagram;

        public ChangeActiveDiagramCommand(EcoreDiagramEditor ed, Diagram newDiag) {
            super(Messages.NavigationManager_CreateDiagram);
            this.editor = ed;
            this.newDiagram = newDiag;
        }

        public boolean canExecute() {
            return this.editor != null;
        }

        public boolean canUndo() {
            return this.editor != null;
        }

        public void execute() {
            this.oldDiagram = this.editor.getDiagram();
            this.redo();
        }

        public void redo() {
            this.editor.changeActiveDiagram(this.newDiagram);
        }

        public void undo() {
            this.editor.changeActiveDiagram(this.oldDiagram);
        }
    }
}

