/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.tabbedproperties.sections.widgets;

import java.util.ArrayList;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.AbstractTabbedPropertySection;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.widgets.ChooseDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class CSingleObjectChooser
extends Composite {
    private Text field;
    private Button chooseBt;
    private Object[] objects;
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private ILabelProvider labelProvider;
    private Object selectedObject;
    private AbstractTabbedPropertySection section;

    public CSingleObjectChooser(Composite parent, TabbedPropertySheetWidgetFactory factory, int style) {
        super(parent, style);
        this.widgetFactory = factory;
        this.createContents(this);
        this.widgetFactory.adapt((Composite)this);
        this.hookListeners();
    }

    protected void createContents(Composite parent) {
        this.setLayout(parent);
        this.field = this.widgetFactory.createText(parent, "", 0x800808);
        this.field.setLayoutData((Object)new GridData(768));
        this.chooseBt = this.widgetFactory.createButton(parent, "...", 8);
    }

    private void setLayout(Composite parent) {
        int numColumns = this.getNumberOfColumns();
        if (numColumns < 2) {
            numColumns = 2;
        }
        GridLayout layout = new GridLayout(numColumns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
    }

    protected int getNumberOfColumns() {
        return 2;
    }

    protected void hookListeners() {
        this.chooseBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CSingleObjectChooser.this.handleChoose();
            }
        });
    }

    public void setChoices(Object[] objs) {
        if (objs != null && objs.length > 0) {
            Object[] objects2 = new Object[objs.length];
            int cpt = 0;
            while (cpt < objs.length) {
                objects2[cpt] = objs[cpt] == null ? new NullObject() : objs[cpt];
                ++cpt;
            }
            this.objects = objects2;
        }
        this.setSelection(null);
    }

    public void setEditable(boolean isEditable) {
        if (this.field != null) {
            this.field.setEditable(isEditable);
        }
    }

    public void setLabelProvider(ILabelProvider provider) {
        this.labelProvider = provider;
    }

    private void handleChoose() {
        this.section.refresh();
        ChooseDialog dialog = new ChooseDialog(this.getShell(), this.objects);
        dialog.setLabelProvider(this.labelProvider);
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        selectedObjects.add(this.selectedObject);
        dialog.setInitialElementSelections(selectedObjects);
        if (dialog.open() == 0) {
            Object[] selection = dialog.getResult();
            if (selection != null && selection.length > 0) {
                this.setSelection(selection[0]);
            } else {
                this.setSelection(null);
            }
            Event e = new Event();
            this.notifyListeners(13, e);
        }
    }

    public void setChangeable(boolean isChangeable) {
        this.chooseBt.setEnabled(isChangeable);
    }

    public Object getSelection() {
        return this.selectedObject;
    }

    public void setSelection(Object selection) {
        this.selectedObject = selection instanceof NullObject ? null : selection;
        String name = "";
        if (this.selectedObject != null && (name = this.labelProvider.getText(this.selectedObject)) == null) {
            name = "";
        }
        this.field.setText(name);
    }

    public void addSelectionListener(SelectionListener listener) {
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)listener);
    }

    protected TabbedPropertySheetWidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.field.setEnabled(enabled);
        this.chooseBt.setEnabled(enabled);
    }

    public void setSection(AbstractTabbedPropertySection abstractTabbedPropertySection) {
        this.section = abstractTabbedPropertySection;
    }

    static class NullObject {
        NullObject() {
        }

        public String toString() {
            return "";
        }

        public boolean equals(Object obj) {
            return obj instanceof NullObject;
        }
    }
}

