/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.history.util.DependencyChecker;
import org.eclipse.emf.edapt.spi.history.Change;
import org.eclipse.emf.edapt.spi.history.Delete;
import org.eclipse.emf.edapt.spi.history.History;
import org.eclipse.emf.edapt.spi.history.HistoryPackage;
import org.eclipse.emf.edapt.spi.history.MigrationChange;
import org.eclipse.emf.edapt.spi.history.OperationChange;
import org.eclipse.emf.edapt.spi.history.Release;

public class MoveChecker {
    private MoveChecker() {
    }

    public static boolean canBeMoved(List<Change> changes, EObject target) {
        try {
            List<Change> children = MoveChecker.getChanges(MoveChecker.getChildren(target));
            return MoveChecker.canBeMoved(changes, target, children.size());
        }
        catch (IllegalStateException ex) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canBeMoved(List<Change> changes, EObject target, int targetIndex) {
        try {
            if (!MoveChecker.allowedTarget(changes, target)) {
                return false;
            }
            Iterator<Change> iterator = changes.iterator();
            while (true) {
                List<Change> difference;
                if (!iterator.hasNext()) {
                    return true;
                }
                Change change = iterator.next();
                EObject source = change.eContainer();
                int sourceIndex = MoveChecker.getIndex(change);
                if (source == target && sourceIndex == targetIndex) continue;
                if (MoveChecker.before(source, sourceIndex, target, targetIndex)) {
                    difference = MoveChecker.getDifference(source, sourceIndex + 1, target, targetIndex);
                    difference.removeAll(changes);
                    if (!DependencyChecker.depends(difference, Collections.singletonList(change))) continue;
                    return false;
                }
                difference = MoveChecker.getDifference(target, targetIndex, source, sourceIndex - 1);
                difference.removeAll(changes);
                if (DependencyChecker.depends(change, difference)) break;
            }
            return false;
        }
        catch (IllegalStateException ex) {
            return false;
        }
    }

    private static boolean allowedTarget(List<Change> changes, EObject target) {
        EObject box = MoveChecker.getBox(target);
        if (box != null) {
            for (Change change : changes) {
                if (box == MoveChecker.getBox(change.eContainer())) continue;
                return false;
            }
            return true;
        }
        for (Change change : changes) {
            if (MoveChecker.getBox(change.eContainer()) == null) continue;
            return false;
        }
        return true;
    }

    private static EObject getBox(EObject element) {
        while (element != null) {
            if (element instanceof OperationChange || element instanceof MigrationChange) {
                return element;
            }
            element = element.eContainer();
        }
        return null;
    }

    private static List<Change> getDifference(EObject source, int sourceIndex, EObject target, int targetIndex) {
        ArrayList<Change> difference = new ArrayList<Change>();
        if (source == target) {
            List elements = MoveChecker.getChildren(source);
            targetIndex = Math.min(targetIndex, elements.size() - 1);
            List<Change> changes = MoveChecker.getChanges(elements.subList(sourceIndex, targetIndex + 1));
            difference.addAll(changes);
        } else if (MoveChecker.contains(source, target)) {
            List elements = MoveChecker.getChildren(target);
            targetIndex = Math.min(targetIndex, elements.size() - 1);
            List<Change> changes = MoveChecker.getChanges(elements.subList(0, targetIndex + 1));
            difference.addAll(changes);
            difference.addAll(MoveChecker.getDifference(source, sourceIndex, target.eContainer(), MoveChecker.getIndex(target)));
        } else {
            List elements = MoveChecker.getChildren(source);
            List<Change> changes = MoveChecker.getChanges(elements.subList(sourceIndex, elements.size()));
            difference.addAll(changes);
            difference.addAll(MoveChecker.getDifference(source.eContainer(), source instanceof Delete ? MoveChecker.getIndex(source) : MoveChecker.getIndex(source) + 1, target, targetIndex));
        }
        return difference;
    }

    private static List<Change> getChanges(List elements) {
        ArrayList<Change> changes = new ArrayList<Change>();
        for (Object element : elements) {
            if (element instanceof Change) {
                changes.add((Change)element);
                continue;
            }
            if (!(element instanceof Release)) continue;
            Release release = (Release)element;
            changes.addAll((Collection<Change>)release.getChanges());
        }
        return changes;
    }

    private static List getChildren(EObject element) {
        EReference reference = MoveChecker.getChangeReference(element);
        List elements = (List)element.eGet((EStructuralFeature)reference);
        return elements;
    }

    private static int getIndex(EObject element) {
        if (element == null || element.eContainer() == null || element.eContainmentFeature() == null) {
            throw new IllegalStateException();
        }
        return ((List)element.eContainer().eGet((EStructuralFeature)element.eContainmentFeature())).indexOf(element);
    }

    private static EReference getChangeReference(EObject element) {
        if (element instanceof History) {
            return HistoryPackage.eINSTANCE.getHistory_Releases();
        }
        for (EReference reference : element.eClass().getEAllContainments()) {
            if (!HistoryPackage.eINSTANCE.getChange().isSuperTypeOf(reference.getEReferenceType())) continue;
            return reference;
        }
        return null;
    }

    private static boolean before(EObject source, int sourceIndex, EObject target, int targetIndex) {
        if (source == target) {
            return sourceIndex < targetIndex;
        }
        if (MoveChecker.contains(source, target)) {
            return MoveChecker.before(source, sourceIndex, target.eContainer(), MoveChecker.getIndex(target));
        }
        return MoveChecker.before(source.eContainer(), MoveChecker.getIndex(source), target, targetIndex);
    }

    private static boolean contains(EObject parent, EObject child) {
        while (child != null) {
            if (child.eContainer() == parent) {
                return true;
            }
            child = child.eContainer();
        }
        return false;
    }
}

