/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.validation;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecp.view.internal.validation.ECPSubstitutionLabelProvider;
import org.eclipse.emf.ecp.view.internal.validation.ViewSubstitutionLabelProviderFactory;
import org.eclipse.emf.ecp.view.spi.context.GlobalViewModelService;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.validation.ValidationProvider;
import org.eclipse.emf.ecp.view.spi.validation.ViewValidationListener;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewContext;

public interface ValidationService
extends GlobalViewModelService {
    public void addValidationProvider(ValidationProvider var1);

    public void addValidationProvider(ValidationProvider var1, boolean var2);

    public void removeValidationProvider(ValidationProvider var1);

    public void removeValidationProvider(ValidationProvider var1, boolean var2);

    public void registerValidationListener(ViewValidationListener var1);

    public void deregisterValidationListener(ViewValidationListener var1);

    default public void validate(Iterable<? extends EObject> objects) {
        if (objects instanceof Collection) {
            Collection collection = (Collection)objects;
            this.validate(collection);
        } else {
            Collection collection = StreamSupport.stream(objects.spliterator(), false).collect(Collectors.toList());
            this.validate(collection);
        }
    }

    public void validate(Collection<EObject> var1);

    public static EValidator.SubstitutionLabelProvider getSubstitutionLabelProvider(EMFFormsViewContext context, AdapterFactory adapterFactory) {
        ECPSubstitutionLabelProvider result = null;
        if (adapterFactory instanceof ComposedAdapterFactory && context instanceof ViewModelContext && ((ViewModelContext)context).hasService(ViewSubstitutionLabelProviderFactory.class)) {
            result = ((ViewSubstitutionLabelProviderFactory)context.getService(ViewSubstitutionLabelProviderFactory.class)).createSubstitutionLabelProvider((ComposedAdapterFactory)adapterFactory);
        }
        if (result == null) {
            result = new ECPSubstitutionLabelProvider(adapterFactory);
        }
        return result;
    }
}

