/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.view.multisegment.tooling;

import java.util.Collections;
import java.util.Optional;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecp.ui.view.swt.reference.OpenInNewContextStrategy;
import org.eclipse.emf.ecp.ui.view.swt.reference.ReferenceServiceCustomizationVendor;
import org.eclipse.emf.ecp.view.internal.editor.handler.CreateSegmentDmrWizard;
import org.eclipse.emf.ecp.view.internal.editor.handler.FeatureSegmentGenerator;
import org.eclipse.emf.ecp.view.internal.editor.handler.SegmentGenerator;
import org.eclipse.emf.ecp.view.spi.editor.controls.Helper;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.edit.command.ReplaceCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.bazaar.Create;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.ide.view.segments.ToolingModeUtil;
import org.eclipse.emfforms.view.spi.multisegment.model.VMultiDomainModelReferenceSegment;
import org.eclipse.emfforms.view.spi.multisegment.model.VMultisegmentPackage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(name="MultiSegmentChildDmrOpenInNewContextStrategyProvider", property={"service.ranking:Integer=50"})
public class MultiSegmentChildDmrOpenInNewContextStrategyProvider
extends ReferenceServiceCustomizationVendor<OpenInNewContextStrategy>
implements OpenInNewContextStrategy.Provider {
    private EMFFormsDatabindingEMF databindingService;
    private ReportService reportService;

    @Reference(unbind="-")
    void setEMFFormsDatabinding(EMFFormsDatabindingEMF databindingService) {
        this.databindingService = databindingService;
    }

    @Reference(unbind="-")
    void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @Create
    public OpenInNewContextStrategy createOpenInNewContextStrategy() {
        return new Strategy();
    }

    protected boolean handles(EObject owner, EReference reference) {
        return this.isSegmentToolingEnabled() && owner instanceof VMultiDomainModelReferenceSegment && reference == VMultisegmentPackage.Literals.MULTI_DOMAIN_MODEL_REFERENCE_SEGMENT__CHILD_DOMAIN_MODEL_REFERENCES;
    }

    boolean isSegmentToolingEnabled() {
        return ToolingModeUtil.isSegmentToolingEnabled();
    }

    class Strategy
    implements OpenInNewContextStrategy {
        Strategy() {
        }

        public boolean openInNewContext(EObject owner, EReference reference, EObject object) {
            IEMFValueProperty valueProperty;
            VMultiDomainModelReferenceSegment multiSegment = (VMultiDomainModelReferenceSegment)owner;
            VDomainModelReference tableDmr = (VDomainModelReference)multiSegment.eContainer();
            EClass viewRoot = Helper.getRootEClass((EObject)tableDmr);
            try {
                valueProperty = MultiSegmentChildDmrOpenInNewContextStrategyProvider.this.databindingService.getValueProperty(tableDmr, viewRoot);
            }
            catch (DatabindingFailedException ex) {
                MultiSegmentChildDmrOpenInNewContextStrategyProvider.this.reportService.report(new AbstractReport((Throwable)ex, String.format("Child DMR %s could not be opened in a new context due to a databinding exception.", object)));
                return false;
            }
            EReference multiRef = (EReference)valueProperty.getValueType();
            EClass childDmrRoot = multiRef.getEReferenceType();
            VDomainModelReference childDmr = (VDomainModelReference)object;
            CreateSegmentDmrWizard dmrWizard = new CreateSegmentDmrWizard(childDmrRoot, "Edit Child Domain Model Reference", childDmr, structuralFeature -> null, (SegmentGenerator)new FeatureSegmentGenerator(), null, false);
            WizardDialog wizardDialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)dmrWizard);
            wizardDialog.setBlockOnOpen(true);
            wizardDialog.open();
            Optional dmr = dmrWizard.getDomainModelReference();
            EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)owner);
            if (dmr.isPresent()) {
                Command replace = ReplaceCommand.create((EditingDomain)domain, (Object)owner, (Object)reference, (Object)childDmr, Collections.singleton((VDomainModelReference)dmr.get()));
                domain.getCommandStack().execute(replace);
            }
            return true;
        }
    }
}

