/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.internal.migration.internal;

import java.text.MessageFormat;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.internal.migration.internal.BackwardConverter;

public class MaterializingBackwardConverter
extends BackwardConverter {
    @Override
    protected EClass resolveEClass(EClass eClass) {
        return (EClass)this.resolveEClassifier((EClassifier)eClass);
    }

    private EClassifier resolveEClassifier(EClassifier classifier) {
        EPackage sourcePackage = classifier.getEPackage();
        EPackage targetPackage = EPackage.Registry.INSTANCE.getEPackage(sourcePackage.getNsURI());
        return targetPackage.getEClassifier(classifier.getName());
    }

    @Override
    protected EStructuralFeature resolveFeature(EStructuralFeature feature) {
        EClass sourceClass = feature.getEContainingClass();
        EClass targetClass = this.resolveEClass(sourceClass);
        return targetClass.getEStructuralFeature(feature.getName());
    }

    @Override
    protected Enumerator resolveLiteral(Object literal) {
        if (EEnumLiteral.class.isInstance(literal)) {
            EEnum sourceEnum = ((EEnumLiteral)EEnumLiteral.class.cast(literal)).getEEnum();
            String value = sourceEnum.getEPackage().getEFactoryInstance().convertToString((EDataType)sourceEnum, literal);
            EEnum targetEnum = (EEnum)this.resolveEClassifier((EClassifier)sourceEnum);
            return (Enumerator)targetEnum.getEPackage().getEFactoryInstance().createFromString((EDataType)targetEnum, value);
        }
        if (Enumerator.class.isInstance(literal)) {
            return (Enumerator)Enumerator.class.cast(literal);
        }
        if (literal == null) {
            return null;
        }
        throw new IllegalArgumentException(MessageFormat.format("Unexpected literal {0} of type {1} cannot be converted to an Enumerator", literal, literal.getClass()));
    }
}

