/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.group.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum GroupLabelAlignment implements Enumerator
{
    LABEL_ALIGNED(0, "LabelAligned", "LabelAligned"),
    INPUT_ALIGNED(1, "InputAligned", "InputAligned");

    public static final int LABEL_ALIGNED_VALUE = 0;
    public static final int INPUT_ALIGNED_VALUE = 1;
    private static final GroupLabelAlignment[] VALUES_ARRAY;
    public static final List<GroupLabelAlignment> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new GroupLabelAlignment[]{LABEL_ALIGNED, INPUT_ALIGNED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static GroupLabelAlignment get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GroupLabelAlignment result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GroupLabelAlignment getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GroupLabelAlignment result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GroupLabelAlignment get(int value) {
        switch (value) {
            case 0: {
                return LABEL_ALIGNED;
            }
            case 1: {
                return INPUT_ALIGNED;
            }
        }
        return null;
    }

    private GroupLabelAlignment(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

