/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.table;

import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.spi.swt.table.AbstractTableViewerColumnBuilder;
import org.eclipse.emfforms.spi.swt.table.ColumnConfiguration;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class DefaultTableViewerColumnBuilder
extends AbstractTableViewerColumnBuilder<TableViewer, TableViewerColumn> {
    public DefaultTableViewerColumnBuilder(ColumnConfiguration config) {
        super(config);
    }

    @Override
    public TableViewerColumn createViewerColumn(TableViewer tableViewer) {
        return new TableViewerColumn(tableViewer, this.getConfig().getStyleBits());
    }

    @Override
    protected Item getTableColumn(TableViewerColumn viewerColumn) {
        return viewerColumn.getColumn();
    }

    @Override
    protected void configureDatabinding(Widget column) {
        super.configureDatabinding(column);
        this.bindValue(column, WidgetProperties.tooltipText(), this.getConfig().getColumnTooltip());
    }

    @Override
    protected void configureViewerColumn(TableViewerColumn viewerColumn) {
        TableColumn column = viewerColumn.getColumn();
        column.setResizable(this.getConfig().isResizeable());
        column.setMoveable(this.getConfig().isMoveable());
    }

    @Override
    protected void configureEditingSupport(TableViewerColumn viewerColumn, TableViewer tableViewer) {
        Optional<EditingSupport> editingSupport = this.getConfig().createEditingSupport((AbstractTableViewer)tableViewer);
        if (editingSupport.isPresent()) {
            viewerColumn.setEditingSupport((EditingSupport)editingSupport.get());
        }
    }
}

