/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui;

import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecp.internal.ui.UIProviderRegistryImpl;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public final class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.emf.ecp.ui";
    private static Activator instance;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        UIProviderRegistryImpl.INSTANCE.activate();
    }

    public void stop(BundleContext context) throws Exception {
        UIProviderRegistryImpl.INSTANCE.deactivate();
        instance = null;
        super.stop(context);
    }

    public static Activator getInstance() {
        return instance;
    }

    public static void log(String message) {
        instance.getLog().log((IStatus)new Status(1, PLUGIN_ID, message));
    }

    public static void log(String message, Throwable t) {
        if (t instanceof CoreException) {
            CoreException coreException = (CoreException)t;
            instance.getLog().log(coreException.getStatus());
        } else {
            instance.getLog().log((IStatus)new Status(4, PLUGIN_ID, message, t));
        }
    }

    public static void log(IStatus status) {
        instance.getLog().log(status);
    }

    public static String log(Throwable t) {
        IStatus status = Activator.getStatus(t);
        Activator.log(status);
        return status.getMessage();
    }

    public static IStatus getStatus(Throwable t) {
        if (t instanceof CoreException) {
            CoreException coreException = (CoreException)t;
            return coreException.getStatus();
        }
        String msg = t.getLocalizedMessage();
        if (msg == null || msg.length() == 0) {
            msg = t.getClass().getName();
        }
        return new Status(4, PLUGIN_ID, msg, t);
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        ImageDescriptor id = Activator.getInstance().getImageRegistry().getDescriptor(path);
        if (id == null) {
            id = Activator.loadImageDescriptor(path);
        }
        return id;
    }

    public static Image getImage(String path) {
        Image image = Activator.getInstance().getImageRegistry().get(path);
        if (image == null) {
            image = Activator.loadImage(path);
        }
        return image;
    }

    private static Image loadImage(String path) {
        ImageDescriptor id = Activator.loadImageDescriptor(path);
        if (id == null) {
            return null;
        }
        Activator.getInstance().getImageRegistry().put(path, id);
        return Activator.getInstance().getImageRegistry().get(path);
    }

    private static ImageDescriptor loadImageDescriptor(String path) {
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)PLUGIN_ID), (IPath)new Path(path), null);
        if (url == null) {
            return null;
        }
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
        Activator.getInstance().getImageRegistry().put(path, imageDescriptor);
        return imageDescriptor;
    }
}

