/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.table.columnservice;

import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.table.generator.TableColumnGenerator;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.view.spi.multisegment.model.VMultiDomainModelReferenceSegment;

public class AddColumnService
implements ViewModelService {
    private ViewModelContext context;

    public void instantiate(ViewModelContext context) {
        this.context = context;
        VElement viewModel = context.getViewModel();
        if (viewModel instanceof VTableControl) {
            this.addColumnsIfNeeded((VTableControl)viewModel);
            return;
        }
        TreeIterator contents = viewModel.eAllContents();
        while (contents.hasNext()) {
            EObject current = (EObject)contents.next();
            if (!(current instanceof VTableControl)) continue;
            VTableControl tableControl = (VTableControl)current;
            this.addColumnsIfNeeded(tableControl);
        }
    }

    private void addColumnsIfNeeded(VTableControl tableControl) {
        if (tableControl.getDomainModelReference() == null) {
            return;
        }
        if (!VTableDomainModelReference.class.isInstance(tableControl.getDomainModelReference())) {
            return;
        }
        VTableDomainModelReference tableDmr = (VTableDomainModelReference)VTableDomainModelReference.class.cast(tableControl.getDomainModelReference());
        boolean addColumns = false;
        boolean segments = false;
        if (tableDmr.getSegments().size() > 0) {
            VMultiDomainModelReferenceSegment multiSegment = (VMultiDomainModelReferenceSegment)tableDmr.getSegments().get(tableDmr.getSegments().size() - 1);
            addColumns = multiSegment.getChildDomainModelReferences().size() < 1;
            segments = true;
        } else {
            boolean bl = addColumns = tableDmr.getColumnDomainModelReferences().size() < 1;
        }
        if (addColumns) {
            IValueProperty valueProperty;
            VTableDomainModelReference tableDMR = (VTableDomainModelReference)tableControl.getDomainModelReference();
            try {
                valueProperty = segments || tableDMR.getDomainModelReference() == null ? ((EMFFormsDatabinding)this.context.getService(EMFFormsDatabinding.class)).getValueProperty((VDomainModelReference)tableDMR, this.context.getDomainModel()) : ((EMFFormsDatabinding)this.context.getService(EMFFormsDatabinding.class)).getValueProperty(tableDMR.getDomainModelReference(), this.context.getDomainModel());
            }
            catch (DatabindingFailedException ex) {
                ((ReportService)this.context.getService(ReportService.class)).report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                return;
            }
            EStructuralFeature structuralFeature = (EStructuralFeature)valueProperty.getValueType();
            EClassifier eType = structuralFeature.getEType();
            if (eType instanceof EClass) {
                EClass clazz = (EClass)eType;
                TableColumnGenerator.generateColumns((EClass)clazz, (VTableControl)tableControl);
            }
        }
    }

    public void dispose() {
    }

    public int getPriority() {
        return -1;
    }
}

