/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.structuralchange.mapping;

import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.mappingdmr.model.VMappingDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emfforms.spi.core.services.structuralchange.EMFFormsStructuralChangeTester;
import org.eclipse.emfforms.spi.core.services.structuralchange.StructuralChangeTesterInternal;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component
public class StructuralChangeTesterMapping
implements StructuralChangeTesterInternal {
    private EMFFormsStructuralChangeTester emfFormsStructuralChangeTester;
    private BundleContext bundleContext;
    private ServiceReference<EMFFormsStructuralChangeTester> emfFormsStructuralChangeTesterServiceReference;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        if (this.emfFormsStructuralChangeTesterServiceReference != null) {
            bundleContext.ungetService(this.emfFormsStructuralChangeTesterServiceReference);
            this.emfFormsStructuralChangeTester = null;
        }
    }

    private EMFFormsStructuralChangeTester getEMFFormsStructuralChangeTester() {
        if (this.emfFormsStructuralChangeTester == null) {
            this.emfFormsStructuralChangeTesterServiceReference = this.bundleContext.getServiceReference(EMFFormsStructuralChangeTester.class);
            if (this.emfFormsStructuralChangeTesterServiceReference == null) {
                throw new IllegalStateException("No EMFFormsDomainExpander available!");
            }
            this.emfFormsStructuralChangeTester = (EMFFormsStructuralChangeTester)this.bundleContext.getService(this.emfFormsStructuralChangeTesterServiceReference);
        }
        return this.emfFormsStructuralChangeTester;
    }

    void setEMFFormsStructuralChangeTester(EMFFormsStructuralChangeTester emfFormsStructuralChangeTester) {
        this.emfFormsStructuralChangeTester = emfFormsStructuralChangeTester;
    }

    public double isApplicable(VDomainModelReference reference) {
        if (VMappingDomainModelReference.class.isInstance(reference)) {
            return 5.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public boolean isStructureChanged(VDomainModelReference reference, EObject domainRootObject, ModelChangeNotification notification) {
        Assert.create((Object)reference).notNull();
        Assert.create((Object)notification).notNull();
        Assert.create((Object)reference).ofClass(VFeaturePathDomainModelReference.class);
        if (notification.getRawNotification().isTouch()) {
            return false;
        }
        if (EAttribute.class.isInstance(notification.getStructuralFeature())) {
            return false;
        }
        VMappingDomainModelReference mappingDMR = (VMappingDomainModelReference)VMappingDomainModelReference.class.cast(reference);
        boolean relevantChange = false;
        EObject lastResolvedEObject = domainRootObject;
        for (EReference eReference : mappingDMR.getDomainModelEReferencePath()) {
            if (lastResolvedEObject == null) {
                return false;
            }
            if (relevantChange |= eReference.equals(notification.getStructuralFeature()) && lastResolvedEObject == notification.getNotifier()) {
                return true;
            }
            lastResolvedEObject = (EObject)lastResolvedEObject.eGet((EStructuralFeature)eReference);
        }
        EMap map = (EMap)lastResolvedEObject.eGet(mappingDMR.getDomainModelEFeature());
        if (!map.containsKey((Object)mappingDMR.getMappedClass())) {
            return false;
        }
        relevantChange = this.getEMFFormsStructuralChangeTester().isStructureChanged(mappingDMR.getDomainModelReference(), (EObject)map.get((Object)mappingDMR.getMappedClass()), notification);
        return relevantChange;
    }
}

