/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.template.tooling.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.model.util.VViewResourceImpl;
import org.eclipse.emf.ecp.view.template.internal.tooling.Activator;
import org.eclipse.emf.ecp.view.template.internal.tooling.Messages;
import org.eclipse.emf.ecp.view.template.model.VTStyle;
import org.eclipse.emf.ecp.view.template.model.VTStyleSelector;
import org.eclipse.emf.ecp.view.template.model.VTTemplateFactory;
import org.eclipse.emf.ecp.view.template.model.VTTemplatePackage;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplate;
import org.eclipse.emf.ecp.view.template.selector.domainmodelreference.model.VTDomainModelReferenceSelector;
import org.eclipse.emf.ecp.view.template.selector.domainmodelreference.model.VTDomainmodelreferencePackage;
import org.eclipse.emf.ecp.view.template.selector.viewModelElement.model.VTViewModelElementPackage;
import org.eclipse.emf.ecp.view.template.selector.viewModelElement.model.VTViewModelElementSelector;
import org.eclipse.emf.ecp.view.template.tooling.editor.TemplateModelEditorPart;
import org.eclipse.emf.ecp.view.template.tooling.wizards.EMFFormsChooseTemplateWizardPage;
import org.eclipse.emf.ecp.view.template.tooling.wizards.EMFFormsNewTemplateWizardPage;
import org.eclipse.emf.ecp.view.template.tooling.wizards.EMFFormsSelectTemplateWizardPage;
import org.eclipse.emf.ecp.view.template.tooling.wizards.EMFFormsStyleSelectorWizardPage;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class EMFFormsTemplateWizard
extends Wizard
implements INewWizard {
    private ISelection selection;
    private final Optional<VElement> vElement;
    private Optional<EMFFormsChooseTemplateWizardPage> choosePage = Optional.empty();
    private Optional<EMFFormsNewTemplateWizardPage> newPage = Optional.empty();
    private Optional<EMFFormsSelectTemplateWizardPage> selectPage = Optional.empty();
    private Optional<EMFFormsStyleSelectorWizardPage> selectorPage = Optional.empty();

    public EMFFormsTemplateWizard() {
        this(null);
    }

    public EMFFormsTemplateWizard(VElement vElement) {
        this.setNeedsProgressMonitor(true);
        this.vElement = Optional.ofNullable((Object)vElement);
    }

    public void addPages() {
        if (this.vElement.isPresent()) {
            this.choosePage = Optional.of((Object)((Object)new EMFFormsChooseTemplateWizardPage()));
            this.addPage((IWizardPage)this.choosePage.get());
        }
        this.newPage = Optional.of((Object)((Object)new EMFFormsNewTemplateWizardPage(this.selection)));
        this.addPage((IWizardPage)this.newPage.get());
        if (this.vElement.isPresent()) {
            this.selectPage = Optional.of((Object)((Object)new EMFFormsSelectTemplateWizardPage()));
            this.addPage((IWizardPage)this.selectPage.get());
        }
        if (this.vElement.isPresent()) {
            this.selectorPage = Optional.of((Object)((Object)new EMFFormsStyleSelectorWizardPage(VControl.class.isInstance(this.vElement.get()))));
            this.addPage((IWizardPage)this.selectorPage.get());
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.choosePage.isPresent() && page == this.choosePage.get()) {
            if (((EMFFormsChooseTemplateWizardPage)((Object)this.choosePage.get())).createNewTemplate()) {
                return (IWizardPage)this.newPage.get();
            }
            return (IWizardPage)this.selectPage.get();
        }
        if (this.newPage.isPresent() && page == this.newPage.get() || this.selectPage.isPresent() && page == this.selectPage.get()) {
            if (this.selectorPage.isPresent()) {
                return (IWizardPage)this.selectorPage.get();
            }
            return null;
        }
        return super.getNextPage(page);
    }

    public boolean canFinish() {
        if (!this.vElement.isPresent()) {
            return super.canFinish();
        }
        int i = 0;
        while (i < this.getPages().length) {
            IWizardPage page = this.getPages()[i];
            if (!(((EMFFormsChooseTemplateWizardPage)((Object)this.choosePage.get())).createNewTemplate() && this.selectPage.get() == page || !((EMFFormsChooseTemplateWizardPage)((Object)this.choosePage.get())).createNewTemplate() && this.newPage.get() == page || page.isPageComplete())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean performFinish() {
        if (!this.vElement.isPresent()) {
            return this.performFinishNewPage();
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        activePage.addPartListener((IPartListener2)new AddToTemplatePartListener(activePage));
        if (((EMFFormsChooseTemplateWizardPage)((Object)this.choosePage.get())).createNewTemplate()) {
            if (!this.performFinishNewPage()) {
                return false;
            }
        } else {
            final IFile resource = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(((EMFFormsSelectTemplateWizardPage)((Object)this.selectPage.get())).getTemplateName());
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)resource, (boolean)true);
                    }
                    catch (PartInitException e) {
                        ErrorDialog.openError((Shell)EMFFormsTemplateWizard.this.getShell(), (String)Messages.EMFFormsTemplateWizard_OpenEditorFailTitle, (String)Messages.EMFFormsTemplateWizard_OpenEditorFailMessage, (IStatus)new Status(4, "org.eclipse.emf.ecp.view.template.tooling", e.getMessage(), (Throwable)e));
                    }
                }
            });
        }
        return true;
    }

    private boolean addStyleToTemplate(VTStyleSelector styleSelector, TemplateModelEditorPart templateEditor) {
        VTViewTemplate template = templateEditor.getTemplate();
        if (template == null) {
            return false;
        }
        TreeIterator templateContents = EcoreUtil.getAllContents((EObject)template, (boolean)true);
        while (templateContents.hasNext()) {
            EObject next = (EObject)templateContents.next();
            if (!VTStyleSelector.class.isInstance(next) || !EcoreUtil.equals((EObject)next, (EObject)styleSelector)) continue;
            templateEditor.reveal(next);
            return true;
        }
        VTStyle style = VTTemplateFactory.eINSTANCE.createStyle();
        style.setSelector(styleSelector);
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)template);
        Command command = AddCommand.create((EditingDomain)domain, (Object)template, (Object)VTTemplatePackage.eINSTANCE.getViewTemplate_Styles(), (Object)style);
        if (VTDomainModelReferenceSelector.class.isInstance(styleSelector)) {
            EObject view = (EObject)this.vElement.get();
            while (!VView.class.isInstance(view) && view != null) {
                view = view.eContainer();
            }
            command = this.addEcorePathIfRequired(template, domain, command, view);
        }
        if (!command.canExecute()) {
            return false;
        }
        domain.getCommandStack().execute(command);
        templateEditor.reveal((EObject)styleSelector);
        return true;
    }

    private Command addEcorePathIfRequired(VTViewTemplate template, EditingDomain domain, Command command, EObject view) {
        if (view == null) {
            return command;
        }
        ArrayList<Command> ecorePathCommands = new ArrayList<Command>();
        ecorePathCommands.add(command);
        for (String ecorePaths : ((VView)VView.class.cast(view)).getEcorePaths()) {
            if (template.getReferencedEcores().contains((Object)ecorePaths)) continue;
            ecorePathCommands.add(AddCommand.create((EditingDomain)domain, (Object)template, (Object)VTTemplatePackage.eINSTANCE.getViewTemplate_ReferencedEcores(), (Object)ecorePaths));
        }
        if (ecorePathCommands.size() > 1) {
            return new CompoundCommand(ecorePathCommands);
        }
        return command;
    }

    private boolean performFinishNewPage() {
        final String containerName = ((EMFFormsNewTemplateWizardPage)((Object)this.newPage.get())).getContainerName();
        final String fileName = ((EMFFormsNewTemplateWizardPage)((Object)this.newPage.get())).getFileName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        EMFFormsTemplateWizard.this.doFinish(containerName, fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.EMFFormsTemplateWizard_errorTitle, (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void addToPluginXML(IFile modelFile, IProgressMonitor monitor) {
        IProject project = modelFile.getProject();
        IFile pluginFile = project.getFile("plugin.xml");
        try {
            if (!pluginFile.exists()) {
                String pluginXmlContents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?eclipse version=\"3.4\"?>\n<plugin>\n</plugin>";
                pluginFile.create((InputStream)new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?eclipse version=\"3.4\"?>\n<plugin>\n</plugin>".getBytes()), true, null);
                project.refreshLocal(2, null);
            }
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(pluginFile.getLocationURI().toString());
            Element element = doc.createElement("extension");
            element.setAttribute("point", "org.eclipse.emf.ecp.view.template");
            Element templateElement = doc.createElement("viewTemplate");
            templateElement.setAttribute("xmi", modelFile.getProjectRelativePath().toString());
            element.appendChild(templateElement);
            doc.getDocumentElement().appendChild(element);
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("encoding", "UTF-8");
            tf.setOutputProperty("indent", "yes");
            StreamResult file = new StreamResult(pluginFile.getLocation().toFile());
            tf.transform(new DOMSource(doc), file);
        }
        catch (SAXException ex) {
            Activator.log(ex);
        }
        catch (IOException ex) {
            Activator.log(ex);
        }
        catch (ParserConfigurationException ex) {
            Activator.log(ex);
        }
        catch (TransformerException ex) {
            Activator.log(ex);
        }
        catch (CoreException ex) {
            Activator.log((Exception)((Object)ex));
        }
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(String.valueOf(Messages.EMFFormsTemplateWizard_creatingTask) + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException(String.format("Container \"%s\" does not exist.", containerName));
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            VTViewTemplate template = VTTemplateFactory.eINSTANCE.createViewTemplate();
            ResourceSetImpl rs = new ResourceSetImpl();
            Resource templateResource = rs.createResource(URI.createURI((String)file.getLocationURI().toString()));
            templateResource.getContents().add((Object)template);
            templateResource.save(Collections.singletonMap("ENCODING", "UTF-8"));
            container.refreshLocal(1, monitor);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        monitor.worked(1);
        monitor.setTaskName(Messages.EMFFormsTemplateWizard_editingTask);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        });
        monitor.worked(1);
        this.addToPluginXML(file, monitor);
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.eclipse.emf.ecp.view.template.tooling", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    private static Optional<String> getUUID(VElement vElement) {
        Resource eResource = vElement.eResource();
        if (!VViewResourceImpl.class.isInstance(eResource)) {
            return Optional.empty();
        }
        return Optional.ofNullable((Object)((VViewResourceImpl)VViewResourceImpl.class.cast(eResource)).getID((EObject)vElement));
    }

    private final class AddToTemplatePartListener
    implements IPartListener2 {
        private final IWorkbenchPage activePage;

        private AddToTemplatePartListener(IWorkbenchPage activePage) {
            this.activePage = activePage;
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            VTViewModelElementSelector selector;
            if (!"org.eclipse.emf.ecp.view.template.tooling.editor".equals(partRef.getId())) {
                return;
            }
            this.activePage.removePartListener((IPartListener2)this);
            EClass selectorEClass = VTViewModelElementPackage.eINSTANCE.getViewModelElementSelector();
            Optional<Boolean> useUUID = Optional.empty();
            if (EMFFormsTemplateWizard.this.selectorPage.isPresent()) {
                selectorEClass = ((EMFFormsStyleSelectorWizardPage)((Object)EMFFormsTemplateWizard.this.selectorPage.get())).getSelectorEClass();
                useUUID = ((EMFFormsStyleSelectorWizardPage)((Object)EMFFormsTemplateWizard.this.selectorPage.get())).getUseUUID();
            }
            VTStyleSelector styleSelector = (VTStyleSelector)EcoreUtil.create((EClass)selectorEClass);
            if (selectorEClass == VTViewModelElementPackage.eINSTANCE.getViewModelElementSelector()) {
                Optional uuid;
                selector = (VTViewModelElementSelector)VTViewModelElementSelector.class.cast(styleSelector);
                selector.setClassType(((VElement)EMFFormsTemplateWizard.this.vElement.get()).eClass());
                if (useUUID.isPresent() && ((Boolean)useUUID.get()).booleanValue() && (uuid = EMFFormsTemplateWizard.getUUID((VElement)EMFFormsTemplateWizard.this.vElement.get())).isPresent()) {
                    selector.setAttribute(VViewPackage.eINSTANCE.getElement_Uuid());
                    selector.setAttributeValue(uuid.get());
                }
            } else if (selectorEClass == VTDomainmodelreferencePackage.eINSTANCE.getDomainModelReferenceSelector()) {
                selector = (VTDomainModelReferenceSelector)VTDomainModelReferenceSelector.class.cast(styleSelector);
                VDomainModelReference dmr = ((VControl)VControl.class.cast(EMFFormsTemplateWizard.this.vElement.get())).getDomainModelReference();
                selector.setDomainModelReference((VDomainModelReference)EcoreUtil.copy((EObject)dmr));
            }
            IEditorPart editor = this.activePage.getActiveEditor();
            TemplateModelEditorPart templateEditor = (TemplateModelEditorPart)((Object)TemplateModelEditorPart.class.cast(editor));
            EMFFormsTemplateWizard.this.addStyleToTemplate(styleSelector, templateEditor);
        }
    }
}

