/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.spreadsheet.core.transfer;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Workbook;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emfforms.internal.spreadsheet.core.EMFFormsSpreadsheetViewModelContext;
import org.eclipse.emfforms.internal.spreadsheet.core.converter.NumberFormatHelper;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsAbstractSpreadsheetRenderer;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsNoRendererException;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsSpreadsheetRenderTarget;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsSpreadsheetRendererFactory;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsSpreadsheetReport;
import org.eclipse.emfforms.spi.spreadsheet.core.transfer.EMFFormsSpreadsheetExporter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class EMFFormsSpreadsheetExporterImpl
implements EMFFormsSpreadsheetExporter {
    private final ReportService reportService;
    private final ViewProvider viewProvider;

    public EMFFormsSpreadsheetExporterImpl() {
        this(new ViewProvider(){

            @Override
            public VView getViewModel(EObject viewEobject, VViewModelProperties properties) {
                return ViewProviderHelper.getView((EObject)viewEobject, (VViewModelProperties)properties);
            }
        });
    }

    public EMFFormsSpreadsheetExporterImpl(ViewProvider viewProvider) {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference reportServiceReference = bundleContext.getServiceReference(ReportService.class);
        this.reportService = (ReportService)bundleContext.getService(reportServiceReference);
        this.viewProvider = viewProvider;
    }

    @Override
    public Workbook render(Collection<? extends EObject> domainObjects, EObject viewEobject, VViewModelProperties properties) {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(EMFFormsSpreadsheetRendererFactory.class);
        EMFFormsSpreadsheetRendererFactory emfFormsSpreadsheetRendererFactory = (EMFFormsSpreadsheetRendererFactory)bundleContext.getService(serviceReference);
        HSSFWorkbook workbook = new HSSFWorkbook();
        VView viewModel = this.viewProvider.getViewModel(viewEobject, properties);
        if (viewModel == null) {
            this.reportService.report((AbstractReport)new EMFFormsSpreadsheetReport("No view model could be found for the given EObject/ViewModelProperties", 4));
            return workbook;
        }
        Set<String> retrievedFormats = this.retrieveAllFormats(viewModel.getRootEClass());
        LinkedHashMap<String, CellStyle> keyStyleMap = new LinkedHashMap<String, CellStyle>(retrievedFormats.size());
        this.addDefaultCellStyles((Workbook)workbook, keyStyleMap);
        this.prepareNumberCellStyles((Workbook)workbook, retrievedFormats, keyStyleMap);
        if (domainObjects == null) {
            try {
                EMFFormsSpreadsheetViewModelContext viewModelContext = new EMFFormsSpreadsheetViewModelContext(viewModel, null);
                this.prepareViewContext(keyStyleMap, viewModelContext);
                EMFFormsAbstractSpreadsheetRenderer<VElement> eMFFormsAbstractSpreadsheetRenderer = emfFormsSpreadsheetRendererFactory.getRendererInstance(viewModelContext.getViewModel(), viewModelContext);
                eMFFormsAbstractSpreadsheetRenderer.render((Workbook)workbook, viewModelContext.getViewModel(), viewModelContext, new EMFFormsSpreadsheetRenderTarget("root", 0, 0));
                viewModelContext.dispose();
            }
            catch (EMFFormsNoRendererException ex) {
                this.reportService.report((AbstractReport)new EMFFormsSpreadsheetReport(ex, 4));
            }
        } else {
            int i = 0;
            for (EObject eObject : domainObjects) {
                if (!viewModel.getRootEClass().isInstance((Object)eObject)) {
                    this.reportService.report((AbstractReport)new EMFFormsSpreadsheetReport(String.format("The provided view %1$s doesn't fit for the passed EObject %2$s", viewModel, eObject), 4));
                    continue;
                }
                try {
                    EMFFormsSpreadsheetViewModelContext viewModelContext = new EMFFormsSpreadsheetViewModelContext(viewModel, eObject);
                    this.prepareViewContext(keyStyleMap, viewModelContext);
                    EMFFormsAbstractSpreadsheetRenderer<VElement> renderer = emfFormsSpreadsheetRendererFactory.getRendererInstance(viewModelContext.getViewModel(), viewModelContext);
                    renderer.render((Workbook)workbook, viewModelContext.getViewModel(), viewModelContext, new EMFFormsSpreadsheetRenderTarget("root", i++, 0));
                    viewModelContext.dispose();
                }
                catch (EMFFormsNoRendererException ex) {
                    this.reportService.report((AbstractReport)new EMFFormsSpreadsheetReport(ex, 4));
                }
            }
        }
        return workbook;
    }

    private void addDefaultCellStyles(Workbook workbook, Map<String, CellStyle> keyStyleMap) {
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setLocked(true);
        keyStyleMap.put("CellStyle_Locked", cellStyle);
        CellStyle cellStyle2 = workbook.createCellStyle();
        cellStyle2.setLocked(true);
        cellStyle2.setWrapText(true);
        keyStyleMap.put("CellStyle_LockedWrapped", cellStyle2);
        CellStyle cellStyle3 = workbook.createCellStyle();
        cellStyle3.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"text"));
        keyStyleMap.put("CellStyle_Text", cellStyle3);
        CellStyle cellStyle4 = workbook.createCellStyle();
        cellStyle4.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"m/d/yy"));
        keyStyleMap.put("CellStyle_Date", cellStyle4);
    }

    private void prepareNumberCellStyles(Workbook workbook, Set<String> retrievedFormats, Map<String, CellStyle> keyStyleMap) {
        DataFormat dataFormat = workbook.createDataFormat();
        for (String format : retrievedFormats) {
            CellStyle cellStyleNumberFormat = workbook.createCellStyle();
            cellStyleNumberFormat.setDataFormat(dataFormat.getFormat(format));
            keyStyleMap.put(format, cellStyleNumberFormat);
        }
    }

    private void prepareViewContext(Map<String, CellStyle> formatStyleMap, ViewModelContext viewModelContext) {
        for (String key : formatStyleMap.keySet()) {
            viewModelContext.putContextValue(key, (Object)formatStyleMap.get(key));
        }
    }

    private Set<String> retrieveAllFormats(EClass eClass) {
        LinkedHashSet<String> formats = new LinkedHashSet<String>();
        LinkedHashSet<EClass> checkedClasses = new LinkedHashSet<EClass>();
        LinkedList<EClass> uncheckedClasses = new LinkedList<EClass>();
        uncheckedClasses.add(eClass);
        while (!uncheckedClasses.isEmpty()) {
            this.retrieveAllFormats((EClass)uncheckedClasses.poll(), formats, checkedClasses, uncheckedClasses);
        }
        return formats;
    }

    private void retrieveAllFormats(EClass eClass, Set<String> formats, Set<EClass> checkedClasses, Queue<EClass> uncheckedClasses) {
        if (checkedClasses.contains(eClass)) {
            return;
        }
        for (EReference eReference : eClass.getEAllReferences()) {
            uncheckedClasses.offer(eReference.getEReferenceType());
        }
        for (EAttribute eAttribute : eClass.getEAllAttributes()) {
            String format = NumberFormatHelper.getNumberFormat(eAttribute);
            if (format == null) continue;
            formats.add(format);
        }
        checkedClasses.add(eClass);
    }

    public static interface ViewProvider {
        public VView getViewModel(EObject var1, VViewModelProperties var2);
    }
}

