/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.validation;

import java.util.function.Predicate;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;

final class ThresholdDiagnostic
extends BasicDiagnostic {
    private ThresholdDiagnostic(int severity, String message) {
        super(severity, "org.eclipse.emf.ecp.view.validation", 0, message, null);
    }

    /* synthetic */ ThresholdDiagnostic(int n, String string, ThresholdDiagnostic thresholdDiagnostic) {
        this(n, string);
    }

    static final class Factory {
        private final EMFFormsLocalizationService l10n;
        private ThresholdDiagnostic errorInstance;
        private ThresholdDiagnostic warningInstance;
        private ThresholdDiagnostic infoInstance;

        Factory(EMFFormsLocalizationService l10n) {
            this.l10n = l10n;
        }

        ThresholdDiagnostic get(int severity) {
            switch (severity) {
                case 4: 
                case 8: {
                    if (this.errorInstance == null) {
                        this.errorInstance = this.create(4);
                    }
                    return this.errorInstance;
                }
                case 2: {
                    if (this.warningInstance == null) {
                        this.warningInstance = this.create(2);
                    }
                    return this.warningInstance;
                }
                case 1: {
                    if (this.infoInstance == null) {
                        this.infoInstance = this.create(1);
                    }
                    return this.infoInstance;
                }
            }
            throw new IllegalArgumentException("severity: " + severity);
        }

        private ThresholdDiagnostic create(int severity) {
            return new ThresholdDiagnostic(severity, this.l10n.getString(ThresholdDiagnostic.class, "ValidationServiceImpl_moreProblems"), null);
        }

        Predicate<Diagnostic> notThresholdDiagnostic() {
            Predicate<Diagnostic> isThreshold = ThresholdDiagnostic.class::isInstance;
            return isThreshold.negate();
        }
    }
}

