/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.validation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.spi.UniqueSetting;
import org.eclipse.emf.ecp.view.internal.validation.ConcurrentLinkedSetQueue;
import org.eclipse.emf.ecp.view.internal.validation.ECPSubstitutionLabelProvider;
import org.eclipse.emf.ecp.view.internal.validation.ThresholdDiagnostic;
import org.eclipse.emf.ecp.view.internal.validation.ValidationNotification;
import org.eclipse.emf.ecp.view.internal.validation.ValidationProviderHelper;
import org.eclipse.emf.ecp.view.internal.validation.ViewSubstitutionLabelProviderFactory;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeAddRemoveListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.validation.ValidationProvider;
import org.eclipse.emf.ecp.view.spi.validation.ValidationServiceConstants;
import org.eclipse.emf.ecp.view.spi.validation.ViewValidationListener;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emfforms.common.internal.validation.DiagnosticHelper;
import org.eclipse.emfforms.common.spi.validation.ValidationResultListener;
import org.eclipse.emfforms.common.spi.validation.ValidationService;
import org.eclipse.emfforms.common.spi.validation.Validator;
import org.eclipse.emfforms.common.spi.validation.filter.AbstractSimpleFilter;
import org.eclipse.emfforms.common.spi.validation.filter.ValidationFilter;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.common.validation.DiagnosticFrequencyMap;
import org.eclipse.emfforms.spi.core.services.controlmapper.EMFFormsSettingToControlMapper;
import org.eclipse.emfforms.spi.core.services.controlmapper.SubControlMapper;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.mappingprovider.EMFFormsMappingProviderManager;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsContextTracker;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewContext;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.eclipse.osgi.util.NLS;

public class ValidationServiceImpl
implements org.eclipse.emf.ecp.view.spi.validation.ValidationService {
    private ValidationService validationService;
    private ValidationDomainModelChangeListener domainChangeListener;
    private ViewModelContext rootContext;
    private EMFFormsContextTracker contextTracker;
    private final Map<EMFFormsViewContext, ViewModelChangeListener> viewModelChangeListeners = new HashMap<EMFFormsViewContext, ViewModelChangeListener>();
    private final Queue<EObject> validationQueue = new ConcurrentLinkedSetQueue<EObject>();
    private final Set<EObject> validated = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicBoolean validationRunning = new AtomicBoolean(false);
    private final Map<UniqueSetting, List<Diagnostic>> currentUpdates = new ConcurrentHashMap<UniqueSetting, List<Diagnostic>>();
    private final Function<Object, List<Diagnostic>> diagnosticListFactory = __ -> new ArrayList(3);
    private ComposedAdapterFactory adapterFactory;
    private ReportService reportService;
    private EMFFormsLocalizationService l10n;
    private ThresholdDiagnostic.Factory placeholderFactory;
    private int propagationThreshold;
    private final Set<ViewValidationListener> validationListeners = new LinkedHashSet<ViewValidationListener>();
    private EMFFormsMappingProviderManager mappingProviderManager;
    private EMFFormsSettingToControlMapper controlMapper;
    private boolean initialized;

    public void instantiate(ViewModelContext context) {
        this.rootContext = context;
        this.reportService = (ReportService)context.getService(ReportService.class);
        this.l10n = (EMFFormsLocalizationService)context.getService(EMFFormsLocalizationService.class);
        this.placeholderFactory = new ThresholdDiagnostic.Factory(this.l10n);
        this.mappingProviderManager = (EMFFormsMappingProviderManager)context.getService(EMFFormsMappingProviderManager.class);
        this.controlMapper = (EMFFormsSettingToControlMapper)context.getService(EMFFormsSettingToControlMapper.class);
        VElement renderable = context.getViewModel();
        if (renderable == null) {
            throw new IllegalStateException("View model must not be null");
        }
        EObject domainModel = context.getDomainModel();
        if (domainModel == null) {
            throw new IllegalStateException("Domain model must not be null");
        }
        this.propagationThreshold = this.getPropagationThreshold();
        this.validationService = new org.eclipse.emfforms.common.internal.validation.ValidationServiceImpl();
        this.validationService.registerValidationFilter((ValidationFilter)new AbstractSimpleFilter(){

            public boolean skipValidation(EObject eObject) {
                return ValidationServiceImpl.this.validated.contains(eObject);
            }

            public boolean ignoreDiagnostic(EObject eObject, Diagnostic diagnostic) {
                return !ValidationServiceImpl.this.controlMapper.hasControlsFor(eObject);
            }
        });
        this.validationService.registerValidationResultListener(new ValidationResultListener(){

            public void onValidate(EObject eObject, Diagnostic diagnostic) {
                ValidationServiceImpl.this.validated.add(eObject);
            }

            public void afterValidate(EObject eObject, Diagnostic diagnostic) {
            }
        });
        this.adapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        ViewSubstitutionLabelProviderFactory substitutionLabelProviderFactory = this.getSubstitutionLabelProviderFactory();
        Object substitutionLabelProvider = substitutionLabelProviderFactory != null ? substitutionLabelProviderFactory.createSubstitutionLabelProvider(this.adapterFactory) : new ECPSubstitutionLabelProvider((AdapterFactory)this.adapterFactory);
        this.validationService.setSubstitutionLabelProvider(substitutionLabelProvider);
        this.registerValidationProviders();
        this.domainChangeListener = new ValidationDomainModelChangeListener(context);
        context.registerDomainChangeListener((ModelChangeListener)this.domainChangeListener);
        this.addViewModelChangeListener((EMFFormsViewContext)context);
        this.contextTracker = new EMFFormsContextTracker((EMFFormsViewContext)this.rootContext);
        this.contextTracker.onContextInitialized(this::contextInitialised).onChildContextAdded(this::childContextAdded).onChildContextRemoved(this::childContextRemoved).open();
    }

    private void cleanControlDiagnostics(EObject parent, EReference parentReference, EObject removedEObject) {
        Set controls = this.controlMapper.getControlsFor(UniqueSetting.createSetting((EObject)parent, (EStructuralFeature)parentReference));
        if (controls == null) {
            return;
        }
        for (VElement vControl : controls) {
            if (vControl == null || vControl.getDiagnostic() == null) continue;
            LinkedHashSet<Diagnostic> diagnosticsToRemove = new LinkedHashSet<Diagnostic>();
            for (Object diagnosticObject : vControl.getDiagnostic().getDiagnostics()) {
                Diagnostic diagnostic = (Diagnostic)Diagnostic.class.cast(diagnosticObject);
                if (diagnostic.getData().size() < 1 || !removedEObject.equals(DiagnosticHelper.getFirstInternalEObject((List)diagnostic.getData()))) continue;
                diagnosticsToRemove.add(diagnostic);
            }
            vControl.getDiagnostic().getDiagnostics().removeAll(diagnosticsToRemove);
        }
    }

    private void registerValidationProviders() {
        for (ValidationProvider provider : ValidationProviderHelper.fetchValidationProviders()) {
            this.validationService.addValidator((Validator)provider);
        }
    }

    public void dispose() {
        this.contextTracker.close();
        this.viewModelChangeListeners.forEach((ctx, l) -> ctx.unregisterViewChangeListener((ModelChangeListener)l));
        this.viewModelChangeListeners.clear();
        this.rootContext.unregisterDomainChangeListener((ModelChangeListener)this.domainChangeListener);
        this.adapterFactory.dispose();
    }

    public int getPriority() {
        return 1;
    }

    private void addViewModelChangeListener(EMFFormsViewContext context) {
        ViewModelChangeListener listener = new ViewModelChangeListener(context);
        if (this.viewModelChangeListeners.putIfAbsent(context, listener) == null) {
            context.registerViewChangeListener((ModelChangeListener)listener);
            listener.start();
        }
    }

    private void removeViewModelChangeListener(EMFFormsViewContext context) {
        ViewModelChangeListener listener = this.viewModelChangeListeners.remove(context);
        if (listener != null) {
            context.unregisterViewChangeListener((ModelChangeListener)listener);
        }
    }

    private Collection<EObject> getAllEObjects(EObject eObject) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        result.add(eObject);
        TreeIterator iterator = EcoreUtil.getAllContents((EObject)eObject, (boolean)false);
        while (iterator.hasNext()) {
            result.add((EObject)iterator.next());
        }
        return result;
    }

    private Collection<EObject> getAllEObjectsToValidate(ViewModelContext context) {
        return ValidationServiceImpl.getAllEObjectsToValidate(context, this.controlMapper);
    }

    private static Collection<EObject> getAllEObjectsToValidate(ViewModelContext context, EMFFormsSettingToControlMapper controlMapper) {
        if (context.getParentContext() == null || !(controlMapper instanceof SubControlMapper)) {
            return controlMapper.getEObjectsWithSettings();
        }
        SubControlMapper subMapper = (SubControlMapper)controlMapper;
        Collection result = subMapper.getEObjectsWithSettings(context.getViewModel());
        ViewModelContext parent = context.getParentContext();
        while (parent != null) {
            EObject parentObject = parent.getDomainModel();
            if (controlMapper.hasControlsFor(parentObject)) {
                result.add(parentObject);
            }
            parent = parent.getParentContext();
        }
        return result;
    }

    @Override
    public void validate(Collection<EObject> eObjects) {
        this.validationQueue.addAll(eObjects);
        this.processValidationQueue();
    }

    public void validate(EObject eObject) {
        this.validationQueue.offer(eObject);
        this.processValidationQueue();
    }

    /*
     * Unable to fully structure code
     */
    private void processValidationQueue() {
        if (!this.initialized) {
            return;
        }
        if (this.validationRunning.compareAndSet(false, true)) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            this.validateAndCollectSettings(toValidate);
lbl6:
            // 2 sources

            ** while ((toValidate = this.validationQueue.poll()) != null)
        }
lbl7:
        // 1 sources

        this.update();
        this.notifyListeners();
        this.currentUpdates.clear();
        this.validated.clear();
        this.validationRunning.compareAndSet(true, false);
    }

    public void notifyListeners() {
        if (this.validationListeners.size() > 0) {
            Set<Diagnostic> result = this.getDiagnosticResult();
            for (ViewValidationListener l : this.validationListeners) {
                l.onNewValidation(result);
            }
        }
    }

    private void update() {
        Map<VElement, Set<UniqueSetting>> vElementToSettingMap = this.prepareVElementToSettingMap();
        LinkedHashMap<VElement, VDiagnostic> controlDiagnosticMap = new LinkedHashMap<VElement, VDiagnostic>();
        for (VElement control : vElementToSettingMap.keySet()) {
            this.updateControlDiagnostics(control, vElementToSettingMap, controlDiagnosticMap);
            if (control.getDiagnostic() == null) continue;
            for (Object diagnosticObject : control.getDiagnostic().getDiagnostics()) {
                UniqueSetting uniqueSetting2;
                Diagnostic diagnostic = (Diagnostic)Diagnostic.class.cast(diagnosticObject);
                if (diagnostic.getData().size() < 2) continue;
                InternalEObject diagnosticEobject = DiagnosticHelper.getFirstInternalEObject((List)diagnostic.getData());
                EStructuralFeature eStructuralFeature = DiagnosticHelper.getEStructuralFeature((List)diagnostic.getData());
                if (diagnosticEobject == null || eStructuralFeature == null || !this.isObjectStillValid((EObject)diagnosticEobject, eStructuralFeature, control) || this.currentUpdates.containsKey(uniqueSetting2 = UniqueSetting.createSetting((EObject)diagnosticEobject, (EStructuralFeature)eStructuralFeature))) continue;
                ((VDiagnostic)controlDiagnosticMap.get(control)).getDiagnostics().add(diagnosticObject);
            }
        }
        this.updateAndPropagate(controlDiagnosticMap);
    }

    private void updateControlDiagnostics(VElement control, Map<VElement, Set<UniqueSetting>> vElementToSettingMap, Map<VElement, VDiagnostic> controlDiagnosticMap) {
        if (!controlDiagnosticMap.containsKey(control)) {
            controlDiagnosticMap.put(control, VViewFactory.eINSTANCE.createDiagnostic());
        }
        for (UniqueSetting uniqueSetting : vElementToSettingMap.get(control)) {
            List<Diagnostic> diagnostics = this.currentUpdates.get(uniqueSetting);
            if (diagnostics.isEmpty()) continue;
            controlDiagnosticMap.get(control).getDiagnostics().addAll(diagnostics);
        }
    }

    private Map<VElement, Set<UniqueSetting>> prepareVElementToSettingMap() {
        LinkedHashMap<VElement, Set<UniqueSetting>> result = new LinkedHashMap<VElement, Set<UniqueSetting>>();
        Function<VElement, Set> setFactory = __ -> new LinkedHashSet();
        for (UniqueSetting uniqueSetting : this.currentUpdates.keySet()) {
            Set controls = this.controlMapper.getControlsFor(uniqueSetting);
            if (controls == null || controls.isEmpty()) continue;
            for (VElement control : controls) {
                result.computeIfAbsent(control, setFactory).add(uniqueSetting);
            }
        }
        return result;
    }

    private boolean isObjectStillValid(EObject diagnosticEobject, EStructuralFeature feature, VElement element) {
        UniqueSetting setting = UniqueSetting.createSetting((EObject)diagnosticEobject, (EStructuralFeature)feature);
        return this.controlMapper.hasMapping(setting, element);
    }

    private void updateAndPropagate(Map<VElement, VDiagnostic> controlDiagnosticMap) {
        controlDiagnosticMap.forEach(VElement::setDiagnostic);
        NavigableMap<Integer, Set<VElement>> depthMap = this.mapByDepth(controlDiagnosticMap.keySet());
        this.reevaluateToTop(depthMap, controlDiagnosticMap);
    }

    private NavigableMap<Integer, Set<VElement>> mapByDepth(Collection<? extends VElement> elements) {
        Function<Integer, Set> factory = __ -> new LinkedHashSet();
        TreeMap<Integer, Set<VElement>> result = new TreeMap<Integer, Set<VElement>>(Comparator.naturalOrder().reversed());
        for (VElement vElement : elements) {
            result.computeIfAbsent(this.depth((EObject)vElement), factory).add(vElement);
        }
        return result;
    }

    private int depth(EObject object) {
        int result = 0;
        EObject container = object.eContainer();
        while (container != null) {
            ++result;
            container = container.eContainer();
        }
        return result;
    }

    private Set<VElement> uniqueContainers(Collection<? extends VElement> elements) {
        return elements.stream().map(EObject::eContainer).filter(VElement.class::isInstance).map(VElement.class::cast).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private void reevaluateToTop(NavigableMap<Integer, Set<VElement>> depthMap, Map<VElement, VDiagnostic> controlDiagnosticMap) {
        Map.Entry<Integer, Set<VElement>> layer = depthMap.pollFirstEntry();
        while (layer != null) {
            int depth = layer.getKey();
            Set<VElement> containers = this.uniqueContainers((Collection<? extends VElement>)layer.getValue());
            containers.forEach(container -> this.reevaluate((VElement)container, controlDiagnosticMap));
            int depthUp = depth - 1;
            if (depthUp >= 0) {
                Set layerUp = (Set)depthMap.get(depthUp);
                if (layerUp != null) {
                    layerUp.addAll(containers);
                } else {
                    depthMap.put(depthUp, containers);
                }
            }
            layer = depthMap.pollFirstEntry();
        }
    }

    private void reevaluate(VElement vElement, Map<VElement, VDiagnostic> controlDiagnosticMap) {
        VDiagnostic vDiagnostic = VViewFactory.eINSTANCE.createDiagnostic();
        if (controlDiagnosticMap.containsKey(vElement)) {
            vDiagnostic.getDiagnostics().addAll((Collection)controlDiagnosticMap.get(vElement).getDiagnostics());
        }
        DiagnosticFrequencyMap freq = this.getFrequencyMap(vElement);
        for (EObject eObject : vElement.eContents()) {
            EList childDiagnostics;
            VElement childElement;
            if (VElement.class.isInstance(eObject) && (childElement = (VElement)eObject).getDiagnostic() != null && childElement.isEffectivelyEnabled() && childElement.isVisible() && freq.addAll((Collection)(childDiagnostics = childElement.getDiagnostic().getDiagnostics())) && freq.isFull() && freq.getDiscardedSeverity() > 2) break;
        }
        if (!freq.isEmpty()) {
            freq.appendTo((Collection)vDiagnostic.getDiagnostics());
            this.appendPlaceholder(freq, (List<? super Diagnostic>)vDiagnostic.getDiagnostics());
        }
        vElement.setDiagnostic(vDiagnostic);
    }

    private void reevaluateToTop(VElement element, Map<VElement, VDiagnostic> controlDiagnosticMap) {
        NavigableMap<Integer, Set<VElement>> depthMap = this.mapByDepth(controlDiagnosticMap.keySet());
        Set<VElement> containers = Collections.singleton(element);
        int cutoff = this.depth((EObject)element);
        depthMap.navigableKeySet().headSet(cutoff, true).clear();
        depthMap.put(cutoff, containers);
        this.reevaluate(element, controlDiagnosticMap);
        this.reevaluateToTop(depthMap, controlDiagnosticMap);
    }

    DiagnosticFrequencyMap getFrequencyMap(VElement vElement) {
        DiagnosticFrequencyMap result = this.propagationThreshold < 0 ? DiagnosticFrequencyMap.unlimited() : DiagnosticFrequencyMap.limitedTo((int)this.propagationThreshold);
        result.addDiagnosticFilter(this.placeholderFactory.notThresholdDiagnostic());
        return result;
    }

    private void appendPlaceholder(DiagnosticFrequencyMap freq, List<? super Diagnostic> diagnostics) {
        if (freq.getDiscardedSeverity() > 0) {
            diagnostics.add((Diagnostic)this.placeholderFactory.get(freq.getDiscardedSeverity()));
        }
    }

    private void validateAndCollectSettings(EObject eObject) {
        Diagnostic diagnostic;
        long start;
        block7: {
            start = System.nanoTime();
            diagnostic = this.validationService.validate(eObject);
            if (diagnostic != null) break block7;
            if (System.nanoTime() - start > 1000000000L) {
                this.reportService.report(new AbstractReport(MessageFormat.format("Validation took longer than expected for EObject {0}", eObject, 1)));
            }
            return;
        }
        try {
            for (EStructuralFeature feature : eObject.eClass().getEAllStructuralFeatures()) {
                UniqueSetting uniqueSetting = UniqueSetting.createSetting((EObject)eObject, (EStructuralFeature)feature);
                this.currentUpdates.computeIfAbsent(uniqueSetting, this.diagnosticListFactory);
            }
            this.analyzeDiagnostic(diagnostic);
        }
        catch (Throwable throwable) {
            if (System.nanoTime() - start > 1000000000L) {
                this.reportService.report(new AbstractReport(MessageFormat.format("Validation took longer than expected for EObject {0}", eObject, 1)));
            }
            throw throwable;
        }
        if (System.nanoTime() - start > 1000000000L) {
            this.reportService.report(new AbstractReport(MessageFormat.format("Validation took longer than expected for EObject {0}", eObject, 1)));
        }
    }

    private void analyzeDiagnostic(Diagnostic diagnostic) {
        if (diagnostic.getData().size() > 1) {
            InternalEObject internalEObject = DiagnosticHelper.getFirstInternalEObject((List)diagnostic.getData());
            EStructuralFeature eStructuralFeature = DiagnosticHelper.getEStructuralFeature((List)diagnostic.getData());
            if (internalEObject == null || eStructuralFeature == null) {
                return;
            }
            if (!internalEObject.eClass().getEAllStructuralFeatures().contains((Object)eStructuralFeature)) {
                this.reportService.report(new AbstractReport(MessageFormat.format("No Setting can be created for Diagnostic {0} since the EObject's EClass does not contain the Feature.", diagnostic), 1));
                return;
            }
            EStructuralFeature.Setting setting = internalEObject.eSetting(eStructuralFeature);
            UniqueSetting uniqueSetting = UniqueSetting.createSetting((EStructuralFeature.Setting)setting);
            this.currentUpdates.computeIfAbsent(uniqueSetting, this.diagnosticListFactory).add(diagnostic);
        } else {
            for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                this.analyzeDiagnostic(childDiagnostic);
            }
        }
    }

    @Override
    public void addValidationProvider(ValidationProvider validationProvider) {
        this.addValidationProvider(validationProvider, true);
    }

    @Override
    public void addValidationProvider(ValidationProvider validationProvider, boolean revalidate) {
        this.validationService.addValidator((Validator)validationProvider);
        if (revalidate && this.rootContext != null) {
            this.validate(this.getAllEObjectsToValidate(this.rootContext));
        }
    }

    @Override
    public void removeValidationProvider(ValidationProvider validationProvider) {
        this.removeValidationProvider(validationProvider, true);
    }

    @Override
    public void removeValidationProvider(ValidationProvider validationProvider, boolean revalidate) {
        this.validationService.removeValidator((Validator)validationProvider);
        if (revalidate && this.rootContext != null) {
            this.validate(this.getAllEObjectsToValidate(this.rootContext));
        }
    }

    @Override
    public void registerValidationListener(ViewValidationListener listener) {
        this.validationListeners.add(listener);
        listener.onNewValidation(this.getDiagnosticResult());
    }

    private Set<Diagnostic> getDiagnosticResult() {
        LinkedHashSet<Diagnostic> result = new LinkedHashSet<Diagnostic>();
        VDiagnostic diagnostic = this.rootContext.getViewModel().getDiagnostic();
        if (diagnostic != null) {
            for (Object diagObject : diagnostic.getDiagnostics()) {
                result.add((Diagnostic)diagObject);
            }
        }
        return result;
    }

    @Override
    public void deregisterValidationListener(ViewValidationListener listener) {
        this.validationListeners.remove(listener);
    }

    public void childViewModelContextAdded(ViewModelContext childContext) {
    }

    private void childContextAdded(EMFFormsViewContext parentContext, VElement parentElement, EMFFormsViewContext childContext) {
        if (childContext instanceof ViewModelContext) {
            this.validate(this.getAllEObjectsToValidate((ViewModelContext)childContext));
        }
        this.addViewModelChangeListener(childContext);
    }

    private void childContextRemoved(EMFFormsViewContext parentContext, VElement parentElement, EMFFormsViewContext childContext) {
        this.removeViewModelChangeListener(childContext);
    }

    private void contextInitialised(EMFFormsViewContext context) {
        if (context == this.rootContext) {
            this.initialized = true;
            this.validate(this.getAllEObjectsToValidate(this.rootContext));
        }
    }

    protected ViewSubstitutionLabelProviderFactory getSubstitutionLabelProviderFactory() {
        if (this.rootContext.hasService(ViewSubstitutionLabelProviderFactory.class)) {
            return (ViewSubstitutionLabelProviderFactory)this.rootContext.getService(ViewSubstitutionLabelProviderFactory.class);
        }
        return null;
    }

    private int getPropagationThreshold() {
        int result = -1;
        Object value = this.rootContext.getContextValue("org.eclipse.emf.ecp.view.validation.propagationLimit");
        if (value instanceof Integer) {
            int intValue = (Integer)value;
            if (intValue < 0) {
                this.warn("ValidationServiceImpl_limitNegative", value);
            } else {
                result = intValue;
            }
        } else {
            if (value == null || ValidationServiceConstants.PROPAGATION_UNLIMITED_VALUE.equals(value)) {
                return result;
            }
            this.warn("ValidationServiceImpl_limitUnknown", value);
        }
        return result;
    }

    protected void warn(String messageKey, Object ... arguments) {
        String report = NLS.bind((String)this.l10n.getString(ValidationServiceImpl.class, messageKey), (Object[])arguments);
        this.reportService.report(new AbstractReport(report, 2));
    }

    private class ValidationDomainModelChangeListener
    implements ModelChangeAddRemoveListener {
        private final ViewModelContext context;

        ValidationDomainModelChangeListener(ViewModelContext context) {
            this.context = context;
        }

        public void notifyChange(ModelChangeNotification notification) {
            Object newValue;
            if (ValidationNotification.class.isInstance(notification.getRawNotification())) {
                ValidationServiceImpl.this.validate(notification.getNotifier());
                return;
            }
            if (this.isIgnore(notification)) {
                return;
            }
            Notification rawNotification = notification.getRawNotification();
            int eventType = rawNotification.getEventType();
            if (eventType == 3 || eventType == 5) {
                this.handleAdd(notification);
                return;
            }
            if (eventType == 4 || eventType == 6) {
                this.handleRemove(notification);
                return;
            }
            ValidationServiceImpl.this.validate(notification.getNotifier());
            if (EReference.class.isInstance(notification.getStructuralFeature()) && notification.getRawNotification().getNewValue() != null && EObject.class.isInstance(newValue = notification.getRawNotification().getNewValue())) {
                ValidationServiceImpl.this.validate((EObject)newValue);
            }
        }

        private boolean isIgnore(ModelChangeNotification notification) {
            EReference eReference;
            if (notification.getRawNotification().isTouch()) {
                return true;
            }
            int eventType = notification.getRawNotification().getEventType();
            if (eventType == 8) {
                return true;
            }
            return eventType == 1 && EReference.class.isInstance(notification.getStructuralFeature()) && (eReference = (EReference)EReference.class.cast(notification.getStructuralFeature())).isContainer() && notification.getRawNotification().getNewValue() == null;
        }

        private void handleAdd(ModelChangeNotification notification) {
            LinkedHashSet<EObject> toValidate = new LinkedHashSet<EObject>();
            toValidate.add(notification.getNotifier());
            if (EReference.class.isInstance(notification.getStructuralFeature())) {
                if (3 == notification.getRawNotification().getEventType()) {
                    toValidate.addAll(ValidationServiceImpl.this.getAllEObjects((EObject)notification.getRawNotification().getNewValue()));
                } else {
                    toValidate.addAll((Collection)notification.getRawNotification().getNewValue());
                }
            }
            ValidationServiceImpl.this.validate(toValidate);
        }

        private void handleRemove(ModelChangeNotification notification) {
            Notification rawNotification = notification.getRawNotification();
            if (rawNotification.getEventType() == 4 && EReference.class.isInstance(rawNotification.getFeature())) {
                ValidationServiceImpl.this.cleanControlDiagnostics((EObject)EObject.class.cast(notification.getNotifier()), (EReference)EReference.class.cast(rawNotification.getFeature()), (EObject)EObject.class.cast(rawNotification.getOldValue()));
            }
            ValidationServiceImpl.this.validate(notification.getNotifier());
        }

        public void notifyAdd(Notifier notifier) {
            if (notifier == this.context.getDomainModel()) {
                ValidationServiceImpl.this.validate(ValidationServiceImpl.this.getAllEObjectsToValidate(this.context));
            }
        }

        public void notifyRemove(Notifier notifier) {
        }
    }

    private class ViewModelChangeListener
    implements ModelChangeAddRemoveListener {
        private final EMFFormsViewContext context;
        private boolean initialized;

        ViewModelChangeListener(EMFFormsViewContext context) {
            this.context = context;
        }

        void start() {
            this.initialized = true;
        }

        public void notifyChange(ModelChangeNotification notification) {
            if ((VViewPackage.eINSTANCE.getElement_Enabled() == notification.getRawNotification().getFeature() || VViewPackage.eINSTANCE.getElement_Visible() == notification.getRawNotification().getFeature()) && VViewPackage.eINSTANCE.getControl().isInstance((Object)notification.getNotifier())) {
                VControl control = (VControl)notification.getNotifier();
                VDomainModelReference domainModelReference = control.getDomainModelReference();
                if (domainModelReference == null) {
                    return;
                }
                try {
                    this.handleControlNotification(notification, control, domainModelReference);
                }
                catch (DatabindingFailedException ex) {
                    ValidationServiceImpl.this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                    return;
                }
            }
            if (!VElement.class.isInstance(notification.getNotifier())) {
                return;
            }
            switch (notification.getRawNotification().getEventType()) {
                case 4: 
                case 6: {
                    Map map = Collections.emptyMap();
                    ValidationServiceImpl.this.reevaluateToTop((VElement)notification.getNotifier(), (Map<VElement, VDiagnostic>)map);
                    break;
                }
            }
        }

        private void handleControlNotification(ModelChangeNotification notification, VControl control, VDomainModelReference domainModelReference) throws DatabindingFailedException {
            if (VViewPackage.eINSTANCE.getElement_Enabled() == notification.getRawNotification().getFeature()) {
                control.setDiagnostic(null);
            }
            Set settingsForControl = ValidationServiceImpl.this.controlMapper.getSettingsForControl(control);
            LinkedHashSet<EObject> eObjectsToValidate = new LinkedHashSet<EObject>();
            for (UniqueSetting setting : settingsForControl) {
                eObjectsToValidate.add(setting.getEObject());
            }
            ValidationServiceImpl.this.validate(eObjectsToValidate);
        }

        public void notifyAdd(Notifier notifier) {
            if (!this.initialized) {
                return;
            }
            if (VDomainModelReference.class.isInstance(notifier) && !VDomainModelReference.class.isInstance(((EObject)EObject.class.cast(notifier)).eContainer()) && !VDomainModelReferenceSegment.class.isInstance(((EObject)EObject.class.cast(notifier)).eContainer())) {
                VDomainModelReference domainModelReference = (VDomainModelReference)VDomainModelReference.class.cast(notifier);
                if (domainModelReference == null) {
                    return;
                }
                LinkedHashSet<EObject> eObjectsToValidate = new LinkedHashSet<EObject>();
                if (VControl.class.isInstance(domainModelReference.eContainer())) {
                    Set settings = ValidationServiceImpl.this.mappingProviderManager.getAllSettingsFor(domainModelReference, this.context.getDomainModel());
                    for (UniqueSetting setting : settings) {
                        EObject object = setting.getEObject();
                        if (object == null) continue;
                        eObjectsToValidate.add(object);
                    }
                } else {
                    IObservableValue observableValue;
                    try {
                        observableValue = ((EMFFormsDatabinding)this.context.getService(EMFFormsDatabinding.class)).getObservableValue(domainModelReference, this.context.getDomainModel());
                    }
                    catch (DatabindingFailedException ex) {
                        ValidationServiceImpl.this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                        return;
                    }
                    EObject observed = (EObject)((IObserving)observableValue).getObserved();
                    observableValue.dispose();
                    if (observed != null) {
                        eObjectsToValidate.add(observed);
                    }
                }
                ValidationServiceImpl.this.validate(eObjectsToValidate);
            }
        }

        public void notifyRemove(Notifier notifier) {
        }
    }
}

