/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ui.view.swt.reference;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.internal.swt.Activator;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContextFactory;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

class EditNewObjectDialog
extends Dialog {
    private final EObject eObject;

    EditNewObjectDialog(Shell parentshell, EObject eObject) {
        super(parentshell);
        this.eObject = eObject;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.eObject.eClass().getName());
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(450, 250).applyTo((Control)composite);
        ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 768);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)scrolledComposite);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        Composite content = new Composite((Composite)scrolledComposite, 0);
        GridLayoutFactory.fillDefaults().applyTo(content);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)content);
        ViewModelContext vmc = ViewModelContextFactory.INSTANCE.createViewModelContext((VElement)ViewProviderHelper.getView((EObject)this.eObject, null), this.eObject);
        if (AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.eObject).isReadOnly(this.eObject.eResource())) {
            vmc.getViewModel().setReadonly(true);
        }
        try {
            ECPSWTViewRenderer.INSTANCE.render(content, vmc);
        }
        catch (ECPRendererException ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new RenderingFailedReport(ex));
        }
        scrolledComposite.setContent((Control)content);
        Point point = content.computeSize(-1, -1);
        scrolledComposite.setMinSize(point);
        scrolledComposite.layout(true);
        return composite;
    }
}

