/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.handler;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.editor.handler.EStructuralFeatureContentProvider;
import org.eclipse.emf.ecp.view.internal.editor.handler.SegmentGenerator;
import org.eclipse.emf.ecp.view.spi.editor.controls.EStructuralFeatureSelectionValidator;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SelectFeaturePathWizardPage
extends WizardPage {
    private final VDomainModelReference domainModelReference;
    private EClass rootEClass;
    private final ISelection firstSelection;
    private ComposedAdapterFactory composedAdapterFactory;
    private AdapterFactoryLabelProvider labelProvider;
    private final boolean allowMultiReferencesInPath;
    private final SegmentGenerator segmentGenerator;
    private final EStructuralFeatureSelectionValidator selectionValidator;
    private TreeViewer treeViewer;

    public SelectFeaturePathWizardPage(String pageName, String pageTitle, String pageDescription, EClass rootEClass, ISelection firstSelection, SegmentGenerator segmentGenerator, EStructuralFeatureSelectionValidator selectionValidator, boolean allowMultiReferencesInPath) {
        super(pageName);
        this.setTitle(pageTitle);
        this.setDescription(pageDescription);
        this.rootEClass = rootEClass;
        this.firstSelection = firstSelection;
        this.domainModelReference = VViewFactory.eINSTANCE.createDomainModelReference();
        this.allowMultiReferencesInPath = allowMultiReferencesInPath;
        this.segmentGenerator = segmentGenerator;
        this.selectionValidator = selectionValidator;
    }

    public VDomainModelReference getDomainModelReference() {
        return this.domainModelReference;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 4);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)composite);
        this.treeViewer = this.createTreeViewer(composite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(this.treeViewer.getControl());
        this.composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.composedAdapterFactory);
        EStructuralFeatureContentProvider contentProvider = new EStructuralFeatureContentProvider(this.allowMultiReferencesInPath);
        this.treeViewer.setContentProvider((IContentProvider)contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.setInput((Object)this.rootEClass);
        this.treeViewer.addSelectionChangedListener(this.createSelectionChangedListener());
        this.treeViewer.setSelection(this.firstSelection, true);
        this.setControl((Control)composite);
    }

    protected TreeViewer createTreeViewer(Composite composite) {
        return new TreeViewer(composite);
    }

    public void setRootEClass(EClass rootEClass) {
        this.rootEClass = rootEClass;
        this.domainModelReference.getSegments().clear();
        this.setPageComplete(false);
        this.treeViewer.setInput((Object)rootEClass);
    }

    protected ISelectionChangedListener createSelectionChangedListener() {
        return event -> {
            this.setPageComplete(false);
            ITreeSelection treeSelection = (ITreeSelection)event.getSelection();
            if (treeSelection.getPaths().length < 1) {
                return;
            }
            EStructuralFeature structuralFeature = (EStructuralFeature)treeSelection.getFirstElement();
            String errorMessage = this.selectionValidator.isValid(structuralFeature);
            this.setErrorMessage(errorMessage);
            if (errorMessage != null) {
                return;
            }
            TreePath treePath = treeSelection.getPaths()[0];
            if (treePath.getSegmentCount() < 1) {
                return;
            }
            LinkedList<EStructuralFeature> bottomUpPath = new LinkedList<EStructuralFeature>();
            int i = 0;
            while (i < treePath.getSegmentCount()) {
                Object o = treePath.getSegment(i);
                bottomUpPath.add((EStructuralFeature)o);
                ++i;
            }
            this.configureSegments(bottomUpPath);
            if (!this.domainModelReference.getSegments().isEmpty()) {
                this.setPageComplete(true);
            }
        };
    }

    protected void configureSegments(List<EStructuralFeature> bottomUpPath) {
        if (!this.domainModelReference.getSegments().isEmpty()) {
            this.domainModelReference.getSegments().clear();
        }
        List<VDomainModelReferenceSegment> segments = this.segmentGenerator.generateSegments(bottomUpPath);
        this.domainModelReference.getSegments().addAll(segments);
    }

    public void dispose() {
        this.composedAdapterFactory.dispose();
        this.labelProvider.dispose();
        super.dispose();
    }
}

