/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.datatemplate;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecp.spi.common.ui.CompositeFactory;
import org.eclipse.emf.ecp.spi.common.ui.composites.SelectionComposite;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.datatemplate.Template;
import org.eclipse.emfforms.internal.core.services.datatemplate.EClassLabelProvider;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SelectSubclassAndTemplateWizard
extends Wizard {
    private static final String TEMPLATE_PAGE_NAME = "templateSelectionPage";
    private static final String CLASS_PAGE_NAME = "subClassSelectionPage";
    private SubClassSelectionPage subClassSelectionPage;
    private TemplateSelectionPage modelElementPage;
    private final Set<EClass> subClasses;
    private final Set<Template> allTemplates;
    private boolean showTemplateSelectionPage = true;
    private final EMFFormsLocalizationService localizationService;
    private EClass selectedSubClass;
    private boolean finished;

    public SelectSubclassAndTemplateWizard(String windowTitle, Set<EClass> subClasses, Set<Template> templates, EMFFormsLocalizationService localizationService) {
        this.setWindowTitle(windowTitle);
        this.subClasses = subClasses;
        this.localizationService = localizationService;
        this.allTemplates = templates;
    }

    public boolean performFinish() {
        this.finished = true;
        return true;
    }

    public boolean canFinish() {
        if (this.selectedSubClass != null && !this.showTemplateSelectionPage) {
            return true;
        }
        return super.canFinish();
    }

    public Optional<Template> getSelectedTemplate() {
        if (!this.finished) {
            return Optional.empty();
        }
        if (this.showTemplateSelectionPage) {
            Object[] selection = this.modelElementPage.getSelectionComposite().getSelection();
            if (selection != null && selection.length > 0) {
                return Optional.of((Object)((Template)selection[0]));
            }
        } else {
            Set<Template> templates = this.getAvailableTemplates(this.selectedSubClass);
            if (templates.iterator().hasNext()) {
                return Optional.of((Object)templates.iterator().next());
            }
        }
        return Optional.empty();
    }

    public void addPages() {
        this.modelElementPage = new TemplateSelectionPage(TEMPLATE_PAGE_NAME, this.localizationService.getString(SelectSubclassAndTemplateWizard.class, "SelectSubclassAndTemplateWizard_selectTemplateTitle"), this.localizationService.getString(SelectSubclassAndTemplateWizard.class, "SelectSubclassAndTemplateWizard_selectTemplateDescription"));
        if (this.subClasses.size() > 1) {
            this.subClassSelectionPage = new SubClassSelectionPage(CLASS_PAGE_NAME, this.localizationService.getString(SelectSubclassAndTemplateWizard.class, "SelectSubclassAndTemplateWizard_selectSubClassTitle"), this.localizationService.getString(SelectSubclassAndTemplateWizard.class, "SelectSubclassAndTemplateWizard_selectSubClassDescription"), this.subClasses);
            this.addPage((IWizardPage)this.subClassSelectionPage);
        }
        this.addPage((IWizardPage)this.modelElementPage);
        if (this.subClasses.size() == 1) {
            this.selectedSubClass = this.subClasses.iterator().next();
        }
        super.addPages();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.subClassSelectionPage && !this.showTemplateSelectionPage) {
            return null;
        }
        return super.getNextPage(page);
    }

    protected void setSubClass(EClass subClass) {
        Set<Template> availableTemplates = this.getAvailableTemplates(subClass);
        this.showTemplateSelectionPage = availableTemplates.size() > 1;
        this.modelElementPage.updateSelectionComposite(availableTemplates);
        this.selectedSubClass = subClass;
    }

    protected Set<Template> getAvailableTemplates(EClass eClass) {
        LinkedHashSet<Template> availableTemplates = new LinkedHashSet<Template>();
        if (eClass != null) {
            for (Template template : this.allTemplates) {
                if (!eClass.isSuperTypeOf(template.getInstance().eClass())) continue;
                availableTemplates.add(template);
            }
        }
        return availableTemplates;
    }

    abstract class SelectionPage
    extends WizardPage {
        protected SelectionPage(String pageName, String pageTitle, String pageDescription) {
            super(pageName);
            this.setTitle(pageTitle);
            this.setDescription(pageDescription);
        }

        public void createControl(Composite parent) {
            Composite composite = this.getSelectionComposite().createUI(parent);
            if (this.getSelectionComposite().getViewer() instanceof TreeViewer) {
                TreeViewer tv = (TreeViewer)this.getSelectionComposite().getViewer();
                tv.expandToLevel(2);
            }
            ((ColumnViewer)this.getSelectionComposite().getViewer()).addSelectionChangedListener(this.getSelectionChangedListener());
            this.setPageComplete(false);
            this.setControl((Control)composite);
        }

        protected abstract ISelectionChangedListener getSelectionChangedListener();

        protected abstract SelectionComposite<? extends ColumnViewer> getSelectionComposite();
    }

    class SubClassSelectionPage
    extends SelectionPage {
        private final Set<EClass> availableEClasses;
        private SelectionComposite<TableViewer> selectionComposite;

        protected SubClassSelectionPage(String pageName, String pageTitle, String pageDescription, Set<EClass> availableEClasses) {
            super(pageName, pageTitle, pageDescription);
            this.setTitle(pageTitle);
            this.setDescription(pageDescription);
            this.availableEClasses = availableEClasses;
        }

        @Override
        protected SelectionComposite<? extends ColumnViewer> getSelectionComposite() {
            if (this.selectionComposite == null) {
                this.selectionComposite = CompositeFactory.getTableSelectionComposite((Object)this.availableEClasses.toArray(), (boolean)false);
            }
            return this.selectionComposite;
        }

        @Override
        public void createControl(Composite parent) {
            super.createControl(parent);
            ((ColumnViewer)this.getSelectionComposite().getViewer()).setLabelProvider((IBaseLabelProvider)new EClassLabelProvider(SelectSubclassAndTemplateWizard.this.localizationService));
        }

        @Override
        protected ISelectionChangedListener getSelectionChangedListener() {
            return new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection sel = (IStructuredSelection)((ColumnViewer)SubClassSelectionPage.this.getSelectionComposite().getViewer()).getSelection();
                    if (sel != null && !sel.isEmpty()) {
                        SelectSubclassAndTemplateWizard.this.setSubClass((EClass)sel.getFirstElement());
                        SubClassSelectionPage.this.setPageComplete(true);
                    } else {
                        SubClassSelectionPage.this.setPageComplete(false);
                    }
                }
            };
        }
    }

    class TemplateSelectionPage
    extends SelectionPage {
        private SelectionComposite<TableViewer> selectionComposite;

        protected TemplateSelectionPage(String pageName, String pageTitle, String pageDescription) {
            super(pageName, pageTitle, pageDescription);
        }

        @Override
        protected SelectionComposite<? extends ColumnViewer> getSelectionComposite() {
            if (this.selectionComposite == null) {
                Set templates = SelectSubclassAndTemplateWizard.this.selectedSubClass != null ? SelectSubclassAndTemplateWizard.this.getAvailableTemplates(SelectSubclassAndTemplateWizard.this.selectedSubClass) : Collections.emptySet();
                this.selectionComposite = CompositeFactory.getTableSelectionComposite(templates, (boolean)false);
            }
            return this.selectionComposite;
        }

        public void updateSelectionComposite(Set<Template> availableTemplates) {
            ((ColumnViewer)this.getSelectionComposite().getViewer()).setInput(availableTemplates);
            this.setPageComplete(false);
        }

        @Override
        protected ISelectionChangedListener getSelectionChangedListener() {
            return new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection sel = (IStructuredSelection)((ColumnViewer)TemplateSelectionPage.this.getSelectionComposite().getViewer()).getSelection();
                    if (sel != null && !sel.isEmpty()) {
                        TemplateSelectionPage.this.setPageComplete(true);
                    } else {
                        TemplateSelectionPage.this.setPageComplete(false);
                    }
                }
            };
        }
    }
}

