/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.time;

import jakarta.validation.ClockProvider;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.constraints.PastOrPresent;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Set;
import java.util.TimeZone;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.time.FixedClockProvider;
import org.hibernate.beanvalidation.tck.tests.time.PastOrPresentDummyEntity;
import org.hibernate.beanvalidation.tck.tests.time.PastOrPresentRelativePartialDummyEntity;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="4.0.0")
public class ClockProviderPastOrPresentTest
extends AbstractTCKTest {
    private static final ZoneId TZ_BERLIN = ZoneId.of("Europe/Berlin");

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)ClockProviderPastOrPresentTest.webArchiveBuilder().withTestClassPackage(ClockProviderPastOrPresentTest.class)).build();
    }

    @Test
    @SpecAssertion(section="builtinconstraints-pastorpresent", id="a")
    public void clockProviderIsUsed() {
        PastOrPresentDummyEntity dummy = new PastOrPresentDummyEntity(ZonedDateTime.of(1985, 6, 12, 3, 0, 0, 0, TZ_BERLIN));
        Validator validator = TestUtil.getValidatorUnderTest();
        ConstraintViolationAssert.assertNoViolations(validator.validate((Object)dummy, new Class[0]));
        FixedClockProvider clockProvider = new FixedClockProvider(ZonedDateTime.of(1984, 2, 15, 4, 0, 0, 0, TZ_BERLIN));
        ValidatorFactory validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)clockProvider).buildValidatorFactory();
        validator = validatorFactory.getValidator();
        Set violations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("date"), ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("calendar"), ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("instant"), ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("hijrahDate"), ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("japaneseDate"), ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("localDate"), ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("localDateTime"), ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("minguoDate"), ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("offsetDateTime"), ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("thaiBuddhistDate"), ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("year"), ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("yearMonth"), ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("zonedDateTime"));
    }

    @Test
    @SpecAssertion(section="builtinconstraints-pastorpresent", id="a")
    public void clockProviderIsUsedForRelativePartials() {
        Calendar cal = GregorianCalendar.getInstance(TimeZone.getTimeZone(TZ_BERLIN));
        cal.set(2016, 6, 6);
        cal.set(11, 14);
        cal.set(12, 45);
        PastOrPresentRelativePartialDummyEntity dummy = new PastOrPresentRelativePartialDummyEntity(ZonedDateTime.of(2016, 6, 6, 14, 45, 0, 0, TZ_BERLIN));
        FixedClockProvider clockProvider = new FixedClockProvider(ZonedDateTime.of(2016, 8, 15, 16, 15, 0, 0, TZ_BERLIN));
        ValidatorFactory validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)clockProvider).buildValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        ConstraintViolationAssert.assertNoViolations(validator.validate((Object)dummy, new Class[0]));
        clockProvider = new FixedClockProvider(ZonedDateTime.of(2014, 4, 4, 9, 45, 0, 0, TZ_BERLIN));
        validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)clockProvider).buildValidatorFactory();
        validator = validatorFactory.getValidator();
        Set violations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("localTime"), ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("monthDay"), ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("offsetTime"));
    }
}

