/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.impl.enricher.resource;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.client.deployment.Deployment;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentScenario;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentTargetDescription;
import org.jboss.arquillian.container.spi.client.deployment.TargetDescription;
import org.jboss.arquillian.container.spi.context.ContainerContext;
import org.jboss.arquillian.container.spi.context.DeploymentContext;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;

public abstract class OperatesOnDeploymentAwareProvider
implements ResourceProvider {
    @Inject
    private Instance<ContainerContext> containerContext;
    @Inject
    private Instance<DeploymentContext> deploymentContext;
    @Inject
    private Instance<DeploymentScenario> deploymentScenario;
    @Inject
    private Instance<ContainerRegistry> containerRegistry;

    public abstract Object doLookup(ArquillianResource var1, Annotation ... var2);

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        return this.runInDeploymentContext(resource, qualifiers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object runInDeploymentContext(ArquillianResource resource, Annotation ... qualifiers) {
        DeploymentContext context = null;
        DeploymentScenario scenario = null;
        boolean activateContext = this.containsOperatesOnDeployment(qualifiers);
        boolean contextActivated = false;
        try {
            Deployment deployment = null;
            if (activateContext) {
                context = (DeploymentContext)this.deploymentContext.get();
                scenario = (DeploymentScenario)this.deploymentScenario.get();
                if (scenario == null) {
                    throw new IllegalStateException("No " + DeploymentScenario.class.getSimpleName() + " found. Possible cause, @" + OperateOnDeployment.class.getSimpleName() + " is currently only supported on the client side. (@" + RunAsClient.class.getSimpleName() + ")");
                }
                OperateOnDeployment operatesOn = this.getOperatesOnDeployment(qualifiers);
                deployment = scenario.deployment(new DeploymentTargetDescription(operatesOn.value()));
                if (deployment == null) {
                    throw new IllegalArgumentException("Could not operate on deployment (@" + OperateOnDeployment.class.getSimpleName() + "), no deployment found with name: " + operatesOn.value());
                }
                context.activate((Object)deployment);
                contextActivated = true;
            }
            Object object = this.runInContainerContext(deployment == null ? null : deployment.getDescription().getTarget(), resource, qualifiers);
            return object;
        }
        finally {
            if (contextActivated) {
                context.deactivate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object runInContainerContext(TargetDescription targetDescription, ArquillianResource resource, Annotation ... qualifiers) {
        ContainerContext context = null;
        ContainerRegistry registry = null;
        boolean activateContext = targetDescription != null;
        boolean contextActivated = false;
        try {
            if (activateContext) {
                context = (ContainerContext)this.containerContext.get();
                registry = (ContainerRegistry)this.containerRegistry.get();
                if (registry == null) {
                    throw new IllegalStateException("No " + ContainerRegistry.class.getSimpleName() + " found. Possible problem is, @" + OperateOnDeployment.class.getSimpleName() + " is currently only supported on the client side.");
                }
                Container container = registry.getContainer(targetDescription);
                if (container == null) {
                    throw new IllegalArgumentException("Could not operate on deployment (@" + OperateOnDeployment.class.getSimpleName() + "), no container found with name: " + targetDescription);
                }
                context.activate((Object)container.getName());
                contextActivated = true;
            }
            Object object = this.doLookup(resource, qualifiers);
            return object;
        }
        finally {
            if (contextActivated) {
                context.deactivate();
            }
        }
    }

    public boolean containsOperatesOnDeployment(Annotation[] qualifiers) {
        return this.getOperatesOnDeployment(qualifiers) != null;
    }

    private OperateOnDeployment getOperatesOnDeployment(Annotation[] qualifiers) {
        if (qualifiers != null) {
            for (Annotation annotation : qualifiers) {
                if (annotation.annotationType() != OperateOnDeployment.class) continue;
                return (OperateOnDeployment)OperateOnDeployment.class.cast(annotation);
            }
        }
        return null;
    }
}

