/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.shrinkwrap;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;

public final class AssetUtil {
    public static final String DELIMITER_CLASS_NAME_PATH = "\\.";
    public static final String DELIMITER_RESOURCE_PATH = "/";
    private static final String EXTENSION_CLASS = ".class";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private AssetUtil() {
    }

    public static ArchivePath getFullPathForClassResource(Class<?> clazz) {
        String classResourceDelimiter = clazz.getName().replaceAll(DELIMITER_CLASS_NAME_PATH, DELIMITER_RESOURCE_PATH);
        String classFullPath = classResourceDelimiter + EXTENSION_CLASS;
        return new BasicPath(classFullPath);
    }

    public static ArchivePath getFullPathForClassResource(String className) {
        String classResourceDelimiter = className.replaceAll(DELIMITER_CLASS_NAME_PATH, DELIMITER_RESOURCE_PATH);
        String classFullPath = classResourceDelimiter + EXTENSION_CLASS;
        return new BasicPath(classFullPath);
    }

    public static String readAssetContent(Asset asset) {
        if (asset == null) {
            throw new NullPointerException();
        }
        InputStream in = asset.openStream();
        if (in == null) {
            return null;
        }
        try {
            StringBuilder content = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            String line = reader.readLine();
            while (line != null) {
                content.append(line);
                content.append(LINE_SEPARATOR);
                line = reader.readLine();
            }
            String string = content.toString();
            return string;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Cannot read string from " + asset, ioe);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("Cannot not close input stream from " + asset, ioe);
            }
        }
    }
}

