/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.extensions.lifecycle.processInjectionPoint;

import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processInjectionPoint.Alpha;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processInjectionPoint.Bar;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processInjectionPoint.Bravo;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processInjectionPoint.Charlie;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processInjectionPoint.Delta;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processInjectionPoint.Foo;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processInjectionPoint.InjectingBean;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processInjectionPoint.PlainAnnotation;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processInjectionPoint.VerifyingExtension;
import org.jboss.cdi.tck.util.HierarchyDiscovery;
import org.jboss.shrinkwrap.api.BeanDiscoveryMode;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"cdi-full"})
@SpecVersion(spec="cdi", version="2.0")
public class ProcessInjectionPointFiredTest
extends AbstractTest {
    @Inject
    private VerifyingExtension extension;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ProcessInjectionPointFiredTest.class)).withBeansXml(new BeansXml(BeanDiscoveryMode.ALL))).withWebResource("faces-config.xml", "/WEB-INF/faces-config.xml")).withExtension(VerifyingExtension.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_injection_point", id="a"), @SpecAssertion(section="process_injection_point", id="ba"), @SpecAssertion(section="bean_discovery_steps", id="e"), @SpecAssertion(section="bean_discovery_steps", id="ja")})
    public void testFieldInjectionPoint() {
        InjectionPoint ip = this.extension.getAlpha();
        Assert.assertNotNull((Object)ip);
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)ip.getQualifiers(), Foo.class));
        Assert.assertNotNull((Object)ip.getBean());
        Assert.assertEquals(this.extension.getInjectingBean(), (Object)ip.getBean());
        ProcessInjectionPointFiredTest.verifyType(ip, Alpha.class, String.class);
        ProcessInjectionPointFiredTest.verifyAnnotated(ip);
        ProcessInjectionPointFiredTest.verifyMember(ip, InjectingBean.class);
        Assert.assertFalse((boolean)ip.isDelegate());
        Assert.assertTrue((boolean)ip.isTransient());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_injection_point", id="a"), @SpecAssertion(section="process_injection_point", id="ba"), @SpecAssertion(section="bean_discovery_steps", id="e"), @SpecAssertion(section="bean_discovery_steps", id="ja")})
    public void testConstructorInjectionPoint() {
        InjectionPoint ip = this.extension.getBravo();
        Assert.assertNotNull((Object)ip);
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)ip.getQualifiers(), Bar.class));
        Assert.assertNotNull((Object)ip.getBean());
        Assert.assertEquals(this.extension.getInjectingBean(), (Object)ip.getBean());
        ProcessInjectionPointFiredTest.verifyType(ip, Bravo.class, String.class);
        ProcessInjectionPointFiredTest.verifyAnnotated(ip);
        ProcessInjectionPointFiredTest.verifyMember(ip, InjectingBean.class);
        Assert.assertFalse((boolean)ip.isDelegate());
        Assert.assertFalse((boolean)ip.isTransient());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_injection_point", id="a"), @SpecAssertion(section="process_injection_point", id="ba"), @SpecAssertion(section="bean_discovery_steps", id="e")})
    public void testInitializerInjectionPoint() {
        InjectionPoint ip = this.extension.getCharlie();
        Assert.assertNotNull((Object)ip);
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)ip.getQualifiers(), Default.class));
        Assert.assertNotNull((Object)ip.getBean());
        Assert.assertEquals(this.extension.getInjectingBean(), (Object)ip.getBean());
        ProcessInjectionPointFiredTest.verifyType(ip, Charlie.class, new Class[0]);
        ProcessInjectionPointFiredTest.verifyAnnotated(ip);
        ProcessInjectionPointFiredTest.verifyMember(ip, InjectingBean.class);
        Assert.assertFalse((boolean)ip.isDelegate());
        Assert.assertFalse((boolean)ip.isTransient());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_injection_point", id="a"), @SpecAssertion(section="process_injection_point", id="ba")})
    public void testProducerMethodInjectionPoint1() {
        InjectionPoint ip = this.extension.getProducerAlpha();
        Assert.assertNotNull((Object)ip);
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)ip.getQualifiers(), Foo.class));
        Assert.assertNotNull((Object)ip.getBean());
        Assert.assertEquals(this.extension.getProducingBean(), (Object)ip.getBean());
        ProcessInjectionPointFiredTest.verifyType(ip, Alpha.class, Integer.class);
        ProcessInjectionPointFiredTest.verifyAnnotated(ip);
        ProcessInjectionPointFiredTest.verifyMember(ip, InjectingBean.class);
        Assert.assertFalse((boolean)ip.isDelegate());
        Assert.assertFalse((boolean)ip.isTransient());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_injection_point", id="a"), @SpecAssertion(section="process_injection_point", id="ba")})
    public void testProducerMethodInjectionPoint2() {
        InjectionPoint ip = this.extension.getProducerBravo();
        Assert.assertNotNull((Object)ip);
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)ip.getQualifiers(), Bar.class));
        Assert.assertNotNull((Object)ip.getBean());
        Assert.assertEquals(this.extension.getProducingBean(), (Object)ip.getBean());
        ProcessInjectionPointFiredTest.verifyType(ip, Bravo.class, Integer.class);
        ProcessInjectionPointFiredTest.verifyAnnotated(ip);
        ProcessInjectionPointFiredTest.verifyMember(ip, InjectingBean.class);
        Assert.assertFalse((boolean)ip.isDelegate());
        Assert.assertFalse((boolean)ip.isTransient());
    }

    @Test
    @SpecAssertion(section="bean_discovery_steps", id="ka")
    public void testObserverMethodInjectionPoint() {
        InjectionPoint charlieIp = this.extension.getObserverCharliIp();
        Assert.assertNotNull((Object)charlieIp);
        ProcessInjectionPointFiredTest.verifyType(charlieIp, Charlie.class, new Class[0]);
        InjectionPoint deltaIp = this.extension.getObserverDeltaIp();
        Assert.assertNotNull((Object)deltaIp);
        ProcessInjectionPointFiredTest.verifyType(deltaIp, Delta.class, new Class[0]);
    }

    @Test
    @SpecAssertion(section="bean_discovery_steps", id="je")
    public void testDisposerMethodInjectionPoint() {
        InjectionPoint deltaIp = this.extension.getDisposerDeltaIp();
        Assert.assertNotNull((Object)deltaIp);
        ProcessInjectionPointFiredTest.verifyType(deltaIp, Delta.class, new Class[0]);
    }

    private static void verifyType(InjectionPoint ip, Class<?> rawType, Class<?> ... typeParameters) {
        Assert.assertEquals(ProcessInjectionPointFiredTest.getRawType(ip.getType()), rawType);
        if (typeParameters.length > 0) {
            Assert.assertTrue((boolean)(ip.getType() instanceof ParameterizedType));
            Assert.assertTrue((boolean)Arrays.equals(typeParameters, ProcessInjectionPointFiredTest.getActualTypeArguments(ip.getType())));
        }
    }

    private static void verifyAnnotated(InjectionPoint ip) {
        Assert.assertNotNull((Object)ip.getAnnotated());
        Assert.assertTrue((boolean)ip.getAnnotated().isAnnotationPresent(PlainAnnotation.class));
    }

    private static void verifyMember(InjectionPoint ip, Class<?> declaringClass) {
        Assert.assertNotNull((Object)ip.getMember());
        Assert.assertEquals(declaringClass, ip.getMember().getDeclaringClass());
    }

    private static <T> Class<T> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() instanceof Class) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return null;
    }

    private static Type[] getActualTypeArguments(Type type) {
        Type resolvedType = new HierarchyDiscovery(type).getResolvedType();
        if (resolvedType instanceof ParameterizedType) {
            return ((ParameterizedType)resolvedType).getActualTypeArguments();
        }
        return new Type[0];
    }
}

