/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.dynamic.handle;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.dynamic.handle.Alpha;
import org.jboss.cdi.tck.tests.lookup.dynamic.handle.Bravo;
import org.jboss.cdi.tck.tests.lookup.dynamic.handle.Client;
import org.jboss.cdi.tck.tests.lookup.dynamic.handle.Processor;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="4.0")
public class InstanceHandleTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InstanceHandleTest.class)).build();
    }

    @Test
    public void testIsResolvable() {
        Client client = this.getContextualReference(Client.class, new Annotation[0]);
        ActionSequence.reset();
        Assert.assertNotNull((Object)client);
        Assert.assertTrue((boolean)client.getAlphaInstance().isResolvable());
        Assert.assertFalse((boolean)client.getBigDecimalInstance().isResolvable());
    }

    @Test
    public void testGetHandle() {
        String alpha2Id;
        Client client = this.getContextualReference(Client.class, new Annotation[0]);
        BeanManager beanManager = this.getCurrentManager();
        ActionSequence.reset();
        Assert.assertNotNull((Object)client);
        Bean alphaBean = beanManager.resolve(beanManager.getBeans(Alpha.class, new Annotation[0]));
        Instance<Alpha> instance = client.getAlphaInstance();
        Instance.Handle alpha1 = instance.getHandle();
        Assert.assertEquals((Object)alphaBean, (Object)alpha1.getBean());
        Assert.assertEquals(Dependent.class, (Object)alpha1.getBean().getScope());
        try (Instance.Handle alpha2 = instance.getHandle();){
            alpha2Id = ((Alpha)alpha2.get()).getId();
            Assert.assertFalse((boolean)((Alpha)alpha1.get()).getId().equals(alpha2Id));
        }
        List<String> sequence = ActionSequence.getSequenceData();
        Assert.assertEquals((int)1, (int)sequence.size());
        Assert.assertEquals((String)alpha2Id, (String)sequence.get(0));
        alpha1.destroy();
        alpha1.destroy();
        sequence = ActionSequence.getSequenceData();
        Assert.assertEquals((int)2, (int)sequence.size());
        Instance bravoInstance = client.getInstance().select(Bravo.class, new Annotation[0]);
        String bravoId = ((Bravo)bravoInstance.get()).getId();
        try (Instance.Handle bravo = bravoInstance.getHandle();){
            Assert.assertEquals((String)bravoId, (String)((Bravo)bravo.get()).getId());
            ActionSequence.reset();
        }
        sequence = ActionSequence.getSequenceData();
        Assert.assertEquals((int)1, (int)sequence.size());
        Assert.assertEquals((String)bravoId, (String)sequence.get(0));
    }

    @Test
    public void testGetAfterDestroyingContextualInstance() {
        ActionSequence.reset();
        Client client = this.getContextualReference(Client.class, new Annotation[0]);
        Assert.assertNotNull((Object)client);
        Instance.Handle alphaHandle = client.getAlphaInstance().getHandle();
        alphaHandle.get();
        alphaHandle.destroy();
        List<String> sequence = ActionSequence.getSequenceData();
        Assert.assertEquals((int)1, (int)sequence.size());
        try {
            alphaHandle.get();
            Assert.fail((String)"Invoking Handle.get() after destroying contextual instance should throw an exception.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testHandles() {
        Instance instance = this.getCurrentManager().createInstance().select(Processor.class, new Annotation[0]);
        ActionSequence.reset();
        Assert.assertTrue((boolean)instance.isAmbiguous());
        for (Instance.Handle handle : instance.handles()) {
            ((Processor)handle.get()).ping();
            if (!handle.getBean().getScope().equals(Dependent.class)) continue;
            handle.destroy();
        }
        Assert.assertEquals((int)3, (int)ActionSequence.getSequenceSize());
        ActionSequence.assertSequenceDataContainsAll("firstPing", "secondPing", "firstDestroy");
        ActionSequence.reset();
        Assert.assertTrue((boolean)instance.isAmbiguous());
        for (Instance.Handle handle : instance.handles()) {
            try {
                ((Processor)handle.get()).ping();
            }
            finally {
                if (handle == null) continue;
                handle.close();
            }
        }
        Assert.assertEquals((int)4, (int)ActionSequence.getSequenceSize());
        ActionSequence.assertSequenceDataContainsAll("firstPing", "secondPing", "firstDestroy", "secondDestroy");
    }
}

