/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.interceptors.definition.inheritance_ee;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.ee.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance_ee.Cactus;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance_ee.Culinary;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance_ee.European;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance_ee.ForgetMeNot;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance_ee.Grass;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance_ee.Opuncia;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance_ee.Shrub;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance_ee.SquirrelInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance_ee.WaterChestnut;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance_ee.WoodForgetMeNot;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance_ee.WoodpeckerInterceptor;
import org.jboss.shrinkwrap.api.BeanDiscoveryMode;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class InterceptorBindingInheritanceTest
extends AbstractTest {
    private String squirrel = SquirrelInterceptor.class.getName();
    private String woodpecker = WoodpeckerInterceptor.class.getName();

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InterceptorBindingInheritanceTest.class)).withBeansXml(new BeansXml(BeanDiscoveryMode.ALL).interceptors(new Class[]{SquirrelInterceptor.class, WoodpeckerInterceptor.class}))).build();
    }

    @Test(groups={"integration"}, dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="type_level_inheritance_ee", id="an"), @SpecAssertion(section="type_level_inheritance_ee", id="ana")})
    public void testInterceptorBindingDirectlyInheritedFromSessionBean(ForgetMeNot forgetMeNot) throws Exception {
        forgetMeNot.pong();
        Assert.assertTrue((boolean)forgetMeNot.inspectedBy(this.squirrel));
        Assert.assertFalse((boolean)forgetMeNot.inspectedBy(this.woodpecker));
    }

    @Test(groups={"integration"}, dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="type_level_inheritance_ee", id="ar"), @SpecAssertion(section="type_level_inheritance_ee", id="ara")})
    public void testInterceptorBindingIndirectlyInheritedFromSessionBean(@European ForgetMeNot woodForgetMeNot) throws Exception {
        woodForgetMeNot.pong();
        Assert.assertTrue((boolean)(woodForgetMeNot instanceof WoodForgetMeNot));
        Assert.assertTrue((boolean)woodForgetMeNot.inspectedBy(this.squirrel));
        Assert.assertFalse((boolean)woodForgetMeNot.inspectedBy(this.woodpecker));
    }

    @Test(groups={"integration"}, dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="member_level_inheritance_ee", id="kb")
    public void testMethodInterceptorBindingDirectlyInheritedFromSessionBean(Grass grass) {
        grass.pong();
        Assert.assertTrue((boolean)grass.inspectedBy(this.squirrel));
    }

    @Test(groups={"integration"}, dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="member_level_inheritance_ee", id="kd")
    public void testMethodInterceptorBindingIndirectlyInheritedFromSessionBean(@Culinary Grass waterChestnut) {
        waterChestnut.pong();
        Assert.assertTrue((boolean)(waterChestnut instanceof WaterChestnut));
        Assert.assertTrue((boolean)waterChestnut.inspectedBy(this.squirrel));
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="member_level_inheritance", id="ka")
    public void testMethodInterceptorBindingDirectlyNotInheritedFromManagedBean(Shrub shrub) {
        shrub.pong();
        Assert.assertFalse((boolean)shrub.inspectedBy(this.squirrel));
    }

    @Test(groups={"integration"}, dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="member_level_inheritance_ee", id="kb")
    public void testMethodInterceptorBindingDirectlyNotInheritedFromSessionBean(Cactus cactus) {
        cactus.pong();
        Assert.assertFalse((boolean)cactus.inspectedBy(this.squirrel));
    }

    @Test(groups={"integration"}, dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="member_level_inheritance_ee", id="kd")
    public void testMethodInterceptorBindingIndirectlyNotInheritedFromSessionBean(@Culinary Cactus opuncia) {
        opuncia.pong();
        Assert.assertTrue((boolean)(opuncia instanceof Opuncia));
        Assert.assertFalse((boolean)opuncia.inspectedBy(this.squirrel));
    }
}

