/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.conversation.determination;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.cdi.tck.tests.context.conversation.determination.AsyncRequestProcessor;
import org.jboss.cdi.tck.tests.context.conversation.determination.QuxAsyncListener;
import org.jboss.cdi.tck.tests.context.conversation.determination.StatusBean;

@WebServlet(value={"/foo-async"}, asyncSupported=true)
public class AsyncFooServlet
extends HttpServlet {
    public static final String TIMEOUT = "timeout";
    public static final String COMPLETE = "complete";
    public static final String ERROR = "error";
    public static final String LOOP = "loop";
    private static boolean inLoop = false;
    private ExecutorService executorService;
    @Inject
    StatusBean statusBean;

    public void init() throws ServletException {
        this.executorService = Executors.newSingleThreadExecutor();
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String param = req.getParameter("action");
        String cid = req.getParameter("cid");
        this.statusBean.reset();
        AsyncContext actx = req.startAsync();
        actx.addListener(actx.createListener(QuxAsyncListener.class));
        resp.setContentType("text/plain");
        if (TIMEOUT.equals(param)) {
            actx.setTimeout(150L);
        } else if (COMPLETE.equals(param)) {
            this.executorService.execute(new AsyncRequestProcessor(actx, 50L, false, null));
        } else if (ERROR.equals(param)) {
            this.executorService.execute(new AsyncRequestProcessor(actx, 50L, true, "/FailingServlet?cid=" + cid));
        } else if (LOOP.equals(param)) {
            if (inLoop) {
                this.executorService.execute(new AsyncRequestProcessor(actx, 50L, false, null));
            } else {
                this.executorService.execute(new AsyncRequestProcessor(actx, 50L, true, null));
                inLoop = true;
            }
        }
    }
}

