/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request.ejb;

import java.lang.annotation.Annotation;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.ejb.EJB;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.EnterpriseArchiveBuilder;
import org.jboss.cdi.tck.tests.context.request.ejb.BarBean;
import org.jboss.cdi.tck.tests.context.request.ejb.FMS;
import org.jboss.cdi.tck.tests.context.request.ejb.FMSModelIII;
import org.jboss.cdi.tck.tests.context.request.ejb.FooBean;
import org.jboss.cdi.tck.tests.context.request.ejb.FooRemote;
import org.jboss.cdi.tck.tests.context.request.ejb.FooRequestBean;
import org.jboss.cdi.tck.tests.context.request.ejb.SimpleRequestBean;
import org.jboss.cdi.tck.util.Timer;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class EJBRequestContextTest
extends AbstractTest {
    @EJB(lookup="java:global/test-ejb/test-ejb/FooBean!org.jboss.cdi.tck.tests.context.request.ejb.FooRemote")
    FooRemote foo;
    @Inject
    BarBean bar;

    @Deployment(name="TEST", order=1)
    public static EnterpriseArchive createTestArchive() {
        return (EnterpriseArchive)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)new EnterpriseArchiveBuilder().withTestClass(EJBRequestContextTest.class)).setAsClientMode(false)).withClasses(FMS.class, FMSModelIII.class, BarBean.class, SimpleRequestBean.class, FooRemote.class)).build();
    }

    @Deployment(name="REMOTE_EJB", order=2, testable=false)
    public static EnterpriseArchive createEjbArchive() {
        return (EnterpriseArchive)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)new EnterpriseArchiveBuilder().notTestArchive()).noDefaultWebModule().withName("test-ejb.ear")).withEjbModuleName("test-ejb.jar").withClasses(FooBean.class, FooRemote.class, FooRequestBean.class)).build();
    }

    @OperateOnDeployment(value="TEST")
    @Test(groups={"javaee-full"})
    @SpecAssertion(section="request_context_ee", id="gc")
    public void testRequestScopeActiveDuringCallToEjbTimeoutMethod() throws Exception {
        FMSModelIII.reset();
        FMS flightManagementSystem = this.getContextualReference(FMS.class, new Annotation[0]);
        flightManagementSystem.climb();
        new Timer().setDelay(20L, TimeUnit.SECONDS).addStopCondition(new Timer.StopCondition(){

            @Override
            public boolean isSatisfied() {
                return FMSModelIII.isClimbed();
            }
        }).start();
        Assert.assertTrue((boolean)flightManagementSystem.isRequestScopeActive());
    }

    @OperateOnDeployment(value="TEST")
    @Test(groups={"javaee-full"})
    @SpecAssertion(section="request_context_ee", id="hc")
    public void testRequestScopeDestroyedAfterCallToEjbTimeoutMethod() throws Exception {
        FMSModelIII.reset();
        SimpleRequestBean.reset();
        FMS flightManagementSystem = this.getContextualReference(FMS.class, new Annotation[0]);
        flightManagementSystem.climb();
        Timer timer = new Timer().setDelay(20L, TimeUnit.SECONDS).addStopCondition(new Timer.StopCondition(){

            @Override
            public boolean isSatisfied() {
                return FMSModelIII.isClimbed();
            }
        }).start();
        flightManagementSystem.descend();
        timer.addStopCondition(new Timer.StopCondition(){

            @Override
            public boolean isSatisfied() {
                return FMSModelIII.isDescended();
            }
        }, true).start();
        Assert.assertFalse((boolean)flightManagementSystem.isSameBean());
        Assert.assertTrue((boolean)SimpleRequestBean.isBeanDestroyed());
    }

    @OperateOnDeployment(value="TEST")
    @Test(groups={"javaee-full"})
    @SpecAssertions(value={@SpecAssertion(section="request_context_ee", id="ga"), @SpecAssertion(section="request_context_ee", id="ha")})
    public void testRequestScopeActiveDuringRemoteCallToEjb() throws Exception {
        Assert.assertNotNull((Object)this.foo.ping());
        Assert.assertTrue((boolean)this.foo.wasRequestBeanInPreviousCallDestroyed());
    }

    @OperateOnDeployment(value="TEST")
    @Test(groups={"javaee-full"})
    @SpecAssertions(value={@SpecAssertion(section="request_context_ee", id="gb"), @SpecAssertion(section="request_context_ee", id="hb")})
    public void testRequestScopeActiveDuringAsyncCallToEjb() throws Exception {
        SimpleRequestBean simpleRequestBean = this.getContextualReference(SimpleRequestBean.class, new Annotation[0]);
        SimpleRequestBean.reset();
        Future<String> result = this.bar.compute();
        String id = result.get();
        Assert.assertNotNull((Object)id);
        Assert.assertNotEquals((Object)id, (Object)simpleRequestBean.getId());
        Assert.assertTrue((boolean)SimpleRequestBean.isBeanDestroyed());
    }
}

