/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.session;

import java.io.IOException;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import org.jboss.cdi.tck.tests.context.session.SimpleSessionBean;
import org.jboss.cdi.tck.util.SimpleLogger;

@WebFilter(filterName="FilterTest", displayName="Test Filter for Sessions", urlPatterns={"/SimplePage.html"})
public class TestFilter
implements Filter {
    private static final SimpleLogger logger = new SimpleLogger(TestFilter.class);
    @Inject
    private BeanManager beanManager;
    @Inject
    private SimpleSessionBean simpleBean;

    public void destroy() {
        this.beanManager = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        logger.log("Do filter...", new Object[0]);
        this.checkSessionContextActive();
        chain.doFilter(request, response);
        this.checkSessionContextActive();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    private void checkSessionContextActive() throws ServletException {
        if (this.beanManager == null || !this.beanManager.getContext(SessionScoped.class).isActive() || this.simpleBean == null) {
            throw new ServletException("Session context is not active");
        }
        this.simpleBean.getId();
    }
}

