/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.context.enterprise.staticMethod;

import javax.annotation.security.DeclareRoles;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBContext;
import javax.ejb.Stateless;
import javax.enterprise.event.Observes;
import javax.enterprise.event.TransactionPhase;
import javax.naming.InitialContext;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.cdi.tck.tests.event.observer.context.enterprise.staticMethod.Foo;
import org.jboss.cdi.tck.tests.event.observer.context.enterprise.staticMethod.Printer;
import org.jboss.cdi.tck.tests.event.observer.context.enterprise.staticMethod.Toner;
import org.jboss.cdi.tck.util.ActionSequence;
import org.testng.Assert;

@Stateless
@DeclareRoles(value={"student", "printer"})
public class FooObserver {
    private static TransactionSynchronizationRegistry tsr;
    private static EJBContext ejbContext;
    private static Toner toner;
    private static Printer printer;

    public static void observeInProgress(@Observes(during=TransactionPhase.IN_PROGRESS) Foo foo) throws Exception {
        if (tsr == null) {
            FooObserver.init();
        }
        Assert.assertEquals((Object)tsr.getTransactionKey(), (Object)Printer.getKey(), (String)"Non-transactional observer method was NOT called in the same transaction context as the invocation of Event.fire()");
        FooObserver.assertClientSecurityContext(TransactionPhase.IN_PROGRESS);
    }

    private static void init() throws Exception {
        tsr = (TransactionSynchronizationRegistry)InitialContext.doLookup("java:comp/TransactionSynchronizationRegistry");
        ejbContext = (EJBContext)InitialContext.doLookup("java:comp/EJBContext");
        toner = (Toner)InitialContext.doLookup("java:module/Toner");
        printer = (Printer)InitialContext.doLookup("java:module/Printer");
    }

    public static void observeBeforeCompletion(@Observes(during=TransactionPhase.BEFORE_COMPLETION) Foo foo) throws Exception {
        Assert.assertEquals((Object)tsr.getTransactionKey(), (Object)Printer.getKey(), (String)"Before completion transactional observer method was NOT called within the context of the transaction that was about to complete.");
        FooObserver.assertClientSecurityContext(TransactionPhase.BEFORE_COMPLETION);
    }

    public static void observeAfterCompletion(@Observes(during=TransactionPhase.AFTER_COMPLETION) Foo foo) throws Exception {
        FooObserver.assertClientSecurityContext(TransactionPhase.AFTER_COMPLETION);
    }

    public static void observeAfterFailure(@Observes(during=TransactionPhase.AFTER_FAILURE) Foo foo) throws Exception {
        FooObserver.assertClientSecurityContext(TransactionPhase.AFTER_FAILURE);
    }

    public static void observeAfterSuccess(@Observes(during=TransactionPhase.AFTER_SUCCESS) Foo foo) throws Exception {
        FooObserver.assertClientSecurityContext(TransactionPhase.AFTER_SUCCESS);
    }

    private static void assertClientSecurityContext(TransactionPhase phase) {
        Assert.assertTrue((boolean)ejbContext.isCallerInRole("student"));
        Assert.assertTrue((!ejbContext.isCallerInRole("printer") ? 1 : 0) != 0);
        toner.spill();
        try {
            printer.tryAccess();
            Assert.fail((String)"Transactional observer method was NOT called within the same client security context.");
        }
        catch (EJBAccessException eJBAccessException) {
            // empty catch block
        }
        ActionSequence.addAction(phase.toString());
    }
}

