/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.priority.transactional;

import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import javax.transaction.UserTransaction;
import org.jboss.cdi.tck.tests.event.observer.priority.transactional.TxFailure;
import org.jboss.cdi.tck.tests.event.observer.priority.transactional.TxWithdrawal;
import org.jboss.cdi.tck.util.ActionSequence;

@Named
@Stateless
@TransactionManagement(value=TransactionManagementType.BEAN)
public class OnlineAccountService {
    @Resource
    private UserTransaction userTransaction;
    @Inject
    Event<TxWithdrawal> event;
    @Inject
    Event<TxFailure> eventFailure;

    public void withdrawSuccesTransaction(int amount) throws Exception {
        this.userTransaction.begin();
        this.event.fire((Object)new TxWithdrawal(amount));
        ActionSequence.addAction("checkpoint");
        this.userTransaction.commit();
    }

    public void withdrawFailedTransaction(int amount) throws Exception {
        this.userTransaction.begin();
        this.event.fire((Object)new TxWithdrawal(amount));
        ActionSequence.addAction("checkpoint");
        this.userTransaction.rollback();
    }

    public void withdrawNoTransaction(int amount) throws Exception {
        this.event.fire((Object)new TxWithdrawal(amount));
        ActionSequence.addAction("checkpoint");
    }

    public void withdrawObserverFailedTransaction(int amount) throws Exception {
        this.userTransaction.begin();
        this.event.fire((Object)new TxWithdrawal(amount));
        this.eventFailure.fire((Object)new TxFailure());
        ActionSequence.addAction("checkpoint");
        if (this.userTransaction.getStatus() == 1) {
            this.userTransaction.rollback();
        } else {
            this.userTransaction.commit();
        }
    }
}

