/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.se.context.activation.programmatic;

import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.control.RequestContextController;
import javax.enterprise.inject.se.SeContainer;
import javax.enterprise.inject.se.SeContainerInitializer;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.arquillian.container.se.api.ClassPath;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.cdi.tck.tests.se.context.activation.programmatic.RequestScopeCounter;
import org.jboss.cdi.tck.tests.se.context.activation.programmatic.TestContextActivator;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"se"})
@SpecVersion(spec="cdi", version="2.0")
public class ActivateRequestContextProgrammaticallyTest
extends Arquillian {
    @Deployment
    public static Archive<?> deployment() throws IOException {
        JavaArchive bda1 = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addPackage(ActivateRequestContextProgrammaticallyTest.class.getPackage())).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return ClassPath.builder().add(bda1).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="activating_request_context", id="a"), @SpecAssertion(section="activating_request_context", id="c"), @SpecAssertion(section="activating_request_context", id="da"), @SpecAssertion(section="activating_request_context", id="e")})
    public void programmaticRequestContextActivation() {
        SeContainerInitializer seContainerInitializer = SeContainerInitializer.newInstance();
        try (SeContainer container = seContainerInitializer.initialize();){
            TestContextActivator contextActivator = (TestContextActivator)container.select(TestContextActivator.class, new Annotation[0]).get();
            boolean activated = contextActivator.activate();
            Assert.assertTrue((boolean)activated);
            Assert.assertFalse((boolean)contextActivator.activate());
            contextActivator.callRequestScopeBean();
            RequestScopeCounter counter = (RequestScopeCounter)container.select(RequestScopeCounter.class, new Annotation[0]).get();
            Assert.assertEquals((int)contextActivator.callRequestScopeBean(), (int)2);
            contextActivator.deactivate();
            contextActivator.activate();
            BeanManager beanManager = container.getBeanManager();
            Assert.assertTrue((boolean)beanManager.getContext(RequestScoped.class).isActive());
            Assert.assertEquals((int)contextActivator.callRequestScopeBean(), (int)1);
            contextActivator.deactivate();
            try {
                beanManager.getContext(RequestScoped.class).isActive();
                Assert.fail((String)(ContextNotActiveException.class.getSimpleName() + " was not thrown !"));
            }
            catch (ContextNotActiveException contextNotActiveException) {
                // empty catch block
            }
        }
    }

    @Test
    @SpecAssertion(section="activating_request_context", id="b")
    public void requestControllerBuiltInBeanAvailable() {
        SeContainerInitializer seContainerInitializer = SeContainerInitializer.newInstance();
        try (SeContainer container = seContainerInitializer.initialize();){
            BeanManager beanManager = container.getBeanManager();
            Bean requestControllerBean = beanManager.resolve(beanManager.getBeans(RequestContextController.class, new Annotation[0]));
            Assert.assertEquals(Dependent.class, (Object)requestControllerBean.getScope());
        }
    }

    @Test
    @SpecAssertion(section="activating_request_context", id="dc")
    public void requestControllerDeactivatedThrowsException() {
        SeContainerInitializer seContainerInitializer = SeContainerInitializer.newInstance();
        try (SeContainer container = seContainerInitializer.initialize();){
            TestContextActivator contextActivator = (TestContextActivator)container.select(TestContextActivator.class, new Annotation[0]).get();
            try {
                contextActivator.deactivate();
                Assert.fail((String)(ContextNotActiveException.class.getSimpleName() + " was not thrown !"));
            }
            catch (ContextNotActiveException contextNotActiveException) {
                // empty catch block
            }
        }
    }
}

