/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.framework;

import ee.jakarta.tck.concurrent.framework.TestLogger;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class TestServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final TestLogger log = TestLogger.get(TestServlet.class);
    private boolean runBeforeClass = true;
    public static final String SUCCESS = "SUCCESS";
    public static final String FAILURE = "FAILURE";
    public static final String TEST_METHOD = "testMethod";

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String method = request.getParameter(TEST_METHOD);
        log.enter(method, "Request URL: " + request.getRequestURL() + "?" + request.getQueryString());
        if (this.runBeforeClass) {
            try {
                this.beforeClass();
                this.runBeforeClass = false;
            }
            catch (Exception e) {
                throw new RuntimeException("Caught exception trying to run beforeClass method.", e);
            }
        }
        PrintWriter writer = response.getWriter();
        if (method != null && method.length() > 0) {
            try {
                this.before();
                try {
                    Method mthd = ((Object)((Object)this)).getClass().getMethod(method, HttpServletRequest.class, HttpServletResponse.class);
                    mthd.invoke((Object)this, request, response);
                }
                catch (NoSuchMethodException nsme) {
                    try {
                        Method mthd = ((Object)((Object)this)).getClass().getMethod(method, null);
                        mthd.invoke((Object)this, new Object[0]);
                    }
                    catch (NoSuchMethodException nsme1) {
                        log.config("Delegating to invokeTest method");
                        this.invokeTest(method, request, response);
                    }
                }
                finally {
                    this.after();
                }
                writer.println(SUCCESS);
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    t = t.getCause();
                }
                writer.println(FAILURE);
                String message = "Caught exception attempting to call test method " + method + " on servlet " + ((Object)((Object)this)).getClass().getName();
                log.warning(message, t);
                writer.println(message);
                t.printStackTrace(writer);
            }
        } else {
            log.warning("ERROR: expected testMethod parameter");
            writer.println("ERROR: expected testMethod parameter");
        }
        writer.flush();
        writer.close();
        log.exit(method, new Object[0]);
    }

    protected void beforeClass() throws Exception {
    }

    protected void before() throws Exception {
    }

    protected void after() throws Exception {
    }

    protected void invokeTest(String method, HttpServletRequest request, HttpServletResponse response) throws Exception {
        throw new NoSuchMethodException("No such method '" + method + "' found on class " + ((Object)((Object)this)).getClass() + " with any of the following signatures:   " + method + "(HttpServletRequest, HttpServletResponse)   " + method + "()");
    }
}

