/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.tx;

import ee.jakarta.tck.concurrent.framework.TestLogger;
import ee.jakarta.tck.concurrent.framework.TestUtil;
import ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.tx.Util;
import jakarta.transaction.UserTransaction;
import java.sql.Connection;
import java.sql.Statement;
import org.testng.Assert;

public class TransactedTask
implements Runnable {
    private static final TestLogger log = TestLogger.get(TransactedTask.class);
    private final boolean isCommit;
    private final String username;
    private final String password;
    private final String sqlTemplate;

    public TransactedTask(boolean commitOrRollback, String username, String password, String sqlTemplate) {
        this.username = username;
        this.password = password;
        this.sqlTemplate = sqlTemplate;
        this.isCommit = commitOrRollback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean pass = false;
        String tableName = "concurrencetable";
        int originCount = Util.getCount(tableName, this.username, this.password);
        UserTransaction ut = (UserTransaction)TestUtil.lookup("java:comp/UserTransaction");
        Assert.assertNotNull((Object)ut, (String)"didn't get user transaction inside the submitted task.");
        Connection conn = Util.getConnection(false, this.username, this.password);
        Statement pStmt = null;
        try {
            ut.begin();
            pStmt = conn.prepareStatement(this.sqlTemplate);
            String sTypeDesc = "Type-99";
            int newType = 99;
            pStmt.setInt(1, newType);
            pStmt.setString(2, sTypeDesc);
            pStmt.executeUpdate();
            if (this.isCommit) {
                ut.commit();
            } else {
                ut.rollback();
            }
            int afterTransacted = Util.getCount(tableName, this.username, this.password);
            pass = this.isCommit ? afterTransacted == originCount + 1 : afterTransacted == originCount;
        }
        catch (Exception e) {
            try {
                ut.rollback();
            }
            catch (Exception e1) {
                log.finer("Got exception when trying to do rollback on failed test", e1);
            }
            Assert.fail((String)"Got exception when trying to run TransactedTask");
        }
        finally {
            try {
                pStmt.close();
                conn.close();
            }
            catch (Exception e) {
                log.finer("Got exception when trying to close connection and statment", e);
            }
        }
        Assert.assertTrue((boolean)pass, (String)"didn't get expected result with transacted task.");
    }
}

