/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.api.Trigger;

import ee.jakarta.tck.concurrent.common.fixed.counter.CounterRunnableTask;
import ee.jakarta.tck.concurrent.common.fixed.counter.StaticCounter;
import ee.jakarta.tck.concurrent.common.tasks.CommonTasks;
import ee.jakarta.tck.concurrent.common.tasks.CommonTriggers;
import ee.jakarta.tck.concurrent.framework.TestConstants;
import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.Common;
import ee.jakarta.tck.concurrent.framework.junit.anno.Web;
import ee.jakarta.tck.concurrent.framework.junit.extensions.Assertions;
import ee.jakarta.tck.concurrent.framework.junit.extensions.Wait;
import jakarta.annotation.Resource;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import jakarta.enterprise.concurrent.SkippedException;
import jakarta.enterprise.concurrent.Trigger;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.BeforeEach;

@Web
@Common(value={Common.PACKAGE.FIXED_COUNTER, Common.PACKAGE.TASKS})
public class TriggerTests {
    @Resource(lookup="java:comp/DefaultManagedScheduledExecutorService")
    private ManagedScheduledExecutorService scheduledExecutor;

    @Deployment(name="TriggerTests")
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addPackages(true, new Package[]{TriggerTests.class.getPackage()});
    }

    @BeforeEach
    public void reset() {
        StaticCounter.reset();
    }

    @Assertion(id="JAVADOC:46", strategy="Retrieve the next time that the task should run after.")
    public void triggerGetNextRunTimeTest() throws Exception {
        ScheduledFuture result = this.scheduledExecutor.schedule((Runnable)new CounterRunnableTask(), (Trigger)new CommonTriggers.TriggerFixedRate(new Date(), TestConstants.pollInterval.toMillis()));
        int rangeOffset = StaticCounter.getCount() == 0 ? 2 : 3;
        try {
            Wait.sleep(TestConstants.waitTimeout);
            Assertions.assertBetween(StaticCounter.getCount(), TestConstants.pollsPerTimeout - rangeOffset, TestConstants.pollsPerTimeout + rangeOffset);
        }
        finally {
            Wait.waitForTaskComplete(result);
        }
    }

    @Assertion(id="JAVADOC:47", strategy="Return true if this run instance should be skipped. This is useful if the task shouldn't run because it is late or if the task is paused or suspended. Once this task is skipped, the state of it's Future's result will throw a SkippedException. Unchecked exceptions will be wrapped in a SkippedException.")
    public void triggerSkipRunTest() {
        ScheduledFuture sf = this.scheduledExecutor.schedule((Callable)new CommonTasks.SimpleCallable(), (Trigger)new CommonTriggers.OnceTriggerDelaySkip(TestConstants.pollInterval));
        try {
            Wait.waitTillFutureThrowsException(sf, SkippedException.class);
        }
        finally {
            sf.cancel(true);
        }
    }
}

