/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.inheritedapi;

import ee.jakarta.tck.concurrent.common.fixed.counter.CounterRunnableTask;
import ee.jakarta.tck.concurrent.common.fixed.counter.StaticCounter;
import ee.jakarta.tck.concurrent.common.tasks.CommonTasks;
import ee.jakarta.tck.concurrent.framework.TestConstants;
import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.Common;
import ee.jakarta.tck.concurrent.framework.junit.anno.Web;
import ee.jakarta.tck.concurrent.framework.junit.extensions.Wait;
import jakarta.annotation.Resource;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

@Web
@Common(value={Common.PACKAGE.TASKS, Common.PACKAGE.FIXED_COUNTER})
public class InheritedAPIServletTests {
    @Resource(lookup="java:comp/DefaultManagedScheduledExecutorService")
    private ManagedScheduledExecutorService scheduledExecutor;

    @Deployment(name="InheritedAPIServletTests")
    public static WebArchive createDeployment() {
        return (WebArchive)ShrinkWrap.create(WebArchive.class);
    }

    @BeforeEach
    public void before() {
        StaticCounter.reset();
    }

    @Assertion(id="SPEC:44.1", strategy="Test basic function for ManagedScheduledExecutorService: submit")
    public void testApiSubmit() throws Exception {
        Future result = this.scheduledExecutor.submit((Callable)new CommonTasks.SimpleCallable());
        Assertions.assertEquals(Wait.waitForTaskComplete(result), (Object)"ok");
        result = this.scheduledExecutor.submit((Runnable)new CommonTasks.SimpleRunnable());
        Wait.waitForTaskComplete(result);
        result = this.scheduledExecutor.submit((Runnable)new CommonTasks.SimpleRunnable(), (Object)"ok");
        Assertions.assertEquals(Wait.waitForTaskComplete(result), (Object)"ok");
    }

    @Assertion(id="SPEC:44.2", strategy="Test basic function for ManagedScheduledExecutorService: execute")
    public void testApiExecute() {
        try {
            this.scheduledExecutor.execute((Runnable)new CounterRunnableTask());
            StaticCounter.waitTill(1);
        }
        finally {
            StaticCounter.reset();
        }
    }

    @Assertion(id="SPEC:44.3", strategy="Test basic function for ManagedScheduledExecutorService: invokeAll")
    public void testApiInvokeAll() throws Exception {
        List resultList;
        ArrayList<Callable<Integer>> taskList;
        try {
            taskList = new ArrayList<Callable<Integer>>();
            taskList.add(new CommonTasks.SimpleArgCallable(1));
            taskList.add(new CommonTasks.SimpleArgCallable(2));
            taskList.add(new CommonTasks.SimpleArgCallable(3));
            resultList = this.scheduledExecutor.invokeAll(taskList);
            for (Future each : resultList) {
                Wait.waitForTaskComplete(each);
            }
            Assertions.assertEquals((Integer)((Integer)((Future)resultList.get(0)).get()), (int)1);
            Assertions.assertEquals((Integer)((Integer)((Future)resultList.get(1)).get()), (int)2);
            Assertions.assertEquals((Integer)((Integer)((Future)resultList.get(2)).get()), (int)3);
            resultList = this.scheduledExecutor.invokeAll(taskList, TestConstants.waitTimeout.getSeconds(), TimeUnit.SECONDS);
            for (Future each : resultList) {
                Wait.waitForTaskComplete(each);
            }
            Assertions.assertEquals((Integer)((Integer)((Future)resultList.get(0)).get()), (int)1);
            Assertions.assertEquals((Integer)((Integer)((Future)resultList.get(1)).get()), (int)2);
            Assertions.assertEquals((Integer)((Integer)((Future)resultList.get(2)).get()), (int)3);
        }
        catch (Exception ex) {
            Assertions.fail((String)ex.getMessage());
        }
        try {
            taskList = new ArrayList();
            taskList.add(new CommonTasks.SimpleCallable(TestConstants.waitTimeout));
            taskList.add(new CommonTasks.SimpleCallable(TestConstants.waitTimeout));
            resultList = this.scheduledExecutor.invokeAll(taskList, TestConstants.pollInterval.getSeconds(), TimeUnit.SECONDS);
            for (Future each : resultList) {
                Wait.waitTillFutureThrowsException(each, CancellationException.class);
            }
        }
        catch (Exception ex) {
            Assertions.fail((String)ex.getMessage());
        }
    }

    @Assertion(id="SPEC:44.4", strategy="Test basic function for ManagedScheduledExecutorService: invokeAny")
    public void testApiInvokeAny() throws Exception {
        ArrayList<CommonTasks.SimpleArgCallable> taskList = new ArrayList<CommonTasks.SimpleArgCallable>();
        taskList.add(new CommonTasks.SimpleArgCallable(1));
        taskList.add(new CommonTasks.SimpleArgCallable(2));
        taskList.add(new CommonTasks.SimpleArgCallable(3));
        Integer result = (Integer)this.scheduledExecutor.invokeAny(taskList);
        ee.jakarta.tck.concurrent.framework.junit.extensions.Assertions.assertBetween(result, 1, 3);
        result = (Integer)this.scheduledExecutor.invokeAny(taskList, TestConstants.waitTimeout.getSeconds(), TimeUnit.SECONDS);
        ee.jakarta.tck.concurrent.framework.junit.extensions.Assertions.assertBetween(result, 1, 3);
        Assertions.assertThrows(TimeoutException.class, () -> {
            ArrayList<CommonTasks.SimpleCallable> taskList2 = new ArrayList<CommonTasks.SimpleCallable>();
            taskList2.add(new CommonTasks.SimpleCallable(TestConstants.waitTimeout));
            taskList2.add(new CommonTasks.SimpleCallable(TestConstants.waitTimeout));
            this.scheduledExecutor.invokeAny(taskList2, TestConstants.pollInterval.getSeconds(), TimeUnit.SECONDS);
        });
    }

    @Assertion(id="SPEC:44.5", strategy="Test basic function for ManagedScheduledExecutorService: schedule")
    public void testApiSchedule() throws Exception {
        ScheduledFuture result = this.scheduledExecutor.schedule((Callable)new CommonTasks.SimpleCallable(), TestConstants.pollInterval.getSeconds(), TimeUnit.SECONDS);
        Assertions.assertEquals(Wait.waitForTaskComplete(result), (Object)"ok");
        result = this.scheduledExecutor.schedule((Runnable)new CommonTasks.SimpleRunnable(), TestConstants.pollInterval.getSeconds(), TimeUnit.SECONDS);
        Assertions.assertEquals(Wait.waitForTaskComplete(result), null);
    }

    @Assertion(id="SPEC:44.6", strategy="Test basic function for ManagedScheduledExecutorService: scheduleAtFixedRate")
    public void testApiScheduleAtFixedRate() {
        ScheduledFuture result = null;
        try {
            result = this.scheduledExecutor.scheduleAtFixedRate((Runnable)new CounterRunnableTask(), TestConstants.pollInterval.getSeconds(), TestConstants.pollInterval.getSeconds(), TimeUnit.SECONDS);
            Wait.sleep(TestConstants.waitTimeout);
            ee.jakarta.tck.concurrent.framework.junit.extensions.Assertions.assertBetween(StaticCounter.getCount(), TestConstants.pollsPerTimeout - 2, TestConstants.pollsPerTimeout + 2);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
        finally {
            if (result != null) {
                Wait.waitCancelFuture(result);
            }
        }
    }

    @Assertion(id="SPEC:44.7", strategy="Test basic function for ManagedScheduledExecutorService: scheduleWithFixedDelay")
    public void testApiScheduleWithFixedDelay() {
        ScheduledFuture result = null;
        try {
            result = this.scheduledExecutor.scheduleWithFixedDelay((Runnable)new CounterRunnableTask(TestConstants.pollInterval), TestConstants.pollInterval.getSeconds(), TestConstants.pollInterval.getSeconds(), TimeUnit.SECONDS);
            Wait.sleep(TestConstants.waitTimeout);
            ee.jakarta.tck.concurrent.framework.junit.extensions.Assertions.assertBetween(StaticCounter.getCount(), TestConstants.pollsPerTimeout / 2 - 2, TestConstants.pollsPerTimeout / 2 + 2);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
        finally {
            if (result != null) {
                Wait.waitCancelFuture(result);
            }
        }
    }
}

