/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.framework.junit.extensions;

import java.util.Iterator;

public final class Assertions {
    private Assertions() {
    }

    public static void assertWithin(int expected, int lowerBound, int upperBound) {
        if (lowerBound < expected && upperBound > expected) {
            return;
        }
        String message = "Expected " + expected + " to be within the range ( " + lowerBound + ", " + upperBound + " )";
        throw new AssertionError((Object)message);
    }

    public static void assertBetween(int expected, int lowerBound, int upperBound) {
        if (lowerBound <= expected && upperBound >= expected) {
            return;
        }
        String message = "Expected " + expected + " to be within the range [ " + lowerBound + ", " + upperBound + " ]";
        throw new AssertionError((Object)message);
    }

    public static void assertRangeContains(Object expected, Iterable<Object> range) {
        Iterator<Object> it = range.iterator();
        while (it.hasNext()) {
            if (!it.equals(expected)) continue;
            return;
        }
        String message = "Expected " + expected + " to be within the range " + range.toString();
        throw new AssertionError((Object)message);
    }
}

