/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.api;

import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.module.single.StaticModulesRegistry;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="globals")
@Singleton
public class Globals {
    private static volatile ServiceLocator defaultServiceLocator;
    private static Object staticLock;
    @Inject
    private ConfigBeansUtilities utilities;

    @Inject
    private Globals(ServiceLocator serviceLocator) {
        defaultServiceLocator = serviceLocator;
    }

    public static ServiceLocator getDefaultBaseServiceLocator() {
        return Globals.getDefaultHabitat();
    }

    public static ServiceLocator getDefaultHabitat() {
        return defaultServiceLocator;
    }

    public static <T> T get(Class<T> type2) {
        return (T)defaultServiceLocator.getService(type2, new Annotation[0]);
    }

    public static void setDefaultHabitat(ServiceLocator habitat) {
        defaultServiceLocator = habitat;
    }

    public static ServiceLocator getStaticBaseServiceLocator() {
        return Globals.getStaticHabitat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceLocator getStaticHabitat() {
        if (defaultServiceLocator == null) {
            Object object = staticLock;
            synchronized (object) {
                if (defaultServiceLocator == null) {
                    StaticModulesRegistry modulesRegistry = new StaticModulesRegistry(Globals.class.getClassLoader());
                    defaultServiceLocator = modulesRegistry.createServiceLocator("default");
                }
            }
        }
        return defaultServiceLocator;
    }

    static {
        staticLock = new Object();
    }

    @Service
    @RunLevel(value=0, mode=0)
    public static class GlobalsInitializer {
        @Inject
        private Globals globals;
    }
}

