/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.TimeZone;
import java.util.Vector;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.catalina.servlets.DefaultServlet;
import org.apache.catalina.servlets.WebdavStatus;
import org.apache.catalina.util.DOMWriter;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.XMLWriter;
import org.apache.naming.resources.CacheEntry;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;
import org.glassfish.grizzly.http.util.FastHttpDateFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebdavServlet
extends DefaultServlet {
    private static final String METHOD_HEAD = "HEAD";
    private static final String METHOD_PROPFIND = "PROPFIND";
    private static final String METHOD_PROPPATCH = "PROPPATCH";
    private static final String METHOD_MKCOL = "MKCOL";
    private static final String METHOD_COPY = "COPY";
    private static final String METHOD_MOVE = "MOVE";
    private static final String METHOD_LOCK = "LOCK";
    private static final String METHOD_UNLOCK = "UNLOCK";
    private static final int INFINITY = 3;
    private static final int FIND_BY_PROPERTY = 0;
    private static final int FIND_ALL_PROP = 1;
    private static final int FIND_PROPERTY_NAMES = 2;
    private static final int LOCK_CREATION = 0;
    private static final int LOCK_REFRESH = 1;
    private static final int DEFAULT_TIMEOUT = 3600;
    private static final int MAX_TIMEOUT = 604800;
    protected static final String DEFAULT_NAMESPACE = "DAV:";
    private static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    protected static final ThreadLocal<SimpleDateFormat> creationDateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            f.setTimeZone(GMT_TIME_ZONE);
            return f;
        }
    };
    protected static final MessageDigest sha256Helper;
    private Hashtable<String, LockInfo> resourceLocks = new Hashtable();
    private Hashtable<String, Vector<String>> lockNullResources = new Hashtable();
    private Vector<LockInfo> collectionLocks = new Vector();
    private String secret = "catalina";

    @Override
    public void init() throws ServletException {
        super.init();
        if (this.getServletConfig().getInitParameter("secret") != null) {
            this.secret = this.getServletConfig().getInitParameter("secret");
        }
    }

    protected DocumentBuilder getDocumentBuilder() throws ServletException {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = null;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            documentBuilderFactory.setValidating(true);
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setExpandEntityReferences(false);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new WebdavResolver(this.getServletContext()));
        }
        catch (ParserConfigurationException e) {
            throw new ServletException(rb.getString("AS-WEB-CORE-00335"));
        }
        return documentBuilder;
    }

    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = req.getMethod();
        if (this.debug > 0) {
            String path = this.getRelativePath(req);
            this.log("[" + method + "] " + path);
        }
        if (method.equals(METHOD_PROPFIND)) {
            this.doPropfind(req, resp);
        } else if (method.equals(METHOD_PROPPATCH)) {
            this.doProppatch(req, resp);
        } else if (method.equals(METHOD_MKCOL)) {
            this.doMkcol(req, resp);
        } else if (method.equals(METHOD_COPY)) {
            this.doCopy(req, resp);
        } else if (method.equals(METHOD_MOVE)) {
            this.doMove(req, resp);
        } else if (method.equals(METHOD_LOCK)) {
            this.doLock(req, resp);
        } else if (method.equals(METHOD_UNLOCK)) {
            this.doUnlock(req, resp);
        } else {
            super.service(req, resp);
        }
    }

    @Override
    protected boolean checkIfHeaders(HttpServletRequest request, HttpServletResponse response, ResourceAttributes resourceAttributes) throws IOException {
        return super.checkIfHeaders(request, response, resourceAttributes);
    }

    @Override
    protected String getRelativePath(HttpServletRequest request) {
        if (request.getAttribute("jakarta.servlet.include.request_uri") != null) {
            String result = (String)request.getAttribute("jakarta.servlet.include.path_info");
            if (result == null || "".equals(result)) {
                result = "/";
            }
            return result;
        }
        String result = request.getPathInfo();
        if (result == null || "".equals(result)) {
            result = "/";
        }
        return result;
    }

    @Override
    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.addHeader("DAV", "1,2");
        StringBuilder methodsAllowed = this.determineMethodsAllowed((DirContext)this.resources, req);
        resp.addHeader("Allow", methodsAllowed.toString());
        resp.addHeader("MS-Author-Via", "DAV");
    }

    protected void doPropfind(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Object object;
        boolean exists;
        int type;
        int depth;
        Vector<String> properties;
        String path;
        block45: {
            if (!this.listings) {
                StringBuilder methodsAllowed = this.determineMethodsAllowed((DirContext)this.resources, req);
                resp.addHeader("Allow", methodsAllowed.toString());
                resp.sendError(405);
                return;
            }
            path = this.getRelativePath(req);
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.toUpperCase(Locale.ENGLISH).startsWith("/WEB-INF") || path.toUpperCase(Locale.ENGLISH).startsWith("/META-INF")) {
                resp.sendError(403);
                return;
            }
            properties = null;
            depth = 3;
            type = 1;
            String depthStr = req.getHeader("Depth");
            if (depthStr == null) {
                depth = 3;
            } else if ("0".equals(depthStr)) {
                depth = 0;
            } else if ("1".equals(depthStr)) {
                depth = 1;
            } else if ("infinity".equals(depthStr)) {
                depth = 3;
            }
            Node propNode = null;
            if (req.getInputStream().available() > 0) {
                DocumentBuilder documentBuilder = this.getDocumentBuilder();
                try {
                    Document document = documentBuilder.parse(new InputSource(req.getInputStream()));
                    Element rootElement = document.getDocumentElement();
                    NodeList childList = rootElement.getChildNodes();
                    block17: for (int i = 0; i < childList.getLength(); ++i) {
                        Node currentNode = childList.item(i);
                        switch (currentNode.getNodeType()) {
                            case 3: {
                                continue block17;
                            }
                            case 1: {
                                if (currentNode.getNodeName().endsWith("prop")) {
                                    type = 0;
                                    propNode = currentNode;
                                }
                                if (currentNode.getNodeName().endsWith("propname")) {
                                    type = 2;
                                }
                                if (!currentNode.getNodeName().endsWith("allprop")) continue block17;
                                type = 1;
                                continue block17;
                            }
                        }
                    }
                }
                catch (SAXException document) {
                }
                catch (IOException document) {
                    // empty catch block
                }
            }
            if (type == 0) {
                properties = new Vector<String>();
                NodeList childList = propNode.getChildNodes();
                block18: for (int i = 0; i < childList.getLength(); ++i) {
                    Node currentNode = childList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            continue block18;
                        }
                        case 1: {
                            String nodeName = currentNode.getNodeName();
                            String propertyName = null;
                            propertyName = nodeName.indexOf(58) != -1 ? nodeName.substring(nodeName.indexOf(58) + 1) : nodeName;
                            properties.addElement(propertyName);
                            continue block18;
                        }
                    }
                }
            }
            exists = true;
            object = null;
            try {
                object = this.resources.lookup(path);
            }
            catch (NamingException e) {
                String parentPath;
                Vector<String> currentLockNullResources;
                exists = false;
                int slash = path.lastIndexOf(47);
                if (slash == -1 || (currentLockNullResources = this.lockNullResources.get(parentPath = path.substring(0, slash))) == null) break block45;
                Enumeration<String> lockNullResourcesList = currentLockNullResources.elements();
                while (lockNullResourcesList.hasMoreElements()) {
                    String lockNullPath = lockNullResourcesList.nextElement();
                    if (!lockNullPath.equals(path)) continue;
                    resp.setStatus(207);
                    resp.setContentType("text/xml; charset=UTF-8");
                    XMLWriter generatedXML = new XMLWriter(resp.getWriter());
                    generatedXML.writeXMLHeader();
                    generatedXML.writeElement(null, "multistatus" + this.generateNamespaceDeclarations(), 0);
                    this.parseLockNullProperties(req, generatedXML, lockNullPath, type, properties);
                    generatedXML.writeElement(null, "multistatus", 1);
                    generatedXML.sendData();
                    return;
                }
            }
        }
        if (!exists) {
            resp.sendError(404, path);
            return;
        }
        resp.setStatus(207);
        resp.setContentType("text/xml; charset=UTF-8");
        XMLWriter generatedXML = new XMLWriter(resp.getWriter());
        generatedXML.writeXMLHeader();
        generatedXML.writeElement(null, "multistatus" + this.generateNamespaceDeclarations(), 0);
        if (depth == 0) {
            this.parseProperties(req, generatedXML, path, type, properties);
        } else {
            Stack<String> stack = new Stack<String>();
            stack.push(path);
            Stack<Object> stackBelow = new Stack<Object>();
            while (!stack.isEmpty() && depth >= 0) {
                String currentPath = (String)stack.pop();
                this.parseProperties(req, generatedXML, currentPath, type, properties);
                try {
                    object = this.resources.lookup(currentPath);
                }
                catch (NamingException e) {
                    continue;
                }
                if (object instanceof DirContext && depth > 0) {
                    Vector<String> currentLockNullResources;
                    try {
                        NamingEnumeration enumeration = this.resources.list(currentPath);
                        while (enumeration.hasMoreElements()) {
                            NameClassPair ncPair = (NameClassPair)enumeration.nextElement();
                            Object newPath = currentPath;
                            if (!((String)newPath).endsWith("/")) {
                                newPath = (String)newPath + "/";
                            }
                            newPath = (String)newPath + ncPair.getName();
                            stackBelow.push(newPath);
                        }
                    }
                    catch (NamingException e) {
                        resp.sendError(500, path);
                        return;
                    }
                    String lockPath = currentPath;
                    if (lockPath.endsWith("/")) {
                        lockPath = lockPath.substring(0, lockPath.length() - 1);
                    }
                    if ((currentLockNullResources = this.lockNullResources.get(lockPath)) != null) {
                        Enumeration<String> lockNullResourcesList = currentLockNullResources.elements();
                        while (lockNullResourcesList.hasMoreElements()) {
                            String lockNullPath = lockNullResourcesList.nextElement();
                            this.parseLockNullProperties(req, generatedXML, lockNullPath, type, properties);
                        }
                    }
                }
                if (stack.isEmpty()) {
                    --depth;
                    stack = stackBelow;
                    stackBelow = new Stack();
                }
                generatedXML.sendData();
            }
        }
        generatedXML.writeElement(null, "multistatus", 1);
        generatedXML.sendData();
    }

    protected void doProppatch(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        resp.sendError(501);
    }

    protected void doMkcol(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        String path = this.getRelativePath(req);
        if (path.toUpperCase(Locale.ENGLISH).startsWith("/WEB-INF") || path.toUpperCase(Locale.ENGLISH).startsWith("/META-INF")) {
            resp.sendError(403);
            return;
        }
        boolean exists = true;
        try {
            this.resources.lookup(path);
        }
        catch (NamingException e) {
            exists = false;
        }
        if (exists) {
            StringBuilder methodsAllowed = this.determineMethodsAllowed((DirContext)this.resources, req);
            resp.addHeader("Allow", methodsAllowed.toString());
            resp.sendError(405);
            return;
        }
        if (req.getInputStream().available() > 0) {
            DocumentBuilder documentBuilder = this.getDocumentBuilder();
            try {
                documentBuilder.parse(new InputSource(req.getInputStream()));
                resp.sendError(501);
                return;
            }
            catch (SAXException saxe) {
                resp.sendError(400);
                return;
            }
        }
        boolean result = true;
        try {
            this.resources.createSubcontext(path);
        }
        catch (NamingException e) {
            result = false;
        }
        if (!result) {
            resp.sendError(409, WebdavStatus.getStatusText(409));
        } else {
            resp.setStatus(201);
            this.lockNullResources.remove(path);
        }
    }

    @Override
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        this.deleteResource(req, resp);
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        super.doPut(req, resp);
        String path = this.getRelativePath(req);
        this.lockNullResources.remove(path);
    }

    protected void doCopy(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        this.copyResource(req, resp);
    }

    protected void doMove(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        String path = this.getRelativePath(req);
        if (this.copyResource(req, resp)) {
            this.deleteResource(path, req, resp, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLock(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path;
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        LockInfo lock = new LockInfo();
        String depthStr = req.getHeader("Depth");
        lock.depth = depthStr == null ? 3 : ("0".equals(depthStr) ? 0 : 3);
        int lockDuration = 3600;
        String lockDurationStr = req.getHeader("Timeout");
        if (lockDurationStr == null) {
            lockDuration = 3600;
        } else {
            int commaPos = lockDurationStr.indexOf(",");
            if (commaPos != -1) {
                lockDurationStr = lockDurationStr.substring(0, commaPos);
            }
            if (lockDurationStr.startsWith("Second-")) {
                lockDuration = Integer.parseInt(lockDurationStr.substring(7));
            } else if ("infinity".equalsIgnoreCase(lockDurationStr)) {
                lockDuration = 604800;
            } else {
                try {
                    lockDuration = Integer.parseInt(lockDurationStr);
                }
                catch (NumberFormatException e) {
                    lockDuration = 604800;
                }
            }
            if (lockDuration == 0) {
                lockDuration = 3600;
            }
            if (lockDuration > 604800) {
                lockDuration = 604800;
            }
        }
        lock.expiresAt = System.currentTimeMillis() + (long)lockDuration * 1000L;
        boolean lockRequestType = false;
        Node lockInfoNode = null;
        DocumentBuilder documentBuilder = this.getDocumentBuilder();
        try {
            Document document = documentBuilder.parse(new InputSource(req.getInputStream()));
            Element rootElement = document.getDocumentElement();
            lockInfoNode = rootElement;
        }
        catch (IOException e) {
            lockRequestType = true;
        }
        catch (SAXException e) {
            lockRequestType = true;
        }
        if (lockInfoNode != null) {
            Node currentNode;
            int i;
            NodeList childList = lockInfoNode.getChildNodes();
            StringWriter strWriter = null;
            DOMWriter domWriter = null;
            Node lockScopeNode = null;
            Node lockTypeNode = null;
            Node lockOwnerNode = null;
            block28: for (i = 0; i < childList.getLength(); ++i) {
                currentNode = childList.item(i);
                switch (currentNode.getNodeType()) {
                    case 3: {
                        continue block28;
                    }
                    case 1: {
                        String nodeName = currentNode.getNodeName();
                        if (nodeName.endsWith("lockscope")) {
                            lockScopeNode = currentNode;
                        }
                        if (nodeName.endsWith("locktype")) {
                            lockTypeNode = currentNode;
                        }
                        if (!nodeName.endsWith("owner")) continue block28;
                        lockOwnerNode = currentNode;
                        continue block28;
                    }
                }
            }
            if (lockScopeNode != null) {
                childList = lockScopeNode.getChildNodes();
                block29: for (i = 0; i < childList.getLength(); ++i) {
                    currentNode = childList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            continue block29;
                        }
                        case 1: {
                            String tempScope = currentNode.getNodeName();
                            if (tempScope.indexOf(58) != -1) {
                                lock.scope = tempScope.substring(tempScope.indexOf(58) + 1);
                                continue block29;
                            }
                            lock.scope = tempScope;
                            continue block29;
                        }
                    }
                }
                if (lock.scope == null) {
                    resp.setStatus(400);
                }
            } else {
                resp.setStatus(400);
            }
            if (lockTypeNode != null) {
                childList = lockTypeNode.getChildNodes();
                block30: for (i = 0; i < childList.getLength(); ++i) {
                    currentNode = childList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            continue block30;
                        }
                        case 1: {
                            String tempType = currentNode.getNodeName();
                            if (tempType.indexOf(58) != -1) {
                                lock.type = tempType.substring(tempType.indexOf(58) + 1);
                                continue block30;
                            }
                            lock.type = tempType;
                            continue block30;
                        }
                    }
                }
                if (lock.type == null) {
                    resp.setStatus(400);
                }
            } else {
                resp.setStatus(400);
            }
            if (lockOwnerNode != null) {
                childList = lockOwnerNode.getChildNodes();
                block31: for (i = 0; i < childList.getLength(); ++i) {
                    currentNode = childList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            lock.owner = lock.owner + currentNode.getNodeValue();
                            continue block31;
                        }
                        case 1: {
                            strWriter = new StringWriter();
                            domWriter = new DOMWriter(strWriter, true);
                            domWriter.setQualifiedNames(false);
                            domWriter.print(currentNode);
                            lock.owner = lock.owner + strWriter.toString();
                            continue block31;
                        }
                    }
                }
                if (lock.owner == null) {
                    resp.setStatus(400);
                }
            } else {
                lock.owner = "";
            }
        }
        lock.path = path = this.getRelativePath(req);
        boolean exists = true;
        Object object = null;
        try {
            object = this.resources.lookup(path);
        }
        catch (NamingException e) {
            exists = false;
        }
        Enumeration<LockInfo> locksList = null;
        if (!lockRequestType) {
            String lockTokenStr = req.getServletPath() + "-" + lock.type + "-" + lock.scope + "-" + String.valueOf(req.getUserPrincipal()) + "-" + lock.depth + "-" + lock.owner + "-" + String.valueOf(lock.tokens) + "-" + lock.expiresAt + "-" + System.currentTimeMillis() + "-" + this.secret;
            byte[] digestBytes = null;
            MessageDigest i = sha256Helper;
            synchronized (i) {
                digestBytes = sha256Helper.digest(lockTokenStr.getBytes(Charset.defaultCharset()));
            }
            String lockToken = new String(digestBytes);
            if (exists && object instanceof DirContext && lock.depth == 3) {
                LockInfo currentLock;
                Vector<String> lockPaths = new Vector<String>();
                locksList = this.collectionLocks.elements();
                while (locksList.hasMoreElements()) {
                    currentLock = locksList.nextElement();
                    if (currentLock.hasExpired()) {
                        this.resourceLocks.remove(currentLock.path);
                        continue;
                    }
                    if (!currentLock.path.startsWith(lock.path) || !currentLock.isExclusive() && !lock.isExclusive()) continue;
                    lockPaths.addElement(currentLock.path);
                }
                locksList = this.resourceLocks.elements();
                while (locksList.hasMoreElements()) {
                    currentLock = locksList.nextElement();
                    if (currentLock.hasExpired()) {
                        this.resourceLocks.remove(currentLock.path);
                        continue;
                    }
                    if (!currentLock.path.startsWith(lock.path) || !currentLock.isExclusive() && !lock.isExclusive()) continue;
                    lockPaths.addElement(currentLock.path);
                }
                if (!lockPaths.isEmpty()) {
                    Enumeration lockPathsList = lockPaths.elements();
                    resp.setStatus(409);
                    XMLWriter generatedXML = new XMLWriter();
                    generatedXML.writeXMLHeader();
                    generatedXML.writeElement(null, "multistatus" + this.generateNamespaceDeclarations(), 0);
                    while (lockPathsList.hasMoreElements()) {
                        generatedXML.writeElement(null, "response", 0);
                        generatedXML.writeElement(null, "href", 0);
                        generatedXML.writeText((String)lockPathsList.nextElement());
                        generatedXML.writeElement(null, "href", 1);
                        generatedXML.writeElement(null, "status", 0);
                        generatedXML.writeText("HTTP/1.1 423 " + WebdavStatus.getStatusText(423));
                        generatedXML.writeElement(null, "status", 1);
                        generatedXML.writeElement(null, "response", 1);
                    }
                    generatedXML.writeElement(null, "multistatus", 1);
                    PrintWriter writer = resp.getWriter();
                    ((Writer)writer).write(generatedXML.toString());
                    ((Writer)writer).close();
                    return;
                }
                boolean addLock = true;
                locksList = this.collectionLocks.elements();
                while (locksList.hasMoreElements()) {
                    LockInfo currentLock2 = locksList.nextElement();
                    if (!currentLock2.path.equals(lock.path)) continue;
                    if (currentLock2.isExclusive()) {
                        resp.sendError(423);
                        return;
                    }
                    if (lock.isExclusive()) {
                        resp.sendError(423);
                        return;
                    }
                    currentLock2.tokens.addElement(lockToken);
                    lock = currentLock2;
                    addLock = false;
                }
                if (addLock) {
                    lock.tokens.addElement(lockToken);
                    this.collectionLocks.addElement(lock);
                }
            } else {
                LockInfo presentLock = this.resourceLocks.get(lock.path);
                if (presentLock != null) {
                    if (presentLock.isExclusive() || lock.isExclusive()) {
                        resp.sendError(412);
                        return;
                    }
                    presentLock.tokens.addElement(lockToken);
                    lock = presentLock;
                } else {
                    lock.tokens.addElement(lockToken);
                    this.resourceLocks.put(lock.path, lock);
                    exists = true;
                    try {
                        object = this.resources.lookup(path);
                    }
                    catch (NamingException e) {
                        exists = false;
                    }
                    if (!exists) {
                        int slash = lock.path.lastIndexOf(47);
                        String parentPath = lock.path.substring(0, slash);
                        Vector<String> lockNulls = this.lockNullResources.get(parentPath);
                        if (lockNulls == null) {
                            lockNulls = new Vector();
                            this.lockNullResources.put(parentPath, lockNulls);
                        }
                        lockNulls.addElement(lock.path);
                    }
                    resp.addHeader("Lock-Token", "<opaquelocktoken:" + lockToken + ">");
                }
            }
        }
        if (lockRequestType) {
            String ifHeader = req.getHeader("If");
            if (ifHeader == null) {
                ifHeader = "";
            }
            LockInfo toRenew = this.resourceLocks.get(path);
            Enumeration<String> tokenList = null;
            if (lock != null) {
                tokenList = toRenew.tokens.elements();
                while (tokenList.hasMoreElements()) {
                    String token = tokenList.nextElement();
                    if (ifHeader.indexOf(token) == -1) continue;
                    toRenew.expiresAt = lock.expiresAt;
                    lock = toRenew;
                }
            }
            Enumeration<LockInfo> collectionLocksList = this.collectionLocks.elements();
            while (collectionLocksList.hasMoreElements()) {
                toRenew = collectionLocksList.nextElement();
                if (!path.equals(toRenew.path)) continue;
                tokenList = toRenew.tokens.elements();
                while (tokenList.hasMoreElements()) {
                    String token = tokenList.nextElement();
                    if (ifHeader.indexOf(token) == -1) continue;
                    toRenew.expiresAt = lock.expiresAt;
                    lock = toRenew;
                }
            }
        }
        XMLWriter generatedXML = new XMLWriter();
        generatedXML.writeXMLHeader();
        generatedXML.writeElement(null, "prop" + this.generateNamespaceDeclarations(), 0);
        generatedXML.writeElement(null, "lockdiscovery", 0);
        lock.toXML(generatedXML);
        generatedXML.writeElement(null, "lockdiscovery", 1);
        generatedXML.writeElement(null, "prop", 1);
        resp.setStatus(200);
        resp.setContentType("text/xml; charset=UTF-8");
        PrintWriter writer = resp.getWriter();
        ((Writer)writer).write(generatedXML.toString());
        ((Writer)writer).close();
    }

    protected void doUnlock(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        String path = this.getRelativePath(req);
        String lockTokenHeader = req.getHeader("Lock-Token");
        if (lockTokenHeader == null) {
            lockTokenHeader = "";
        }
        LockInfo lock = this.resourceLocks.get(path);
        Enumeration<String> tokenList = null;
        if (lock != null) {
            tokenList = lock.tokens.elements();
            while (tokenList.hasMoreElements()) {
                String token = tokenList.nextElement();
                if (lockTokenHeader.indexOf(token) == -1) continue;
                lock.tokens.removeElement(token);
            }
            if (lock.tokens.isEmpty()) {
                this.resourceLocks.remove(path);
                this.lockNullResources.remove(path);
            }
        }
        Enumeration<LockInfo> collectionLocksList = this.collectionLocks.elements();
        while (collectionLocksList.hasMoreElements()) {
            lock = collectionLocksList.nextElement();
            if (!path.equals(lock.path)) continue;
            tokenList = lock.tokens.elements();
            while (tokenList.hasMoreElements()) {
                String token = tokenList.nextElement();
                if (lockTokenHeader.indexOf(token) == -1) continue;
                lock.tokens.removeElement(token);
                break;
            }
            if (!lock.tokens.isEmpty()) continue;
            this.collectionLocks.removeElement(lock);
            this.lockNullResources.remove(path);
        }
        resp.setStatus(204);
    }

    private String generateNamespaceDeclarations() {
        return " xmlns=\"DAV:\"";
    }

    private boolean isLocked(HttpServletRequest req) {
        String lockTokenHeader;
        String path = this.getRelativePath(req);
        String ifHeader = req.getHeader("If");
        if (ifHeader == null) {
            ifHeader = "";
        }
        if ((lockTokenHeader = req.getHeader("Lock-Token")) == null) {
            lockTokenHeader = "";
        }
        return this.isLocked(path, ifHeader + lockTokenHeader);
    }

    private boolean isLocked(String path, String ifHeader) {
        LockInfo lock = this.resourceLocks.get(path);
        Enumeration<String> tokenList = null;
        if (lock != null && lock.hasExpired()) {
            this.resourceLocks.remove(path);
        } else if (lock != null) {
            tokenList = lock.tokens.elements();
            boolean tokenMatch = false;
            while (tokenList.hasMoreElements()) {
                String token = tokenList.nextElement();
                if (ifHeader.indexOf(token) == -1) continue;
                tokenMatch = true;
            }
            if (!tokenMatch) {
                return true;
            }
        }
        Enumeration<LockInfo> collectionLocksList = this.collectionLocks.elements();
        while (collectionLocksList.hasMoreElements()) {
            lock = collectionLocksList.nextElement();
            if (lock.hasExpired()) {
                this.collectionLocks.removeElement(lock);
                continue;
            }
            if (!path.startsWith(lock.path)) continue;
            tokenList = lock.tokens.elements();
            boolean tokenMatch = false;
            while (tokenList.hasMoreElements()) {
                String token = tokenList.nextElement();
                if (ifHeader.indexOf(token) == -1) continue;
                tokenMatch = true;
            }
            if (tokenMatch) continue;
            return true;
        }
        return false;
    }

    private boolean copyResource(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Hashtable<String, Integer> errorList;
        boolean result;
        String servletPath;
        String pathInfo;
        String destinationPath = req.getHeader("Destination");
        if (destinationPath == null) {
            resp.sendError(400);
            return false;
        }
        int protocolIndex = (destinationPath = RequestUtil.urlDecode(destinationPath, "UTF8")).indexOf("://");
        if (protocolIndex >= 0) {
            int firstSeparator = destinationPath.indexOf("/", protocolIndex + 4);
            destinationPath = firstSeparator < 0 ? "/" : destinationPath.substring(firstSeparator);
        } else {
            int portIndex;
            String hostName = req.getServerName();
            if (hostName != null && destinationPath.startsWith(hostName)) {
                destinationPath = destinationPath.substring(hostName.length());
            }
            if ((portIndex = destinationPath.indexOf(":")) >= 0) {
                destinationPath = destinationPath.substring(portIndex);
            }
            if (destinationPath.startsWith(":")) {
                int firstSeparator = destinationPath.indexOf("/");
                destinationPath = firstSeparator < 0 ? "/" : destinationPath.substring(firstSeparator);
            }
        }
        destinationPath = RequestUtil.normalize(destinationPath);
        String contextPath = req.getContextPath();
        if (contextPath != null && destinationPath.startsWith(contextPath)) {
            destinationPath = destinationPath.substring(contextPath.length());
        }
        if ((pathInfo = req.getPathInfo()) != null && (servletPath = req.getServletPath()) != null && destinationPath.startsWith(servletPath)) {
            destinationPath = destinationPath.substring(servletPath.length());
        }
        if (this.debug > 0) {
            this.log("Dest path :" + destinationPath);
        }
        if (destinationPath.toUpperCase(Locale.ENGLISH).startsWith("/WEB-INF") || destinationPath.toUpperCase(Locale.ENGLISH).startsWith("/META-INF")) {
            resp.sendError(403);
            return false;
        }
        String path = this.getRelativePath(req);
        if (path.toUpperCase(Locale.ENGLISH).startsWith("/WEB-INF") || path.toUpperCase(Locale.ENGLISH).startsWith("/META-INF")) {
            resp.sendError(403);
            return false;
        }
        if (destinationPath.equals(path)) {
            resp.sendError(403);
            return false;
        }
        boolean overwrite = true;
        String overwriteHeader = req.getHeader("Overwrite");
        if (overwriteHeader != null) {
            overwrite = "T".equalsIgnoreCase(overwriteHeader);
        }
        boolean exists = true;
        try {
            this.resources.lookup(destinationPath);
        }
        catch (NamingException e) {
            exists = false;
        }
        if (overwrite) {
            if (exists) {
                if (!this.deleteResource(destinationPath, req, resp, true)) {
                    return false;
                }
            } else {
                resp.setStatus(201);
            }
        } else if (exists) {
            resp.sendError(412);
            return false;
        }
        if (!(result = this.copyResource((DirContext)this.resources, errorList = new Hashtable<String, Integer>(), path, destinationPath)) || !errorList.isEmpty()) {
            this.sendReport(req, resp, errorList);
            return false;
        }
        resp.setStatus(201);
        this.lockNullResources.remove(destinationPath);
        return true;
    }

    private boolean copyResource(DirContext resources, Hashtable<String, Integer> errorList, String source, String dest) {
        if (this.debug > 1) {
            this.log("Copy: " + source + " To: " + dest);
        }
        Object object = null;
        try {
            object = resources.lookup(source);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (object instanceof DirContext) {
            try {
                resources.createSubcontext(dest);
            }
            catch (NamingException e) {
                errorList.put(dest, 409);
                return false;
            }
            try {
                NamingEnumeration<NameClassPair> enumeration = resources.list(source);
                while (enumeration.hasMoreElements()) {
                    NameClassPair ncPair = (NameClassPair)enumeration.nextElement();
                    Object childDest = dest;
                    if (!"/".equals(childDest)) {
                        childDest = (String)childDest + "/";
                    }
                    childDest = (String)childDest + ncPair.getName();
                    Object childSrc = source;
                    if (!"/".equals(childSrc)) {
                        childSrc = (String)childSrc + "/";
                    }
                    childSrc = (String)childSrc + ncPair.getName();
                    this.copyResource(resources, errorList, (String)childSrc, (String)childDest);
                }
            }
            catch (NamingException e) {
                errorList.put(dest, 500);
                return false;
            }
        }
        if (object instanceof Resource) {
            try {
                resources.bind(dest, object);
            }
            catch (NamingException e) {
                errorList.put(source, 500);
                return false;
            }
        } else {
            errorList.put(source, 500);
            return false;
        }
        return true;
    }

    private boolean deleteResource(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = this.getRelativePath(req);
        return this.deleteResource(path, req, resp, true);
    }

    private boolean deleteResource(String path, HttpServletRequest req, HttpServletResponse resp, boolean setStatus) throws ServletException, IOException {
        String lockTokenHeader;
        if (path.toUpperCase(Locale.ENGLISH).startsWith("/WEB-INF") || path.toUpperCase(Locale.ENGLISH).startsWith("/META-INF")) {
            resp.sendError(403);
            return false;
        }
        String ifHeader = req.getHeader("If");
        if (ifHeader == null) {
            ifHeader = "";
        }
        if ((lockTokenHeader = req.getHeader("Lock-Token")) == null) {
            lockTokenHeader = "";
        }
        if (this.isLocked(path, ifHeader + lockTokenHeader)) {
            resp.sendError(423);
            return false;
        }
        boolean exists = true;
        Object object = null;
        try {
            object = this.resources.lookup(path);
        }
        catch (NamingException e) {
            exists = false;
        }
        if (!exists) {
            resp.sendError(404);
            return false;
        }
        boolean collection = object instanceof DirContext;
        if (!collection) {
            try {
                this.resources.unbind(path);
            }
            catch (NamingException e) {
                resp.sendError(500);
                return false;
            }
        }
        Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
        this.deleteCollection(req, (DirContext)this.resources, path, errorList);
        try {
            this.resources.unbind(path);
        }
        catch (NamingException e) {
            errorList.put(path, 500);
        }
        if (!errorList.isEmpty()) {
            this.sendReport(req, resp, errorList);
            return false;
        }
        if (setStatus) {
            resp.setStatus(204);
        }
        return true;
    }

    private void deleteCollection(HttpServletRequest req, DirContext resources, String path, Hashtable<String, Integer> errorList) {
        String lockTokenHeader;
        if (this.debug > 1) {
            this.log("Delete:" + path);
        }
        if (path.toUpperCase(Locale.ENGLISH).startsWith("/WEB-INF") || path.toUpperCase(Locale.ENGLISH).startsWith("/META-INF")) {
            errorList.put(path, 403);
            return;
        }
        String ifHeader = req.getHeader("If");
        if (ifHeader == null) {
            ifHeader = "";
        }
        if ((lockTokenHeader = req.getHeader("Lock-Token")) == null) {
            lockTokenHeader = "";
        }
        NamingEnumeration<NameClassPair> enumeration = null;
        try {
            enumeration = resources.list(path);
        }
        catch (NamingException e) {
            errorList.put(path, 500);
            return;
        }
        while (enumeration.hasMoreElements()) {
            NameClassPair ncPair = (NameClassPair)enumeration.nextElement();
            Object childName = path;
            if (!"/".equals(childName)) {
                childName = (String)childName + "/";
            }
            if (this.isLocked((String)(childName = (String)childName + ncPair.getName()), ifHeader + lockTokenHeader)) {
                errorList.put((String)childName, 423);
                continue;
            }
            try {
                Object object = resources.lookup((String)childName);
                if (object instanceof DirContext) {
                    this.deleteCollection(req, resources, (String)childName, errorList);
                }
                try {
                    resources.unbind((String)childName);
                }
                catch (NamingException e) {
                    if (object instanceof DirContext) continue;
                    errorList.put((String)childName, 500);
                }
            }
            catch (NamingException e) {
                errorList.put((String)childName, 500);
            }
        }
    }

    private void sendReport(HttpServletRequest req, HttpServletResponse resp, Hashtable<String, Integer> errorList) throws ServletException, IOException {
        resp.setStatus(207);
        String absoluteUri = req.getRequestURI();
        String relativePath = this.getRelativePath(req);
        XMLWriter generatedXML = new XMLWriter();
        generatedXML.writeXMLHeader();
        generatedXML.writeElement(null, "multistatus" + this.generateNamespaceDeclarations(), 0);
        Enumeration<String> pathList = errorList.keys();
        while (pathList.hasMoreElements()) {
            String errorPath = pathList.nextElement();
            int errorCode = errorList.get(errorPath);
            generatedXML.writeElement(null, "response", 0);
            generatedXML.writeElement(null, "href", 0);
            Object toAppend = errorPath.substring(relativePath.length());
            if (!((String)toAppend).startsWith("/")) {
                toAppend = "/" + (String)toAppend;
            }
            generatedXML.writeText(absoluteUri + (String)toAppend);
            generatedXML.writeElement(null, "href", 1);
            generatedXML.writeElement(null, "status", 0);
            generatedXML.writeText("HTTP/1.1 " + errorCode + " " + WebdavStatus.getStatusText(errorCode));
            generatedXML.writeElement(null, "status", 1);
            generatedXML.writeElement(null, "response", 1);
        }
        generatedXML.writeElement(null, "multistatus", 1);
        PrintWriter writer = resp.getWriter();
        ((Writer)writer).write(generatedXML.toString());
        ((Writer)writer).close();
    }

    private void parseProperties(HttpServletRequest req, XMLWriter generatedXML, String path, int type, Vector<String> propertiesVector) {
        if (path.toUpperCase(Locale.ENGLISH).startsWith("/WEB-INF") || path.toUpperCase(Locale.ENGLISH).startsWith("/META-INF")) {
            return;
        }
        CacheEntry cacheEntry = this.resources.lookupCache(path);
        generatedXML.writeElement(null, "response", 0);
        String status = "HTTP/1.1 200 " + WebdavStatus.getStatusText(200);
        generatedXML.writeElement(null, "href", 0);
        String href = req.getContextPath() + req.getServletPath();
        href = href.endsWith("/") && path.startsWith("/") ? href + path.substring(1) : href + path;
        if (cacheEntry.context != null && !href.endsWith("/")) {
            href = href + "/";
        }
        generatedXML.writeText(this.rewriteUrl(href));
        generatedXML.writeElement(null, "href", 1);
        String resourceName = path;
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash != -1) {
            resourceName = resourceName.substring(lastSlash + 1);
        }
        switch (type) {
            case 1: {
                generatedXML.writeElement(null, "propstat", 0);
                generatedXML.writeElement(null, "prop", 0);
                generatedXML.writeProperty(null, "creationdate", this.getISOCreationDate(cacheEntry.attributes.getCreation()));
                generatedXML.writeElement(null, "displayname", 0);
                generatedXML.writeData(resourceName);
                generatedXML.writeElement(null, "displayname", 1);
                if (cacheEntry.resource != null) {
                    generatedXML.writeProperty(null, "getlastmodified", FastHttpDateFormat.formatDate((long)cacheEntry.attributes.getLastModified(), null));
                    generatedXML.writeProperty(null, "getcontentlength", String.valueOf(cacheEntry.attributes.getContentLength()));
                    String contentType = this.getServletContext().getMimeType(cacheEntry.name);
                    if (contentType != null) {
                        generatedXML.writeProperty(null, "getcontenttype", contentType);
                    }
                    generatedXML.writeProperty(null, "getetag", cacheEntry.attributes.getETag());
                    generatedXML.writeElement(null, "resourcetype", 2);
                } else {
                    generatedXML.writeElement(null, "resourcetype", 0);
                    generatedXML.writeElement(null, "collection", 2);
                    generatedXML.writeElement(null, "resourcetype", 1);
                }
                generatedXML.writeProperty(null, "source", "");
                String supportedLocks = "<lockentry><lockscope><exclusive/></lockscope><locktype><write/></locktype></lockentry><lockentry><lockscope><shared/></lockscope><locktype><write/></locktype></lockentry>";
                generatedXML.writeElement(null, "supportedlock", 0);
                generatedXML.writeText(supportedLocks);
                generatedXML.writeElement(null, "supportedlock", 1);
                this.generateLockDiscovery(path, generatedXML);
                generatedXML.writeElement(null, "prop", 1);
                generatedXML.writeElement(null, "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement(null, "status", 1);
                generatedXML.writeElement(null, "propstat", 1);
                break;
            }
            case 2: {
                generatedXML.writeElement(null, "propstat", 0);
                generatedXML.writeElement(null, "prop", 0);
                generatedXML.writeElement(null, "creationdate", 2);
                generatedXML.writeElement(null, "displayname", 2);
                if (cacheEntry.resource != null) {
                    generatedXML.writeElement(null, "getcontentlanguage", 2);
                    generatedXML.writeElement(null, "getcontentlength", 2);
                    generatedXML.writeElement(null, "getcontenttype", 2);
                    generatedXML.writeElement(null, "getetag", 2);
                    generatedXML.writeElement(null, "getlastmodified", 2);
                }
                generatedXML.writeElement(null, "resourcetype", 2);
                generatedXML.writeElement(null, "source", 2);
                generatedXML.writeElement(null, "lockdiscovery", 2);
                generatedXML.writeElement(null, "prop", 1);
                generatedXML.writeElement(null, "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement(null, "status", 1);
                generatedXML.writeElement(null, "propstat", 1);
                break;
            }
            case 0: {
                Vector<String> propertiesNotFound = new Vector<String>();
                generatedXML.writeElement(null, "propstat", 0);
                generatedXML.writeElement(null, "prop", 0);
                Enumeration<String> properties = propertiesVector.elements();
                while (properties.hasMoreElements()) {
                    String property = properties.nextElement();
                    if ("creationdate".equals(property)) {
                        generatedXML.writeProperty(null, "creationdate", this.getISOCreationDate(cacheEntry.attributes.getCreation()));
                        continue;
                    }
                    if ("displayname".equals(property)) {
                        generatedXML.writeElement(null, "displayname", 0);
                        generatedXML.writeData(resourceName);
                        generatedXML.writeElement(null, "displayname", 1);
                        continue;
                    }
                    if ("getcontentlanguage".equals(property)) {
                        if (cacheEntry.context != null) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeElement(null, "getcontentlanguage", 2);
                        continue;
                    }
                    if ("getcontentlength".equals(property)) {
                        if (cacheEntry.context != null) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty(null, "getcontentlength", String.valueOf(cacheEntry.attributes.getContentLength()));
                        continue;
                    }
                    if ("getcontenttype".equals(property)) {
                        if (cacheEntry.context != null) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty(null, "getcontenttype", this.getServletContext().getMimeType(cacheEntry.name));
                        continue;
                    }
                    if ("getetag".equals(property)) {
                        if (cacheEntry.context != null) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty(null, "getetag", cacheEntry.attributes.getETag());
                        continue;
                    }
                    if ("getlastmodified".equals(property)) {
                        if (cacheEntry.context != null) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty(null, "getlastmodified", FastHttpDateFormat.formatDate((long)cacheEntry.attributes.getLastModified(), null));
                        continue;
                    }
                    if ("resourcetype".equals(property)) {
                        if (cacheEntry.context != null) {
                            generatedXML.writeElement(null, "resourcetype", 0);
                            generatedXML.writeElement(null, "collection", 2);
                            generatedXML.writeElement(null, "resourcetype", 1);
                            continue;
                        }
                        generatedXML.writeElement(null, "resourcetype", 2);
                        continue;
                    }
                    if ("source".equals(property)) {
                        generatedXML.writeProperty(null, "source", "");
                        continue;
                    }
                    if ("supportedlock".equals(property)) {
                        String supportedLocks = "<lockentry><lockscope><exclusive/></lockscope><locktype><write/></locktype></lockentry><lockentry><lockscope><shared/></lockscope><locktype><write/></locktype></lockentry>";
                        generatedXML.writeElement(null, "supportedlock", 0);
                        generatedXML.writeText(supportedLocks);
                        generatedXML.writeElement(null, "supportedlock", 1);
                        continue;
                    }
                    if ("lockdiscovery".equals(property)) {
                        if (this.generateLockDiscovery(path, generatedXML)) continue;
                        propertiesNotFound.addElement(property);
                        continue;
                    }
                    propertiesNotFound.addElement(property);
                }
                generatedXML.writeElement(null, "prop", 1);
                generatedXML.writeElement(null, "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement(null, "status", 1);
                generatedXML.writeElement(null, "propstat", 1);
                Enumeration propertiesNotFoundList = propertiesNotFound.elements();
                if (!propertiesNotFoundList.hasMoreElements()) break;
                status = "HTTP/1.1 404 " + WebdavStatus.getStatusText(404);
                generatedXML.writeElement(null, "propstat", 0);
                generatedXML.writeElement(null, "prop", 0);
                while (propertiesNotFoundList.hasMoreElements()) {
                    generatedXML.writeElement(null, (String)propertiesNotFoundList.nextElement(), 2);
                }
                generatedXML.writeElement(null, "prop", 1);
                generatedXML.writeElement(null, "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement(null, "status", 1);
                generatedXML.writeElement(null, "propstat", 1);
                break;
            }
        }
        generatedXML.writeElement(null, "response", 1);
    }

    private void parseLockNullProperties(HttpServletRequest req, XMLWriter generatedXML, String path, int type, Vector<String> propertiesVector) {
        if (path.toUpperCase(Locale.ENGLISH).startsWith("/WEB-INF") || path.toUpperCase(Locale.ENGLISH).startsWith("/META-INF")) {
            return;
        }
        LockInfo lock = this.resourceLocks.get(path);
        if (lock == null) {
            return;
        }
        generatedXML.writeElement(null, "response", 0);
        String status = "HTTP/1.1 200 " + WebdavStatus.getStatusText(200);
        generatedXML.writeElement(null, "href", 0);
        String absoluteUri = req.getRequestURI();
        String relativePath = this.getRelativePath(req);
        Object toAppend = path.substring(relativePath.length());
        if (!((String)toAppend).startsWith("/")) {
            toAppend = "/" + (String)toAppend;
        }
        generatedXML.writeText(this.rewriteUrl(RequestUtil.normalize(absoluteUri + (String)toAppend)));
        generatedXML.writeElement(null, "href", 1);
        String resourceName = path;
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash != -1) {
            resourceName = resourceName.substring(lastSlash + 1);
        }
        switch (type) {
            case 1: {
                generatedXML.writeElement(null, "propstat", 0);
                generatedXML.writeElement(null, "prop", 0);
                generatedXML.writeProperty(null, "creationdate", this.getISOCreationDate(lock.creationDate.getTime()));
                generatedXML.writeElement(null, "displayname", 0);
                generatedXML.writeData(resourceName);
                generatedXML.writeElement(null, "displayname", 1);
                generatedXML.writeProperty(null, "getlastmodified", FastHttpDateFormat.formatDate((long)lock.creationDate.getTime(), null));
                generatedXML.writeProperty(null, "getcontentlength", String.valueOf(0));
                generatedXML.writeProperty(null, "getcontenttype", "");
                generatedXML.writeProperty(null, "getetag", "");
                generatedXML.writeElement(null, "resourcetype", 0);
                generatedXML.writeElement(null, "lock-null", 2);
                generatedXML.writeElement(null, "resourcetype", 1);
                generatedXML.writeProperty(null, "source", "");
                String supportedLocks = "<lockentry><lockscope><exclusive/></lockscope><locktype><write/></locktype></lockentry><lockentry><lockscope><shared/></lockscope><locktype><write/></locktype></lockentry>";
                generatedXML.writeElement(null, "supportedlock", 0);
                generatedXML.writeText(supportedLocks);
                generatedXML.writeElement(null, "supportedlock", 1);
                this.generateLockDiscovery(path, generatedXML);
                generatedXML.writeElement(null, "prop", 1);
                generatedXML.writeElement(null, "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement(null, "status", 1);
                generatedXML.writeElement(null, "propstat", 1);
                break;
            }
            case 2: {
                generatedXML.writeElement(null, "propstat", 0);
                generatedXML.writeElement(null, "prop", 0);
                generatedXML.writeElement(null, "creationdate", 2);
                generatedXML.writeElement(null, "displayname", 2);
                generatedXML.writeElement(null, "getcontentlanguage", 2);
                generatedXML.writeElement(null, "getcontentlength", 2);
                generatedXML.writeElement(null, "getcontenttype", 2);
                generatedXML.writeElement(null, "getetag", 2);
                generatedXML.writeElement(null, "getlastmodified", 2);
                generatedXML.writeElement(null, "resourcetype", 2);
                generatedXML.writeElement(null, "source", 2);
                generatedXML.writeElement(null, "lockdiscovery", 2);
                generatedXML.writeElement(null, "prop", 1);
                generatedXML.writeElement(null, "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement(null, "status", 1);
                generatedXML.writeElement(null, "propstat", 1);
                break;
            }
            case 0: {
                Vector<String> propertiesNotFound = new Vector<String>();
                generatedXML.writeElement(null, "propstat", 0);
                generatedXML.writeElement(null, "prop", 0);
                Enumeration<String> properties = propertiesVector.elements();
                while (properties.hasMoreElements()) {
                    String property = properties.nextElement();
                    if ("creationdate".equals(property)) {
                        generatedXML.writeProperty(null, "creationdate", this.getISOCreationDate(lock.creationDate.getTime()));
                        continue;
                    }
                    if ("displayname".equals(property)) {
                        generatedXML.writeElement(null, "displayname", 0);
                        generatedXML.writeData(resourceName);
                        generatedXML.writeElement(null, "displayname", 1);
                        continue;
                    }
                    if ("getcontentlanguage".equals(property)) {
                        generatedXML.writeElement(null, "getcontentlanguage", 2);
                        continue;
                    }
                    if ("getcontentlength".equals(property)) {
                        generatedXML.writeProperty(null, "getcontentlength", String.valueOf(0));
                        continue;
                    }
                    if ("getcontenttype".equals(property)) {
                        generatedXML.writeProperty(null, "getcontenttype", "");
                        continue;
                    }
                    if ("getetag".equals(property)) {
                        generatedXML.writeProperty(null, "getetag", "");
                        continue;
                    }
                    if ("getlastmodified".equals(property)) {
                        generatedXML.writeProperty(null, "getlastmodified", FastHttpDateFormat.formatDate((long)lock.creationDate.getTime(), null));
                        continue;
                    }
                    if ("resourcetype".equals(property)) {
                        generatedXML.writeElement(null, "resourcetype", 0);
                        generatedXML.writeElement(null, "lock-null", 2);
                        generatedXML.writeElement(null, "resourcetype", 1);
                        continue;
                    }
                    if ("source".equals(property)) {
                        generatedXML.writeProperty(null, "source", "");
                        continue;
                    }
                    if ("supportedlock".equals(property)) {
                        String supportedLocks = "<lockentry><lockscope><exclusive/></lockscope><locktype><write/></locktype></lockentry><lockentry><lockscope><shared/></lockscope><locktype><write/></locktype></lockentry>";
                        generatedXML.writeElement(null, "supportedlock", 0);
                        generatedXML.writeText(supportedLocks);
                        generatedXML.writeElement(null, "supportedlock", 1);
                        continue;
                    }
                    if ("lockdiscovery".equals(property)) {
                        if (this.generateLockDiscovery(path, generatedXML)) continue;
                        propertiesNotFound.addElement(property);
                        continue;
                    }
                    propertiesNotFound.addElement(property);
                }
                generatedXML.writeElement(null, "prop", 1);
                generatedXML.writeElement(null, "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement(null, "status", 1);
                generatedXML.writeElement(null, "propstat", 1);
                Enumeration propertiesNotFoundList = propertiesNotFound.elements();
                if (!propertiesNotFoundList.hasMoreElements()) break;
                status = "HTTP/1.1 404 " + WebdavStatus.getStatusText(404);
                generatedXML.writeElement(null, "propstat", 0);
                generatedXML.writeElement(null, "prop", 0);
                while (propertiesNotFoundList.hasMoreElements()) {
                    generatedXML.writeElement(null, (String)propertiesNotFoundList.nextElement(), 2);
                }
                generatedXML.writeElement(null, "prop", 1);
                generatedXML.writeElement(null, "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement(null, "status", 1);
                generatedXML.writeElement(null, "propstat", 1);
                break;
            }
        }
        generatedXML.writeElement(null, "response", 1);
    }

    private boolean generateLockDiscovery(String path, XMLWriter generatedXML) {
        LockInfo resourceLock = this.resourceLocks.get(path);
        Enumeration<LockInfo> collectionLocksList = this.collectionLocks.elements();
        boolean wroteStart = false;
        if (resourceLock != null) {
            wroteStart = true;
            generatedXML.writeElement(null, "lockdiscovery", 0);
            resourceLock.toXML(generatedXML);
        }
        while (collectionLocksList.hasMoreElements()) {
            LockInfo currentLock = collectionLocksList.nextElement();
            if (!path.startsWith(currentLock.path)) continue;
            if (!wroteStart) {
                wroteStart = true;
                generatedXML.writeElement(null, "lockdiscovery", 0);
            }
            currentLock.toXML(generatedXML);
        }
        if (!wroteStart) {
            return false;
        }
        generatedXML.writeElement(null, "lockdiscovery", 1);
        return true;
    }

    private String getISOCreationDate(long creationDate) {
        StringBuilder creationDateValue = new StringBuilder(creationDateFormat.get().format(new Date(creationDate)));
        return creationDateValue.toString();
    }

    private StringBuilder determineMethodsAllowed(DirContext resources, HttpServletRequest req) {
        StringBuilder methodsAllowed = new StringBuilder();
        boolean exists = true;
        Object object = null;
        try {
            String path = this.getRelativePath(req);
            object = resources.lookup(path);
        }
        catch (NamingException e) {
            exists = false;
        }
        if (!exists) {
            methodsAllowed.append("OPTIONS, MKCOL, PUT, LOCK");
            return methodsAllowed;
        }
        methodsAllowed.append("OPTIONS, GET, HEAD, POST, DELETE, TRACE");
        methodsAllowed.append(", PROPPATCH, COPY, MOVE, LOCK, UNLOCK");
        if (this.listings) {
            methodsAllowed.append(", PROPFIND");
        }
        if (!(object instanceof DirContext)) {
            methodsAllowed.append(", PUT");
        }
        return methodsAllowed;
    }

    static {
        try {
            sha256Helper = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("No SHA-256");
        }
    }

    private static class WebdavResolver
    implements EntityResolver {
        private ServletContext context;

        public WebdavResolver(ServletContext theContext) {
            this.context = theContext;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            String msg = MessageFormat.format(DefaultServlet.rb.getString("AS-WEB-CORE-00336"), publicId, systemId);
            this.context.log(msg);
            return new InputSource(new StringReader("Ignored external entity"));
        }
    }

    private static class LockInfo {
        String path = "/";
        String type = "write";
        String scope = "exclusive";
        int depth = 0;
        String owner = "";
        Vector<String> tokens = new Vector();
        long expiresAt = 0L;
        Date creationDate = new Date();

        public String toString() {
            StringBuilder result = new StringBuilder("Type:");
            result.append(this.type).append("\n");
            result.append("Scope:").append(this.scope).append("\n");
            result.append("Depth:").append(this.depth).append("\n");
            result.append("Owner:").append(this.owner).append("\n");
            result.append("Expiration:").append(FastHttpDateFormat.formatDate((long)this.expiresAt, null)).append("\n");
            Enumeration<String> tokensList = this.tokens.elements();
            while (tokensList.hasMoreElements()) {
                result.append("Token:").append(tokensList.nextElement()).append("\n");
            }
            return result.toString();
        }

        public boolean hasExpired() {
            return System.currentTimeMillis() > this.expiresAt;
        }

        public boolean isExclusive() {
            return "exclusive".equals(this.scope);
        }

        public void toXML(XMLWriter generatedXML) {
            generatedXML.writeElement(null, "activelock", 0);
            generatedXML.writeElement(null, "locktype", 0);
            generatedXML.writeElement(null, this.type, 2);
            generatedXML.writeElement(null, "locktype", 1);
            generatedXML.writeElement(null, "lockscope", 0);
            generatedXML.writeElement(null, this.scope, 2);
            generatedXML.writeElement(null, "lockscope", 1);
            generatedXML.writeElement(null, "depth", 0);
            if (this.depth == 3) {
                generatedXML.writeText("Infinity");
            } else {
                generatedXML.writeText("0");
            }
            generatedXML.writeElement(null, "depth", 1);
            generatedXML.writeElement(null, "owner", 0);
            generatedXML.writeText(this.owner);
            generatedXML.writeElement(null, "owner", 1);
            generatedXML.writeElement(null, "timeout", 0);
            long timeout = (this.expiresAt - System.currentTimeMillis()) / 1000L;
            generatedXML.writeText("Second-" + timeout);
            generatedXML.writeElement(null, "timeout", 1);
            generatedXML.writeElement(null, "locktoken", 0);
            Enumeration<String> tokensList = this.tokens.elements();
            while (tokensList.hasMoreElements()) {
                generatedXML.writeElement(null, "href", 0);
                generatedXML.writeText("opaquelocktoken:" + tokensList.nextElement());
                generatedXML.writeElement(null, "href", 1);
            }
            generatedXML.writeElement(null, "locktoken", 1);
            generatedXML.writeElement(null, "activelock", 1);
        }
    }
}

