/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurro.virtualthreads;

import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.glassfish.concurro.AbstractManagedExecutorService;
import org.glassfish.concurro.internal.ManagedFutureTask;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class VirtualThreadsManagedFutureTask<V>
extends ManagedFutureTask<V> {
    private Semaphore parallelTasksSemaphore = null;
    private Runnable taskCompletionHandler = null;
    private Consumer<VirtualThreadsManagedFutureTask<V>> taskStartedHandler = null;

    public VirtualThreadsManagedFutureTask(AbstractManagedExecutorService executor, Runnable runnable, V result, Semaphore parallelTasksSemaphore) {
        super(executor, runnable, result);
        this.parallelTasksSemaphore = parallelTasksSemaphore;
    }

    public VirtualThreadsManagedFutureTask(AbstractManagedExecutorService executor, Callable<V> callable, Semaphore parallelTasksSemaphore) {
        super(executor, callable);
        this.parallelTasksSemaphore = parallelTasksSemaphore;
    }

    public void setTaskCompletionHandler(Runnable taskCompletionHandler) {
        this.taskCompletionHandler = taskCompletionHandler;
    }

    public void setTaskStartedHandler(Consumer<VirtualThreadsManagedFutureTask<V>> taskStartedHandler) {
        this.taskStartedHandler = taskStartedHandler;
    }

    @Override
    public void run() {
        this.runPooled(() -> {
            super.run();
            return null;
        }, null);
    }

    @Override
    public boolean runAndReset() {
        return this.runPooled(() -> super.runAndReset(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T runPooled(Supplier<T> wrappedCallable, T defaultResult) {
        try {
            try {
                this.acquireIfNotNull(this.parallelTasksSemaphore);
            }
            catch (InterruptedException ex) {
                T t = defaultResult;
                this.releaseIfNotNull(this.parallelTasksSemaphore);
                this.triggerIfNotNull(this.taskCompletionHandler);
                return t;
            }
            this.triggerIfNotNull(this.taskStartedHandler, this);
            T t = this.runAndTriggerEvents(wrappedCallable);
            return t;
        }
        finally {
            this.releaseIfNotNull(this.parallelTasksSemaphore);
            this.triggerIfNotNull(this.taskCompletionHandler);
        }
    }

    private void triggerIfNotNull(Runnable handler) {
        if (handler != null) {
            handler.run();
        }
    }

    private void triggerIfNotNull(Consumer<VirtualThreadsManagedFutureTask<V>> handler, VirtualThreadsManagedFutureTask<V> task) {
        if (handler != null) {
            handler.accept(task);
        }
    }

    private void releaseIfNotNull(Semaphore semaphore) {
        if (semaphore != null) {
            semaphore.release();
        }
    }

    private void acquireIfNotNull(Semaphore semaphore) throws InterruptedException {
        if (semaphore != null) {
            semaphore.acquire();
        }
    }

    private <T> T runAndTriggerEvents(Supplier<T> wrappedCallable) {
        this.beforeExecute(Thread.currentThread());
        Exception taskException = null;
        try {
            T t = wrappedCallable.get();
            return t;
        }
        catch (Exception e) {
            taskException = e;
            throw e;
        }
        finally {
            this.afterExecute(taskException);
        }
    }

    protected void beforeExecute(Thread t) {
        this.setupContext();
        this.starting(t);
    }

    protected void afterExecute(Throwable t) {
        this.done(t);
    }
}

