/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.compiler;

import jakarta.servlet.ServletContext;
import jakarta.servlet.jsp.JspFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.JavaFileObject;
import org.glassfish.wasp.JspCompilationContext;
import org.glassfish.wasp.Options;
import org.glassfish.wasp.compiler.Localizer;
import org.glassfish.wasp.runtime.JspFactoryImpl;
import org.glassfish.wasp.servlet.JspCServletContext;
import org.glassfish.wasp.servlet.JspServletWrapper;

public final class JspRuntimeContext
implements Runnable {
    private static Logger log = Logger.getLogger(JspRuntimeContext.class.getName());
    private AtomicInteger jspReloadCount = new AtomicInteger(0);
    private ServletContext context;
    private Options options;
    private String classpath;
    private Map<String, JspServletWrapper> jsps;
    private Map<String, byte[]> bytecodes;
    private Map<String, Long> bytecodeBirthTimes;
    private Map<String, Map<String, JavaFileObject>> packageMap;
    private Thread thread;
    private boolean threadDone;
    private String threadName = "JspRuntimeContext";

    public JspRuntimeContext(ServletContext context, Options options) {
        this.context = context;
        this.options = options;
        int hashSize = options.getInitialCapacity();
        this.jsps = new ConcurrentHashMap<String, JspServletWrapper>(hashSize);
        this.bytecodes = new ConcurrentHashMap<String, byte[]>(hashSize);
        this.bytecodeBirthTimes = new ConcurrentHashMap<String, Long>(hashSize);
        this.packageMap = new ConcurrentHashMap<String, Map<String, JavaFileObject>>();
        if (log.isLoggable(Level.FINEST)) {
            ClassLoader parentClassLoader = this.getParentClassLoader();
            if (parentClassLoader != null) {
                log.finest(Localizer.getMessage("jsp.message.parent_class_loader_is", parentClassLoader.toString()));
            } else {
                log.finest(Localizer.getMessage("jsp.message.parent_class_loader_is", "<none>"));
            }
        }
        this.initClassPath();
        if (context instanceof JspCServletContext) {
            return;
        }
        String appBase = context.getRealPath("/");
        if (!options.getDevelopment() && appBase != null && options.getCheckInterval() > 0 && !options.getUsePrecompiled()) {
            if (appBase.endsWith(File.separator)) {
                appBase = appBase.substring(0, appBase.length() - 1);
            }
            String directory = appBase.substring(appBase.lastIndexOf(File.separator));
            this.threadName = this.threadName + "[" + directory + "]";
            this.threadStart();
        }
    }

    public void addWrapper(String jspUri, JspServletWrapper jsw) {
        this.jsps.remove(jspUri);
        this.jsps.put(jspUri, jsw);
    }

    public JspServletWrapper getWrapper(String jspUri) {
        return this.jsps.get(jspUri);
    }

    public void removeWrapper(String jspUri) {
        this.jsps.remove(jspUri);
    }

    public int getJspCount() {
        return this.jsps.size();
    }

    public ClassLoader getParentClassLoader() {
        ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
        if (parentClassLoader == null) {
            parentClassLoader = this.getClass().getClassLoader();
        }
        return parentClassLoader;
    }

    public void destroy() {
        this.threadStop();
        for (JspServletWrapper jsw : this.jsps.values()) {
            jsw.destroy();
        }
    }

    public void incrementJspReloadCount() {
        this.jspReloadCount.incrementAndGet();
    }

    public void setJspReloadCount(int count) {
        this.jspReloadCount.set(count);
    }

    public int getJspReloadCount() {
        return this.jspReloadCount.get();
    }

    public void setBytecode(String name, byte[] bytecode) {
        if (bytecode == null) {
            this.bytecodes.remove(name);
            this.bytecodeBirthTimes.remove(name);
            return;
        }
        this.bytecodes.put(name, bytecode);
        this.bytecodeBirthTimes.put(name, System.currentTimeMillis());
    }

    public void adjustBytecodeTime(String name, long reference) {
        Long time = this.bytecodeBirthTimes.get(name);
        if (time == null) {
            return;
        }
        if (time < reference) {
            this.bytecodeBirthTimes.put(name, reference);
        }
    }

    public Map<String, byte[]> getBytecodes() {
        return this.bytecodes;
    }

    public byte[] getBytecode(String name) {
        return this.bytecodes.get(name);
    }

    public long getBytecodeBirthTime(String name) {
        Long time = this.bytecodeBirthTimes.get(name);
        return time != null ? time : 0L;
    }

    public Map<String, Map<String, JavaFileObject>> getPackageMap() {
        return this.packageMap;
    }

    public void saveBytecode(String className, String classFileName) {
        byte[] bytecode = this.getBytecode(className);
        if (bytecode != null) {
            try {
                FileOutputStream fos = new FileOutputStream(classFileName);
                fos.write(bytecode);
                fos.close();
            }
            catch (IOException ex) {
                this.context.log("Error in saving bytecode for " + className + " to " + classFileName, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCompile() {
        for (JspServletWrapper jsw : this.jsps.values()) {
            if (jsw.isTagFile()) continue;
            JspCompilationContext ctxt = jsw.getJspEngineContext();
            JspServletWrapper jspServletWrapper = jsw;
            synchronized (jspServletWrapper) {
                try {
                    ctxt.compile();
                }
                catch (FileNotFoundException ex) {
                    ctxt.incrementRemoved();
                }
                catch (Throwable t) {
                    jsw.getServletContext().log(Localizer.getMessage("jsp.error.background.compile"), t);
                }
            }
        }
    }

    public String getClassPath() {
        return this.classpath;
    }

    private void initClassPath() {
        block5: {
            StringBuilder cpath = new StringBuilder();
            String sep = System.getProperty("path.separator");
            cpath.append(this.options.getScratchDir() + sep);
            String cp = (String)this.context.getAttribute("org.apache.catalina.jsp_classpath");
            if (cp == null || cp.equals("")) {
                cp = this.options.getClassPath();
            }
            if (cp != null) {
                this.classpath = cpath.toString() + cp;
            }
            if (this.classpath != null) {
                try {
                    this.classpath = URLDecoder.decode(this.classpath, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    if (!log.isLoggable(Level.FINE)) break block5;
                    log.log(Level.FINE, "Exception decoding classpath : " + this.classpath, e);
                }
            }
        }
    }

    protected void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    protected void threadSleep() {
        try {
            Thread.sleep((long)this.options.getCheckInterval() * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            try {
                this.checkCompile();
            }
            catch (Throwable t) {
                t.printStackTrace();
                log.log(Level.SEVERE, Localizer.getMessage("jsp.error.recompile"), t);
            }
        }
    }

    static {
        JspFactory.setDefaultFactory((JspFactory)new JspFactoryImpl());
    }
}

