/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.util.Util;
import jakarta.faces.context.ExternalContext;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Set;

public class ResourcePathsIterator
implements Iterator<String> {
    private final int maxDepth;
    private final ExternalContext externalContext;
    private final String[] extensions;
    private final String[] restrictedDirectories;
    private final ArrayDeque<String> stack = new ArrayDeque();
    private String next;

    public ResourcePathsIterator(String rootPath, int maxDepth, String[] extensions, String[] restrictedDirectories, ExternalContext externalContext) {
        this.maxDepth = maxDepth;
        this.externalContext = externalContext;
        this.extensions = extensions;
        this.restrictedDirectories = restrictedDirectories;
        this.visit(rootPath);
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        this.tryTake();
        return this.next != null;
    }

    @Override
    public String next() {
        if (this.next == null) {
            this.tryTake();
        }
        String nextReturn = this.next;
        this.next = null;
        return nextReturn;
    }

    private void visit(String resourcePath) {
        Set<String> set = this.externalContext.getResourcePaths(resourcePath);
        if (set != null) {
            this.stack.addAll(set);
        }
    }

    private void tryTake() {
        if (this.stack.isEmpty()) {
            return;
        }
        while (this.next == null && !this.stack.isEmpty()) {
            String nextCandidate = this.stack.removeFirst();
            if (ResourcePathsIterator.isDirectory(nextCandidate)) {
                if (Util.startsWithOneOf(nextCandidate, this.restrictedDirectories) || ResourcePathsIterator.directoryExceedsMaxDepth(nextCandidate, this.maxDepth)) continue;
                this.visit(nextCandidate);
                continue;
            }
            if (!ResourcePathsIterator.isValidCandidate(nextCandidate, this.extensions)) continue;
            this.next = nextCandidate;
        }
    }

    private static boolean isDirectory(String resourcePath) {
        return resourcePath.endsWith("/");
    }

    private static boolean directoryExceedsMaxDepth(String resourcePath, long max) {
        return resourcePath.chars().filter(i -> i == 47).count() > max;
    }

    private static boolean isValidCandidate(String resourcePath, String[] extensions) {
        if (extensions == null || extensions.length == 0) {
            return true;
        }
        for (String extension : extensions) {
            if (!resourcePath.endsWith(extension)) continue;
            return true;
        }
        return false;
    }
}

