/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.core.MessageDeliveryTimeTimer;
import java.io.Serializable;
import java.util.Comparator;

public class MessageDeliveryTimeInfo {
    static Comparator deliveryTimeCompare = new DeliveryTimeComparator();
    private SysMessageID id = null;
    private long deliveryTime = 0L;
    private boolean deliveryDue = false;
    private boolean deliveryReady = false;
    private boolean inprocessing = false;
    private Boolean onTimerState = null;
    private MessageDeliveryTimeTimer readyListener = null;

    public String toString() {
        return "DeliveryTimeInfo[" + String.valueOf(this.id) + ", " + this.deliveryTime + "]" + this.deliveryDue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDeliveryDue() {
        long currtime = System.currentTimeMillis();
        MessageDeliveryTimeInfo messageDeliveryTimeInfo = this;
        synchronized (messageDeliveryTimeInfo) {
            if (!this.deliveryDue) {
                this.deliveryDue = this.deliveryTime <= currtime;
            }
            return this.deliveryDue;
        }
    }

    public synchronized boolean setInProcessing(boolean b) {
        if (!b) {
            this.inprocessing = false;
            return true;
        }
        if (this.inprocessing) {
            return false;
        }
        this.inprocessing = true;
        return true;
    }

    public synchronized Boolean getOnTimerState() {
        return this.onTimerState;
    }

    public synchronized void setOnTimerState() {
        this.onTimerState = Boolean.TRUE;
    }

    public synchronized void setOffTimerState() {
        this.onTimerState = Boolean.FALSE;
    }

    protected synchronized void setDeliveryReadyListener(MessageDeliveryTimeTimer l) {
        this.readyListener = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelTimer() {
        MessageDeliveryTimeTimer listener = null;
        MessageDeliveryTimeInfo messageDeliveryTimeInfo = this;
        synchronized (messageDeliveryTimeInfo) {
            if (this.readyListener != null) {
                listener = this.readyListener;
            }
        }
        if (listener != null) {
            listener.removeMessage(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeliveryReady() {
        MessageDeliveryTimeTimer listener = null;
        MessageDeliveryTimeInfo messageDeliveryTimeInfo = this;
        synchronized (messageDeliveryTimeInfo) {
            this.deliveryReady = true;
            if (this.readyListener != null) {
                listener = this.readyListener;
                this.readyListener = null;
            }
        }
        if (listener != null) {
            listener.deliveryReady(this);
        }
    }

    public synchronized boolean isDeliveryReady() {
        return this.deliveryReady;
    }

    public static Comparator getComparator() {
        return deliveryTimeCompare;
    }

    public MessageDeliveryTimeInfo(SysMessageID id, long deliveryTime) {
        this.id = id;
        this.deliveryTime = deliveryTime;
    }

    public long getDeliveryTime() {
        return this.deliveryTime;
    }

    public SysMessageID getSysMessageID() {
        return this.id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MessageDeliveryTimeInfo)) {
            return false;
        }
        MessageDeliveryTimeInfo di = (MessageDeliveryTimeInfo)o;
        if (this.id == null || di.id == null) {
            throw new RuntimeException("Internal Error: unexpected values on MessageDeliveryTimeInfo.equals(" + String.valueOf(di) + ")" + String.valueOf(this.id));
        }
        return this.id.equals((Object)di.id);
    }

    static class DeliveryTimeComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 1128049803707369773L;

        DeliveryTimeComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof MessageDeliveryTimeInfo) || !(o2 instanceof MessageDeliveryTimeInfo)) {
                throw new RuntimeException("Internal Error: unexpected object type passed to MessageDeliveryTimeInfo.compare(" + String.valueOf(o1) + ", " + String.valueOf(o2) + ")");
            }
            MessageDeliveryTimeInfo di1 = (MessageDeliveryTimeInfo)o1;
            MessageDeliveryTimeInfo di2 = (MessageDeliveryTimeInfo)o2;
            long diff = di1.deliveryTime - di2.deliveryTime;
            if (diff != 0L) {
                return diff > 0L ? 1 : -1;
            }
            SysMessageID sys1 = di1.id;
            SysMessageID sys2 = di2.id;
            diff = sys2.getTimestamp() - sys1.getTimestamp();
            if (diff == 0L) {
                diff = sys2.getSequence() - sys1.getSequence();
            }
            if (diff == 0L) {
                return 0;
            }
            return diff < 0L ? 1 : -1;
        }
    }
}

