/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.logviewer.backend;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.server.logging.LogFacade;
import com.sun.enterprise.server.logging.logviewer.backend.LogFile;
import com.sun.enterprise.server.logging.logviewer.backend.LogFilterForInstance;
import com.sun.enterprise.server.logging.logviewer.backend.LogRecordTemplate;
import com.sun.enterprise.util.StringUtils;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service
public class LogFilter {
    private static final String RESULTS_ATTRIBUTE = "Results";
    private static final String NV_SEPARATOR = ";";
    static final String[] LOG_LEVELS = new String[]{"SEVERE", "WARNING", "INFO", "CONFIG", "FINE", "FINER", "FINEST"};
    private static String[] serverLogElements = new String[]{System.getProperty("com.sun.aas.instanceRoot"), "logs", "server.log"};
    private static String pL = System.getProperty("com.sun.aas.processLauncher");
    private static String verboseMode = System.getProperty("com.sun.aas.verboseMode", "false");
    private static String defaultLogFile = System.getProperty("com.sun.aas.defaultLogFile");
    private final LogFile logFile = pL != null && !verboseMode.equals("true") && defaultLogFile != null ? new LogFile(defaultLogFile) : new LogFile(StringUtils.makeFilePath((String[])serverLogElements, (boolean)false));
    private static Hashtable<String, LogFile> logFileCache = new Hashtable();
    private static final Logger LOGGER = LogFacade.LOGGING_LOGGER;
    private static final boolean DEBUG = false;
    @Inject
    Domain domain;
    @Inject
    CommandRunner commandRunner;
    @Inject
    ServerEnvironment env;
    @Inject
    private ServiceLocator habitat;
    @Inject
    LoggingConfigImpl loggingConfig;

    public AttributeList getLogRecordsUsingQuery(String logFileName, Long fromRecord, Boolean next, Boolean forward, Integer requestedCount, Instant fromDate, Instant toDate, String logLevel, Boolean onlyLevel, List listOfModules, Properties nameValueMap, String anySearch) {
        long startingRecord;
        long reqCount;
        LogFile logFile = null;
        String logFileDetailsForServer = "";
        try {
            logFileDetailsForServer = this.loggingConfig.getLoggingFileDetails();
            logFileDetailsForServer = TranslatedConfigView.getTranslatedValue((Object)logFileDetailsForServer).toString();
            logFileDetailsForServer = new File(logFileDetailsForServer).getAbsolutePath();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "NCLS-LOGGING-00005", ex);
            return new AttributeList();
        }
        if (logFileName != null && ((String)logFileName).length() != 0) {
            logFileName = logFileDetailsForServer.substring(0, logFileDetailsForServer.lastIndexOf(File.separator)) + File.separator + ((String)logFileName).trim();
            if (new File((String)logFileName).exists()) {
                logFile = this.getLogFile((String)logFileName);
            } else {
                logFileName = logFileDetailsForServer;
                logFile = this.getLogFile((String)logFileName);
            }
        } else {
            logFileName = logFileDetailsForServer;
            logFile = this.getLogFile((String)logFileName);
        }
        boolean forwd = forward == null ? true : forward;
        boolean nxt = next == null ? true : next;
        long l = reqCount = requestedCount == null ? logFile.getIndexSize() : (long)requestedCount.intValue();
        if (fromRecord == -1L) {
            nxt = forwd;
            startingRecord = forwd ? -1L : (logFile.getLastIndexNumber() + 1L) * logFile.getIndexSize();
        } else {
            startingRecord = fromRecord;
            if (startingRecord < -1L) {
                throw new IllegalArgumentException("fromRecord must be greater than 0!");
            }
        }
        try {
            return this.fetchRecordsUsingQuery(logFile, startingRecord, nxt, forwd, reqCount, fromDate, toDate, logLevel, onlyLevel, listOfModules, nameValueMap, anySearch);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "NCLS-LOGGING-00005", ex);
            return new AttributeList();
        }
    }

    public List<String> getInstanceLogFileNames(String instanceName) {
        Server targetServer = this.domain.getServerNamed(instanceName);
        if (targetServer.isDas()) {
            String logFileDetailsForServer;
            try {
                logFileDetailsForServer = this.loggingConfig.getLoggingFileDetails();
                logFileDetailsForServer = TranslatedConfigView.getTranslatedValue((Object)logFileDetailsForServer).toString();
                logFileDetailsForServer = new File(logFileDetailsForServer).getAbsolutePath();
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "NCLS-LOGGING-00005", ex);
                return List.of();
            }
            File logsDir = new File(logFileDetailsForServer.substring(0, logFileDetailsForServer.lastIndexOf(File.separator)));
            File[] allLogFileNames = logsDir.listFiles();
            ArrayList<String> allInstanceFileNames = new ArrayList<String>();
            for (File file : allLogFileNames) {
                String fileName = file.getName();
                if (!file.isFile() || fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                allInstanceFileNames.add(fileName);
            }
            return allInstanceFileNames;
        }
        try {
            String instanceLogFileDetails = this.getInstanceLogFileDetails(targetServer);
            return new LogFilterForInstance().getInstanceLogFileNames(this.habitat, targetServer, this.domain, LOGGER, instanceName, instanceLogFileDetails);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "NCLS-LOGGING-00005", ex);
            return List.of();
        }
    }

    private String getInstanceLogFileDetails(Server targetServer) throws IOException {
        Cluster clusterForInstance = targetServer.getCluster();
        String targetConfigName = clusterForInstance == null ? targetServer.getConfigRef() : clusterForInstance.getConfigRef();
        return this.loggingConfig.getLoggingFileDetails(targetConfigName);
    }

    public String getLogFileForGivenTarget(String targetServerName) throws IOException {
        Server targetServer = this.domain.getServerNamed(targetServerName);
        String serverNode = targetServer.getNodeRef();
        if (targetServer.isDas()) {
            String logFileDetailsForServer = this.loggingConfig.getLoggingFileDetails();
            logFileDetailsForServer = TranslatedConfigView.getTranslatedValue((Object)logFileDetailsForServer).toString();
            logFileDetailsForServer = new File(logFileDetailsForServer).getAbsolutePath();
            return logFileDetailsForServer;
        }
        String logFileDetailsForInstance = this.getInstanceLogFileDetails(targetServer);
        Node node = this.domain.getNodes().getNode(serverNode);
        Object loggingDir = "";
        String loggingFile = "";
        if (logFileDetailsForInstance.contains("${com.sun.aas.instanceRoot}/logs") && node.getNodeDir() != null) {
            loggingDir = node.getNodeDir() + File.separator + serverNode + File.separator + targetServerName;
            loggingFile = logFileDetailsForInstance.replace("${com.sun.aas.instanceRoot}", (CharSequence)loggingDir);
        } else if (logFileDetailsForInstance.contains("${com.sun.aas.instanceRoot}/logs") && node.getInstallDir() != null) {
            loggingDir = node.getInstallDir() + File.separator + "glassfish" + File.separator + "nodes" + File.separator + serverNode + File.separator + targetServerName;
            loggingFile = logFileDetailsForInstance.replace("${com.sun.aas.instanceRoot}", (CharSequence)loggingDir);
        } else {
            loggingFile = logFileDetailsForInstance;
        }
        if (node.isLocal()) {
            return loggingFile;
        }
        String logFileName = logFileDetailsForInstance.substring(logFileDetailsForInstance.lastIndexOf(File.separator) + 1, logFileDetailsForInstance.length());
        File instanceFile = null;
        instanceFile = new LogFilterForInstance().downloadGivenInstanceLogFile(this.habitat, targetServer, this.domain, targetServerName, this.env.getInstanceRoot().getAbsolutePath(), logFileName, logFileDetailsForInstance);
        return instanceFile.getAbsolutePath();
    }

    public AttributeList getLogRecordsUsingQuery(String logFileName, Long fromRecord, Boolean next, Boolean forward, Integer requestedCount, Instant fromDate, Instant toDate, String logLevel, Boolean onlyLevel, List listOfModules, Properties nameValueMap, String anySearch, String instanceName) {
        long startingRecord;
        long reqCount;
        String instanceLogFileName;
        Server targetServer = this.domain.getServerNamed(instanceName);
        File instanceLogFile = null;
        if (targetServer.isDas()) {
            return this.getLogRecordsUsingQuery(logFileName, fromRecord, next, forward, requestedCount, fromDate, toDate, logLevel, onlyLevel, listOfModules, nameValueMap, anySearch);
        }
        String serverNode = targetServer.getNodeRef();
        Node node = this.domain.getNodes().getNode(serverNode);
        try {
            instanceLogFileName = this.getInstanceLogFileDetails(targetServer);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NCLS-LOGGING-00005", e);
            return new AttributeList();
        }
        if (node.isLocal()) {
            Path loggingDir = new LogFilterForInstance().getLoggingDirectoryForNode(instanceLogFileName, node, serverNode, instanceName);
            File logsDir = loggingDir.toFile();
            File[] allLogFileNames = logsDir.listFiles();
            boolean noFileFound = true;
            if (allLogFileNames != null) {
                for (File file : allLogFileNames) {
                    String fileName = file.getName();
                    if (!file.isFile() || fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                    noFileFound = false;
                    break;
                }
            }
            if (noFileFound) {
                loggingDir = new LogFilterForInstance().getLoggingDirectoryForNodeWhenNoFilesFound(instanceLogFileName, node, serverNode, instanceName);
            }
            if (!(instanceLogFile = loggingDir.resolve(logFileName).toFile()).exists()) {
                instanceLogFile = loggingDir.resolve("server.log").toFile();
            } else {
                loggingDir = new File(instanceLogFileName).toPath().getParent();
                instanceLogFile = new File(String.valueOf(loggingDir) + File.separator + logFileName);
                if (!instanceLogFile.exists()) {
                    instanceLogFile = new File(instanceLogFileName);
                }
            }
        } else {
            try {
                instanceLogFile = new LogFilterForInstance().downloadGivenInstanceLogFile(this.habitat, targetServer, this.domain, instanceName, this.env.getInstanceRoot().getAbsolutePath(), logFileName, instanceLogFileName);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "NCLS-LOGGING-00005", e);
                return new AttributeList();
            }
        }
        File loggingFileExists = new File(instanceLogFile.getAbsolutePath());
        if (!loggingFileExists.exists()) {
            LOGGER.log(Level.WARNING, "NCLS-LOGGING-00008", instanceLogFile.getAbsolutePath());
            return new AttributeList();
        }
        LogFile logFile = this.getLogFile(instanceLogFile.getAbsolutePath());
        boolean forwd = forward == null ? true : forward;
        boolean nxt = next == null ? true : next;
        long l = reqCount = requestedCount == null ? logFile.getIndexSize() : (long)requestedCount.intValue();
        if (fromRecord == -1L) {
            nxt = forwd;
            startingRecord = forwd ? -1L : (logFile.getLastIndexNumber() + 1L) * logFile.getIndexSize();
        } else {
            startingRecord = fromRecord;
            if (startingRecord < -1L) {
                throw new IllegalArgumentException("fromRecord must be greater than 0!");
            }
        }
        try {
            return this.fetchRecordsUsingQuery(logFile, startingRecord, nxt, forwd, reqCount, fromDate, toDate, logLevel, onlyLevel, listOfModules, nameValueMap, anySearch);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "NCLS-LOGGING-00005", ex);
            return new AttributeList();
        }
    }

    protected AttributeList fetchRecordsUsingQuery(LogFile logFile, long startingRecord, boolean next, boolean forward, long requestedCount, Instant fromDate, Instant toDate, String logLevel, boolean onlyLevel, List listOfModules, Properties nameValueMap, String anySearch) {
        boolean origForward = forward;
        if (next) {
            ++startingRecord;
            forward = true;
        } else {
            forward = false;
        }
        int inc = 1;
        int start = 0;
        int end = -1;
        long searchChunkIncrement = requestedCount;
        if (!forward) {
            inc = -1;
            if ((startingRecord -= next ? searchChunkIncrement - 1L : searchChunkIncrement) < 0L) {
                searchChunkIncrement += startingRecord;
                startingRecord = 0L;
            }
        }
        ArrayList<LogFile.LogEntry> results = new ArrayList<LogFile.LogEntry>();
        List<LogFile.LogEntry> records = null;
        LogFile.LogEntry entry = null;
        while ((long)results.size() < requestedCount && (records = logFile.getLogEntries(startingRecord, searchChunkIncrement)) != null) {
            if (forward) {
                end = records.size();
            } else {
                start = records.size() - 1;
            }
            for (int count = start; count != end && (long)results.size() < requestedCount; count += inc) {
                entry = records.get(count);
                if (!this.allChecks(entry, fromDate, toDate, logLevel, onlyLevel, listOfModules, nameValueMap, anySearch)) continue;
                results.add(entry);
            }
            if (forward) {
                if ((long)records.size() < searchChunkIncrement) break;
                startingRecord += searchChunkIncrement * (long)inc;
                searchChunkIncrement = requestedCount - (long)results.size();
                continue;
            }
            if (startingRecord == 0L) break;
            searchChunkIncrement = requestedCount - (long)results.size();
            if ((startingRecord += searchChunkIncrement * (long)inc) >= 1L) continue;
            searchChunkIncrement += startingRecord;
            startingRecord = 0L;
        }
        if (next ^ origForward) {
            ArrayList reversedResults = new ArrayList();
            for (int count = results.size() - 1; count > -1; --count) {
                reversedResults.add(results.get(count));
            }
            results = reversedResults;
        }
        return this.convertResultsToTheStructure(results);
    }

    private AttributeList convertResultsToTheStructure(List results) {
        if (results == null) {
            return null;
        }
        AttributeList resultsInTemplate = new AttributeList();
        resultsInTemplate.add(LogRecordTemplate.getHeader());
        Iterator iterator = results.iterator();
        ArrayList listOfResults = new ArrayList();
        Attribute resultsAttribute = new Attribute(RESULTS_ATTRIBUTE, listOfResults);
        resultsInTemplate.add(resultsAttribute);
        while (iterator.hasNext()) {
            LogFile.LogEntry entry = (LogFile.LogEntry)iterator.next();
            ArrayList<Object> logRecord = new ArrayList<Object>();
            logRecord.add(entry.getRecordNumber());
            logRecord.add(entry.getLoggedDateTime());
            logRecord.add(entry.getLoggedLevel());
            logRecord.add(entry.getLoggedProduct());
            logRecord.add(entry.getLoggedLoggerName());
            logRecord.add(entry.getLoggedNameValuePairs());
            logRecord.add(entry.getMessageId());
            logRecord.add(entry.getLoggedMessage());
            listOfResults.add(logRecord);
        }
        return resultsInTemplate;
    }

    public LogFile getLogFile() {
        return this.logFile;
    }

    public LogFile getLogFile(String fileName) {
        String logFileName = fileName.trim();
        LogFile logFile = logFileCache.get(fileName);
        String parent = null;
        if (logFile == null) {
            try {
                if (new File(fileName).exists()) {
                    logFile = new LogFile(fileName);
                    logFileCache.put(fileName, logFile);
                    return logFile;
                }
                parent = System.getProperty("com.sun.aas.instanceRoot");
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "NCLS-LOGGING-00005", e);
            }
            if (parent != null) {
                String[] logFileNameParts = new String[]{parent, logFileName};
                logFileName = StringUtils.makeFilePath((String[])logFileNameParts, (boolean)false);
            }
            logFile = new LogFile(logFileName);
            logFileCache.put(fileName, logFile);
        }
        return logFile;
    }

    protected boolean allChecks(LogFile.LogEntry entry, Instant fromDate, Instant toDate, String queryLevel, boolean onlyLevel, List listOfModules, Properties nameValueMap, String anySearch) {
        return this.dateTimeCheck(entry.getLoggedDateTime(), fromDate, toDate) && this.levelCheck(entry.getLoggedLevel(), queryLevel, onlyLevel) && this.moduleCheck(entry.getLoggedLoggerName(), listOfModules) && this.nameValueCheck(entry.getLoggedNameValuePairs(), nameValueMap) && this.messageDataCheck(entry.getLoggedMessage(), entry.getLoggedNameValuePairs(), anySearch);
    }

    protected boolean dateTimeCheck(OffsetDateTime loggedDateTime, Instant fromDateTime, Instant toDateTime) {
        if (fromDateTime == null || toDateTime == null) {
            return true;
        }
        return !loggedDateTime.isBefore(fromDateTime.atOffset(loggedDateTime.getOffset())) && !loggedDateTime.isAfter(toDateTime.atOffset(loggedDateTime.getOffset()));
    }

    protected boolean levelCheck(String loggedLevel, String queryLevelIn, boolean isOnlyLevelFlag) {
        if (queryLevelIn == null) {
            return true;
        }
        String queryLevel = queryLevelIn.trim();
        if (isOnlyLevelFlag) {
            return loggedLevel.equals(queryLevel);
        }
        try {
            int loggedLevelValue = Level.parse(loggedLevel).intValue();
            int queryLevelValue = Level.parse(queryLevelIn).intValue();
            return loggedLevelValue >= queryLevelValue;
        }
        catch (Exception e) {
            return true;
        }
    }

    protected boolean moduleCheck(String loggerName, List modules) {
        if (modules == null || modules.size() == 0) {
            return true;
        }
        loggerName = loggerName.trim();
        for (String module : modules) {
            if (!loggerName.equals(module = module.trim())) continue;
            return true;
        }
        return false;
    }

    protected boolean nameValueCheck(String loggedNameValuePairs, Properties queriedNameValueMap) {
        if (queriedNameValueMap == null || queriedNameValueMap.size() == 0) {
            return true;
        }
        if (loggedNameValuePairs == null) {
            return false;
        }
        StringTokenizer nvListTokenizer = new StringTokenizer(loggedNameValuePairs, NV_SEPARATOR);
        while (nvListTokenizer.hasMoreTokens()) {
            String nameandvalue = nvListTokenizer.nextToken();
            StringTokenizer nvToken = new StringTokenizer(nameandvalue, "=");
            if (nvToken.countTokens() < 2) continue;
            String loggedName = nvToken.nextToken();
            String loggedValue = nvToken.nextToken();
            for (Map.Entry<Object, Object> entry : queriedNameValueMap.entrySet()) {
                if (!entry.getKey().equals(loggedName)) continue;
                Object value = entry.getValue();
                Iterator iterator = ((List)value).iterator();
                while (iterator.hasNext()) {
                    if (!((String)iterator.next()).equals(loggedValue)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean messageDataCheck(String message, String nvp, String anySearch) {
        if (anySearch == null || "".contains(anySearch) || anySearch.length() < 3) {
            return true;
        }
        return message != null && message.contains(anySearch) || nvp != null && nvp.contains(anySearch);
    }
}

