/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.taglibs.standard.tlv;

import jakarta.servlet.jsp.tagext.PageData;
import jakarta.servlet.jsp.tagext.ValidationMessage;
import java.util.Set;
import java.util.Stack;
import org.glassfish.wasp.taglibs.standard.resources.Resources;
import org.glassfish.wasp.taglibs.standard.tlv.JstlBaseTLV;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class JstlCoreTLV
extends JstlBaseTLV {
    private final String CHOOSE = "choose";
    private final String WHEN = "when";
    private final String OTHERWISE = "otherwise";
    private final String EXPR = "out";
    private final String SET = "set";
    private final String IMPORT = "import";
    private final String URL = "url";
    private final String REDIRECT = "redirect";
    private final String PARAM = "param";
    private final String TEXT = "text";
    private final String VALUE = "value";
    private final String DEFAULT = "default";
    private final String VAR_READER = "varReader";
    private final String IMPORT_WITH_READER = "import varReader=''";
    private final String IMPORT_WITHOUT_READER = "import var=''";

    public ValidationMessage[] validate(String prefix, String uri, PageData page) {
        return super.validate(1, prefix, uri, page);
    }

    @Override
    protected DefaultHandler getHandler() {
        return new Handler();
    }

    private class Handler
    extends DefaultHandler {
        private int depth = 0;
        private final Stack<Integer> chooseDepths = new Stack();
        private final Stack<Boolean> chooseHasOtherwise = new Stack();
        private final Stack<Boolean> chooseHasWhen = new Stack();
        private final Stack<String> urlTags = new Stack();
        private String lastElementName = null;
        private boolean bodyNecessary = false;
        private boolean bodyIllegal = false;

        private Handler() {
        }

        @Override
        public void startElement(String nameSpace, String localName, String qualifiedName, Attributes attributes) {
            Set expAtts;
            if (localName == null) {
                localName = JstlCoreTLV.this.getLocalPart(qualifiedName);
            }
            if (JstlCoreTLV.this.isJspTag(nameSpace, localName, "text")) {
                return;
            }
            if (this.bodyIllegal) {
                JstlCoreTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_BODY", this.lastElementName));
            }
            if (qualifiedName.startsWith(JstlCoreTLV.this.prefix + ":") && (expAtts = (Set)JstlCoreTLV.this.config.get(localName)) != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String vMsg;
                    String attName = attributes.getLocalName(i);
                    if (!expAtts.contains(attName) || (vMsg = JstlCoreTLV.this.validateExpression(localName, attName, attributes.getValue(i))) == null) continue;
                    JstlCoreTLV.this.fail(vMsg);
                }
            }
            if (qualifiedName.startsWith(JstlCoreTLV.this.prefix + ":") && !JstlCoreTLV.this.hasNoInvalidScope(attributes)) {
                JstlCoreTLV.this.fail(Resources.getMessage("TLV_INVALID_ATTRIBUTE", "scope", qualifiedName, attributes.getValue("scope")));
            }
            if (qualifiedName.startsWith(JstlCoreTLV.this.prefix + ":") && JstlCoreTLV.this.hasEmptyVar(attributes)) {
                JstlCoreTLV.this.fail(Resources.getMessage("TLV_EMPTY_VAR", qualifiedName));
            }
            if (qualifiedName.startsWith(JstlCoreTLV.this.prefix + ":") && JstlCoreTLV.this.hasDanglingScope(attributes)) {
                JstlCoreTLV.this.fail(Resources.getMessage("TLV_DANGLING_SCOPE", qualifiedName));
            }
            if (this.chooseChild()) {
                if (JstlCoreTLV.this.isCoreTag(nameSpace, localName, "when")) {
                    this.chooseHasWhen.pop();
                    this.chooseHasWhen.push(Boolean.TRUE);
                }
                if (!JstlCoreTLV.this.isCoreTag(nameSpace, localName, "when") && !JstlCoreTLV.this.isCoreTag(nameSpace, localName, "otherwise")) {
                    JstlCoreTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_CHILD_TAG", JstlCoreTLV.this.prefix, "choose", qualifiedName));
                }
                if (this.chooseHasOtherwise.peek().booleanValue()) {
                    JstlCoreTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_ORDER", qualifiedName, JstlCoreTLV.this.prefix, "otherwise", "choose"));
                }
                if (JstlCoreTLV.this.isCoreTag(nameSpace, localName, "otherwise")) {
                    this.chooseHasOtherwise.pop();
                    this.chooseHasOtherwise.push(Boolean.TRUE);
                }
            }
            if (JstlCoreTLV.this.isCoreTag(nameSpace, localName, "param")) {
                if (this.urlTags.empty() || this.urlTags.peek().equals("param")) {
                    JstlCoreTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_ORPHAN", "param"));
                }
                if (!this.urlTags.empty() && this.urlTags.peek().equals("import varReader=''")) {
                    JstlCoreTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_PARAM", JstlCoreTLV.this.prefix, "param", "import", "varReader"));
                }
            } else if (!this.urlTags.empty() && this.urlTags.peek().equals("import var=''")) {
                JstlCoreTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_CHILD_TAG", JstlCoreTLV.this.prefix, "import", qualifiedName));
            }
            if (JstlCoreTLV.this.isCoreTag(nameSpace, localName, "choose")) {
                this.chooseDepths.push(this.depth);
                this.chooseHasWhen.push(Boolean.FALSE);
                this.chooseHasOtherwise.push(Boolean.FALSE);
            }
            if (JstlCoreTLV.this.isCoreTag(nameSpace, localName, "import")) {
                if (JstlCoreTLV.this.hasAttribute(attributes, "varReader")) {
                    this.urlTags.push("import varReader=''");
                } else {
                    this.urlTags.push("import var=''");
                }
            } else if (JstlCoreTLV.this.isCoreTag(nameSpace, localName, "param")) {
                this.urlTags.push("param");
            } else if (JstlCoreTLV.this.isCoreTag(nameSpace, localName, "redirect")) {
                this.urlTags.push("redirect");
            } else if (JstlCoreTLV.this.isCoreTag(nameSpace, localName, "url")) {
                this.urlTags.push("url");
            }
            this.bodyIllegal = false;
            this.bodyNecessary = false;
            if (JstlCoreTLV.this.isCoreTag(nameSpace, localName, "out")) {
                if (JstlCoreTLV.this.hasAttribute(attributes, "default")) {
                    this.bodyIllegal = true;
                }
            } else if (JstlCoreTLV.this.isCoreTag(nameSpace, localName, "set") && JstlCoreTLV.this.hasAttribute(attributes, "value")) {
                this.bodyIllegal = true;
            }
            this.lastElementName = qualifiedName;
            JstlCoreTLV.this.lastElementId = attributes.getValue("http://java.sun.com/JSP/Page", "id");
            ++this.depth;
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.bodyNecessary = false;
            String s = new String(ch, start, length).trim();
            if (s.equals("")) {
                return;
            }
            if (this.bodyIllegal) {
                JstlCoreTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_BODY", this.lastElementName));
            }
            if (!this.urlTags.empty() && this.urlTags.peek().equals("import var=''")) {
                JstlCoreTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_BODY", JstlCoreTLV.this.prefix + ":import"));
            }
            if (this.chooseChild()) {
                String msg = Resources.getMessage("TLV_ILLEGAL_TEXT_BODY", JstlCoreTLV.this.prefix, "choose", s.length() < 7 ? s : s.substring(0, 7));
                JstlCoreTLV.this.fail(msg);
            }
        }

        @Override
        public void endElement(String nameSpace, String localName, String qualifiedName) {
            if (JstlCoreTLV.this.isJspTag(nameSpace, localName, "text")) {
                return;
            }
            if (this.bodyNecessary) {
                JstlCoreTLV.this.fail(Resources.getMessage("TLV_MISSING_BODY", this.lastElementName));
            }
            this.bodyIllegal = false;
            if (JstlCoreTLV.this.isCoreTag(nameSpace, localName, "choose")) {
                Boolean b = this.chooseHasWhen.pop();
                if (!b.booleanValue()) {
                    JstlCoreTLV.this.fail(Resources.getMessage("TLV_PARENT_WITHOUT_SUBTAG", "choose", "when"));
                }
                this.chooseDepths.pop();
                this.chooseHasOtherwise.pop();
            }
            if (JstlCoreTLV.this.isCoreTag(nameSpace, localName, "import") || JstlCoreTLV.this.isCoreTag(nameSpace, localName, "param") || JstlCoreTLV.this.isCoreTag(nameSpace, localName, "redirect") || JstlCoreTLV.this.isCoreTag(nameSpace, localName, "url")) {
                this.urlTags.pop();
            }
            --this.depth;
        }

        private boolean chooseChild() {
            return !this.chooseDepths.empty() && this.depth - 1 == this.chooseDepths.peek();
        }
    }
}

