/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.DH;
import com.jcraft.jsch.HASH;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyExchange;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.Util;
import java.math.BigInteger;

abstract class DHGEX
extends KeyExchange {
    private static final int SSH_MSG_KEX_DH_GEX_GROUP = 31;
    private static final int SSH_MSG_KEX_DH_GEX_INIT = 32;
    private static final int SSH_MSG_KEX_DH_GEX_REPLY = 33;
    private static final int SSH_MSG_KEX_DH_GEX_REQUEST = 34;
    int min;
    int preferred;
    int max;
    private int state;
    DH dh;
    byte[] V_S;
    byte[] V_C;
    byte[] I_S;
    byte[] I_C;
    private Buffer buf;
    private Packet packet;
    private byte[] p;
    private byte[] g;
    private byte[] e;
    protected String hash;

    DHGEX() {
    }

    @Override
    public void init(Session session, byte[] V_S, byte[] V_C, byte[] I_S, byte[] I_C) throws Exception {
        Class<Object> c;
        this.V_S = V_S;
        this.V_C = V_C;
        this.I_S = I_S;
        this.I_C = I_C;
        try {
            c = Class.forName(session.getConfig(this.hash)).asSubclass(HASH.class);
            this.sha = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.sha.init();
        }
        catch (Exception e) {
            throw new JSchException(e.toString(), e);
        }
        this.buf = new Buffer();
        this.packet = new Packet(this.buf);
        try {
            c = Class.forName(session.getConfig("dh")).asSubclass(DH.class);
            this.min = Integer.parseInt(session.getConfig("dhgex_min"));
            this.max = Integer.parseInt(session.getConfig("dhgex_max"));
            this.preferred = Integer.parseInt(session.getConfig("dhgex_preferred"));
            if (this.min <= 0 || this.max <= 0 || this.preferred <= 0 || this.preferred < this.min || this.preferred > this.max) {
                throw new JSchException("Invalid DHGEX sizes: min=" + this.min + " max=" + this.max + " preferred=" + this.preferred);
            }
            this.dh = (DH)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.dh.init();
        }
        catch (Exception e) {
            throw new JSchException(e.toString(), e);
        }
        this.packet.reset();
        this.buf.putByte((byte)34);
        this.buf.putInt(this.min);
        this.buf.putInt(this.preferred);
        this.buf.putInt(this.max);
        session.write(this.packet);
        if (session.getLogger().isEnabled(1)) {
            session.getLogger().log(1, "SSH_MSG_KEX_DH_GEX_REQUEST(" + this.min + "<" + this.preferred + "<" + this.max + ") sent");
            session.getLogger().log(1, "expecting SSH_MSG_KEX_DH_GEX_GROUP");
        }
        this.state = 31;
    }

    @Override
    public boolean next(Buffer _buf) throws Exception {
        switch (this.state) {
            case 31: {
                _buf.getInt();
                _buf.getByte();
                int j = _buf.getByte();
                if (j != 31) {
                    if (this.session.getLogger().isEnabled(3)) {
                        this.session.getLogger().log(3, "type: must be SSH_MSG_KEX_DH_GEX_GROUP " + j);
                    }
                    return false;
                }
                this.p = _buf.getMPInt();
                this.g = _buf.getMPInt();
                int bits = new BigInteger(1, this.p).bitLength();
                if (bits < this.min || bits > this.max) {
                    return false;
                }
                this.dh.setP(this.p);
                this.dh.setG(this.g);
                this.e = this.dh.getE();
                this.packet.reset();
                this.buf.putByte((byte)32);
                this.buf.putMPInt(this.e);
                this.session.write(this.packet);
                if (this.session.getLogger().isEnabled(1)) {
                    this.session.getLogger().log(1, "SSH_MSG_KEX_DH_GEX_INIT sent");
                    this.session.getLogger().log(1, "expecting SSH_MSG_KEX_DH_GEX_REPLY");
                }
                this.state = 33;
                return true;
            }
            case 33: {
                int j = _buf.getInt();
                j = _buf.getByte();
                j = _buf.getByte();
                if (j != 33) {
                    if (this.session.getLogger().isEnabled(3)) {
                        this.session.getLogger().log(3, "type: must be SSH_MSG_KEX_DH_GEX_REPLY " + j);
                    }
                    return false;
                }
                this.K_S = _buf.getString();
                byte[] f = _buf.getMPInt();
                byte[] sig_of_H = _buf.getString();
                this.dh.setF(f);
                this.dh.checkRange();
                this.K = this.encodeAsMPInt(this.normalize(this.dh.getK()));
                this.buf.reset();
                this.buf.putString(this.V_C);
                this.buf.putString(this.V_S);
                this.buf.putString(this.I_C);
                this.buf.putString(this.I_S);
                this.buf.putString(this.K_S);
                this.buf.putInt(this.min);
                this.buf.putInt(this.preferred);
                this.buf.putInt(this.max);
                this.buf.putMPInt(this.p);
                this.buf.putMPInt(this.g);
                this.buf.putMPInt(this.e);
                this.buf.putMPInt(f);
                byte[] foo = new byte[this.buf.getLength()];
                this.buf.getByte(foo);
                this.sha.update(foo, 0, foo.length);
                this.sha.update(this.K, 0, this.K.length);
                this.H = this.sha.digest();
                int i = 0;
                j = 0;
                j = this.K_S[i++] << 24 & 0xFF000000 | this.K_S[i++] << 16 & 0xFF0000 | this.K_S[i++] << 8 & 0xFF00 | this.K_S[i++] & 0xFF;
                String alg = Util.byte2str(this.K_S, i, j);
                boolean result = this.verify(alg, this.K_S, i += j, sig_of_H);
                this.state = 0;
                return result;
            }
        }
        return false;
    }

    @Override
    public int getState() {
        return this.state;
    }
}

