/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.util.List;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="unset")
@PerLookup
public class UnsetCommand
extends CLICommand {
    @Param(name="environment-variable", primary=true, multiple=true)
    private List<String> vars;
    private static final LocalStringsImpl strings = new LocalStringsImpl(UnsetCommand.class);

    @Override
    public int executeCommand() throws CommandException, CommandValidationException {
        int ret = 0;
        for (String name : this.vars) {
            if (!name.startsWith(Environment.getPrefix())) {
                logger.info(strings.get("badEnvVarUnset", new Object[]{name, Environment.getPrefix()}));
                ret = -1;
                continue;
            }
            if (this.env.get(name) == null) {
                logger.info(strings.get("cantRemoveEnvVar", new Object[]{name}));
                ret = -1;
                continue;
            }
            this.env.remove(name);
        }
        return ret;
    }
}

